/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.IteratingRow;
import org.apache.cassandra.io.SSTableReader;
import org.apache.log4j.Logger;

public class FileStruct
implements Comparable<FileStruct>,
Iterator<String> {
    private static Logger logger = Logger.getLogger(FileStruct.class);
    private IteratingRow row;
    private boolean exhausted = false;
    private BufferedRandomAccessFile file;
    private SSTableReader sstable;
    private FileStructIterator iterator;

    FileStruct(SSTableReader sstable) throws IOException {
        this.file = new BufferedRandomAccessFile(sstable.getFilename(), "r", 262144);
        this.sstable = sstable;
    }

    public String getFileName() {
        return this.file.getPath();
    }

    public void close() throws IOException {
        this.file.close();
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    public String getKey() {
        return this.row.getKey();
    }

    public ColumnFamily getColumnFamily() {
        return this.row.getEmptyColumnFamily();
    }

    @Override
    public int compareTo(FileStruct f) {
        return this.sstable.getPartitioner().getDecoratedKeyComparator().compare(this.getKey(), f.getKey());
    }

    public void seekTo(String seekKey) {
        try {
            long position = this.sstable.getNearestPosition(seekKey);
            if (position < 0L) {
                this.exhausted = true;
                return;
            }
            this.file.seek(position);
            this.advance(false);
        }
        catch (IOException e) {
            throw new RuntimeException("corrupt sstable", e);
        }
    }

    public void advance(boolean materialize) throws IOException {
        if (this.exhausted) {
            throw new IndexOutOfBoundsException();
        }
        if (this.file.isEOF()) {
            this.file.close();
            this.exhausted = true;
            return;
        }
        this.row = new IteratingRow(this.file, this.sstable);
        if (materialize) {
            while (this.row.hasNext()) {
                IColumn column = (IColumn)this.row.next();
                this.row.getEmptyColumnFamily().addColumn(column);
            }
        } else {
            this.row.skipRemaining();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = new FileStructIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public String next() {
        if (this.iterator == null) {
            this.iterator = new FileStructIterator();
        }
        return (String)this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class FileStructIterator
    extends AbstractIterator<String> {
        public FileStructIterator() {
            if (FileStruct.this.row == null && !FileStruct.this.isExhausted()) {
                this.forward();
            }
        }

        private void forward() {
            try {
                FileStruct.this.advance(false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected String computeNext() {
            if (FileStruct.this.isExhausted()) {
                return (String)this.endOfData();
            }
            String oldKey = FileStruct.this.getKey();
            this.forward();
            return oldKey;
        }
    }
}

