/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.cassandra.io.SSTableReader;
import org.cliffc.high_scale_lib.NonBlockingHashMap;

class FileSSTableMap {
    private final Map<String, SSTableReader> map = new NonBlockingHashMap();

    FileSSTableMap() {
    }

    public SSTableReader get(String filename) {
        try {
            return this.map.get(new File(filename).getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SSTableReader put(String filename, SSTableReader value) {
        try {
            return this.map.put(new File(filename).getCanonicalPath(), value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<SSTableReader> values() {
        return this.map.values();
    }

    public void clear() {
        this.map.clear();
    }

    public void remove(String filename) throws IOException {
        this.map.remove(new File(filename).getCanonicalPath());
    }
}

