/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.JoinMessage;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.log4j.Logger;

class JoinVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(JoinVerbHandler.class);

    JoinVerbHandler() {
    }

    @Override
    public void doVerb(Message message) {
        EndPoint from = message.getFrom();
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Received a JoinMessage from " + from));
        }
        byte[] bytes = message.getMessageBody();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
        JoinMessage joinMessage = null;
        try {
            joinMessage = JoinMessage.serializer().deserialize(dis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (joinMessage.clusterId_.equals(DatabaseDescriptor.getClusterName())) {
            Gossiper.instance().join(from);
        }
    }
}

