/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.CompactEndPointSerializationHelper;
import org.apache.cassandra.net.EndPoint;

class GossipDigestSerializer
implements ICompactSerializer<GossipDigest> {
    GossipDigestSerializer() {
    }

    @Override
    public void serialize(GossipDigest gDigest, DataOutputStream dos) throws IOException {
        CompactEndPointSerializationHelper.serialize(gDigest.endPoint_, dos);
        dos.writeInt(gDigest.generation_);
        dos.writeInt(gDigest.maxVersion_);
    }

    @Override
    public GossipDigest deserialize(DataInputStream dis) throws IOException {
        EndPoint endPoint = CompactEndPointSerializationHelper.deserialize(dis);
        int generation = dis.readInt();
        int version = dis.readInt();
        return new GossipDigest(endPoint, generation, version);
    }
}

