/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.EndPointStatesSerializationHelper;
import org.apache.cassandra.gms.GossipDigest;
import org.apache.cassandra.gms.GossipDigestAckMessage;
import org.apache.cassandra.gms.GossipDigestSerializationHelper;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.EndPoint;

class GossipDigestAckMessageSerializer
implements ICompactSerializer<GossipDigestAckMessage> {
    GossipDigestAckMessageSerializer() {
    }

    @Override
    public void serialize(GossipDigestAckMessage gDigestAckMessage, DataOutputStream dos) throws IOException {
        boolean bContinue = GossipDigestSerializationHelper.serialize(gDigestAckMessage.gDigestList_, dos);
        dos.writeBoolean(bContinue);
        if (bContinue) {
            EndPointStatesSerializationHelper.serialize(gDigestAckMessage.epStateMap_, dos);
        }
    }

    @Override
    public GossipDigestAckMessage deserialize(DataInputStream dis) throws IOException {
        HashMap<EndPoint, EndPointState> epStateMap = new HashMap();
        List<GossipDigest> gDigestList = GossipDigestSerializationHelper.deserialize(dis);
        boolean bContinue = dis.readBoolean();
        if (bContinue) {
            epStateMap = EndPointStatesSerializationHelper.deserialize(dis);
        }
        return new GossipDigestAckMessage(gDigestList, epStateMap);
    }
}

