/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndPointState;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.log4j.Logger;

class EndPointStateSerializer
implements ICompactSerializer<EndPointState> {
    private static Logger logger_ = Logger.getLogger(EndPointStateSerializer.class);

    EndPointStateSerializer() {
    }

    @Override
    public void serialize(EndPointState epState, DataOutputStream dos) throws IOException {
        int estimate = 0;
        HeartBeatState hbState = epState.getHeartBeatState();
        HeartBeatState.serializer().serialize(hbState, dos);
        int size = epState.applicationState_.size();
        dos.writeInt(size);
        if (size > 0) {
            Set<String> keys = epState.applicationState_.keySet();
            for (String key : keys) {
                if (1428 - dos.size() < estimate) {
                    logger_.info((Object)("@@@@ Breaking out to respect the MTU size in EndPointState serializer. Estimate is " + estimate + " @@@@"));
                    break;
                }
                ApplicationState appState = epState.applicationState_.get(key);
                if (appState == null) continue;
                int pre = dos.size();
                dos.writeUTF(key);
                ApplicationState.serializer().serialize(appState, dos);
                int post = dos.size();
                estimate = post - pre;
            }
        }
    }

    @Override
    public EndPointState deserialize(DataInputStream dis) throws IOException {
        HeartBeatState hbState = HeartBeatState.serializer().deserialize(dis);
        EndPointState epState = new EndPointState(hbState);
        int appStateSize = dis.readInt();
        for (int i = 0; i < appStateSize && dis.available() != 0; ++i) {
            String key = dis.readUTF();
            ApplicationState appState = ApplicationState.serializer().deserialize(dis);
            epState.addApplicationState(key, appState);
        }
        return epState;
    }
}

