/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.service.StorageService;

public abstract class Token<T>
implements Comparable<Token<T>>,
Serializable {
    private static final TokenSerializer serializer = new TokenSerializer();
    T token;

    public static TokenSerializer serializer() {
        return serializer;
    }

    protected Token(T token) {
        this.token = token;
    }

    @Override
    public abstract int compareTo(Token<T> var1);

    public String toString() {
        return this.token.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        return this.token.equals(((Token)obj).token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public static class TokenSerializer
    implements ICompactSerializer<Token> {
        @Override
        public void serialize(Token token, DataOutputStream dos) throws IOException {
            IPartitioner p = StorageService.getPartitioner();
            byte[] b = p.getTokenFactory().toByteArray(token);
            dos.writeInt(b.length);
            dos.write(b);
        }

        @Override
        public Token deserialize(DataInputStream dis) throws IOException {
            IPartitioner p = StorageService.getPartitioner();
            int size = dis.readInt();
            byte[] bytes = new byte[size];
            dis.readFully(bytes);
            return p.getTokenFactory().fromByteArray(bytes);
        }
    }

    public static abstract class TokenFactory<T> {
        public abstract byte[] toByteArray(Token<T> var1);

        public abstract Token<T> fromByteArray(byte[] var1);

        public abstract String toString(Token<T> var1);

        public abstract Token<T> fromString(String var1);
    }
}

