/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.BigIntegerToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.GuidGenerator;

public class RandomPartitioner
implements IPartitioner<BigIntegerToken> {
    public static final BigInteger TWO = new BigInteger("2");
    public static final BigInteger MD5_MAX = TWO.pow(127);
    public static final BigIntegerToken MINIMUM = new BigIntegerToken("0");
    private static final Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            BigInteger i2;
            StringTokenizer st1 = new StringTokenizer(o1, ":");
            StringTokenizer st2 = new StringTokenizer(o2, ":");
            BigInteger i1 = new BigInteger(st1.nextToken());
            int v = i1.compareTo(i2 = new BigInteger(st2.nextToken()));
            if (v != 0) {
                return v;
            }
            return st1.nextToken().compareTo(st2.nextToken());
        }
    };
    private static final Comparator<String> rcomparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return -comparator.compare(o1, o2);
        }
    };
    private final Token.TokenFactory<BigInteger> tokenFactory = new Token.TokenFactory<BigInteger>(){

        @Override
        public byte[] toByteArray(Token<BigInteger> bigIntegerToken) {
            return ((BigInteger)bigIntegerToken.token).toByteArray();
        }

        @Override
        public Token<BigInteger> fromByteArray(byte[] bytes) {
            return new BigIntegerToken(new BigInteger(bytes));
        }

        @Override
        public String toString(Token<BigInteger> bigIntegerToken) {
            return ((BigInteger)bigIntegerToken.token).toString();
        }

        @Override
        public Token<BigInteger> fromString(String string) {
            return new BigIntegerToken(new BigInteger(string));
        }
    };

    @Override
    public String decorateKey(String key) {
        return FBUtilities.hash(key).toString() + ":" + key;
    }

    @Override
    public String undecorateKey(String decoratedKey) {
        return decoratedKey.split(":", 2)[1];
    }

    @Override
    public Comparator<String> getDecoratedKeyComparator() {
        return comparator;
    }

    @Override
    public Comparator<String> getReverseDecoratedKeyComparator() {
        return rcomparator;
    }

    @Override
    public BigIntegerToken midpoint(BigIntegerToken ltoken, BigIntegerToken rtoken) {
        BigInteger distance;
        BigInteger unchecked;
        BigInteger left = (BigInteger)ltoken.token;
        BigInteger right = (BigInteger)rtoken.token;
        BigInteger midpoint = left.compareTo(right) < 0 ? left.add(right).divide(TWO) : ((unchecked = (distance = MD5_MAX.add(right).subtract(left)).divide(TWO).add(left)).compareTo(MD5_MAX) > 0 ? unchecked.subtract(MD5_MAX) : unchecked);
        return new BigIntegerToken(midpoint);
    }

    @Override
    public BigIntegerToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BigIntegerToken getDefaultToken() {
        String initialToken = DatabaseDescriptor.getInitialToken();
        if (initialToken != null) {
            return new BigIntegerToken(new BigInteger(initialToken));
        }
        String guid = GuidGenerator.guid();
        BigInteger token = FBUtilities.hash(guid);
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    @Override
    public Token.TokenFactory<BigInteger> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public BigIntegerToken getToken(String key) {
        return new BigIntegerToken(FBUtilities.hash(key));
    }
}

