/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.BootstrapInitiateMessage;
import org.apache.cassandra.dht.BootstrapMetadata;
import org.apache.cassandra.dht.BootstrapMetadataMessage;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.io.StreamContextManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.StreamManager;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class BootstrapMetadataVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(BootstrapMetadataVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Received a BootstrapMetadataMessage from " + message.getFrom()));
        }
        assert (!StorageService.instance().isBootstrapMode());
        byte[] body = message.getMessageBody();
        DataInputBuffer bufIn = new DataInputBuffer();
        bufIn.reset(body, body.length);
        try {
            BootstrapMetadata[] bsMetadata;
            BootstrapMetadataMessage bsMetadataMessage = BootstrapMetadataMessage.serializer().deserialize(bufIn);
            for (BootstrapMetadata bsmd : bsMetadata = bsMetadataMessage.bsMetadata_) {
                if (!logger_.isDebugEnabled()) continue;
                logger_.debug((Object)bsmd.toString());
            }
            for (BootstrapMetadata bsmd : bsMetadata) {
                long startTime = System.currentTimeMillis();
                this.doTransfer(bsmd.target_, bsmd.ranges_);
                if (!logger_.isDebugEnabled()) continue;
                logger_.debug((Object)("Time taken to boostrap " + bsmd.target_ + " is " + (System.currentTimeMillis() - startTime) + " msecs."));
            }
        }
        catch (IOException ex) {
            logger_.info((Object)LogUtil.throwableToString(ex));
        }
    }

    private void doTransfer(EndPoint target, List<Range> ranges) throws IOException {
        if (ranges.size() == 0) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"No ranges to give scram ...");
            }
            return;
        }
        for (Range range : ranges) {
            StringBuilder sb = new StringBuilder("");
            sb.append(range.toString());
            sb.append(" ");
            if (!logger_.isDebugEnabled()) continue;
            logger_.debug((Object)("Beginning transfer process to " + target + " for ranges " + sb.toString()));
        }
        List<String> tables = DatabaseDescriptor.getTables();
        for (String tName : tables) {
            Table table = Table.open(tName);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Flushing memtables ...");
            }
            table.flush(false);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Forcing compaction ...");
            }
            ArrayList<String> fileList = new ArrayList<String>();
            table.forceCompaction(ranges, target, fileList);
            this.doHandoff(target, fileList, tName);
        }
    }

    private void doHandoff(EndPoint target, List<String> fileList, String table) throws IOException {
        ArrayList<File> filesList = new ArrayList<File>();
        for (String file : fileList) {
            filesList.add(new File(file));
        }
        File[] files = filesList.toArray(new File[0]);
        StreamContextManager.StreamContext[] streamContexts = new StreamContextManager.StreamContext[files.length];
        int i = 0;
        for (File file : files) {
            streamContexts[i] = new StreamContextManager.StreamContext(file.getAbsolutePath(), file.length(), table);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Stream context metadata " + streamContexts[i]));
            }
            ++i;
        }
        if (files.length > 0) {
            StreamManager.instance(target).addFilesToStream(streamContexts);
            BootstrapInitiateMessage biMessage = new BootstrapInitiateMessage(streamContexts);
            Message message = BootstrapInitiateMessage.makeBootstrapInitiateMessage(biMessage);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending a bootstrap initiate message to " + target + " ..."));
            }
            MessagingService.getMessagingInstance().sendOneWay(message, target);
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Waiting for transfer to " + target + " to complete"));
            }
            StreamManager.instance(target).waitForStreamCompletion();
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Done with transfer to " + target));
            }
        }
    }
}

