/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.ColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SSTableSliceIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.SSTableReader;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.log4j.Logger;

public class SliceQueryFilter
extends QueryFilter {
    private static Logger logger = Logger.getLogger(SliceQueryFilter.class);
    public final byte[] start;
    public final byte[] finish;
    public final boolean reversed;
    public final int count;

    public SliceQueryFilter(String key, QueryPath columnParent, byte[] start, byte[] finish, boolean reversed, int count) {
        super(key, columnParent);
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
    }

    @Override
    public ColumnIterator getMemColumnIterator(Memtable memtable, AbstractType comparator) {
        return memtable.getSliceIterator(this, comparator);
    }

    @Override
    public ColumnIterator getSSTableColumnIterator(SSTableReader sstable) throws IOException {
        return new SSTableSliceIterator(sstable, this.key, this.start, this.reversed);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        Comparator<byte[]> comparator;
        Object subcolumns;
        SuperColumn scFiltered = superColumn.cloneMeShallow();
        if (this.reversed) {
            ArrayList<IColumn> columnsAsList = new ArrayList<IColumn>(superColumn.getSubColumns());
            subcolumns = new ReverseListIterator(columnsAsList);
        } else {
            subcolumns = superColumn.getSubColumns().iterator();
        }
        Comparator<byte[]> comparator2 = comparator = this.reversed ? superColumn.getComparator().getReverseComparator() : superColumn.getComparator();
        while (subcolumns.hasNext()) {
            IColumn column = (IColumn)subcolumns.next();
            if (comparator.compare(column.name(), this.start) < 0) continue;
            subcolumns = IteratorUtils.chainedIterator((Iterator)IteratorUtils.singletonIterator((Object)column), (Iterator)subcolumns);
            break;
        }
        this.collectReducedColumns(scFiltered, (Iterator<IColumn>)subcolumns, gcBefore);
        return scFiltered;
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType comparator) {
        return this.reversed ? new ReverseComparator(super.getColumnComparator(comparator)) : super.getColumnComparator(comparator);
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        int liveColumns = 0;
        AbstractType comparator = container.getComparator();
        while (reducedColumns.hasNext() && liveColumns < this.count) {
            IColumn column = reducedColumns.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("collecting " + column.getString(comparator)));
            }
            if (this.finish.length > 0 && !this.reversed && comparator.compare(column.name(), this.finish) > 0 || this.reversed && comparator.compare(column.name(), this.finish) < 0) break;
            if (!(column.isMarkedForDelete() || container.isMarkedForDelete() && column.mostRecentChangeAt() <= container.getMarkedForDeleteAt())) {
                ++liveColumns;
            }
            if (column.isMarkedForDelete() && column.getLocalDeletionTime() <= gcBefore || container.isMarkedForDelete() && column.mostRecentChangeAt() <= container.getMarkedForDeleteAt()) continue;
            container.addColumn(column);
        }
    }
}

