/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CommitLog;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.MinorCompactionManager;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.BootstrapInitiateMessage;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.io.SSTableWriter;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.io.IStreamComplete;
import org.apache.cassandra.net.io.StreamContextManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FileUtils;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class Table {
    public static final String SYSTEM_TABLE = "system";
    private static Logger logger_ = Logger.getLogger(Table.class);
    private static final String SNAPSHOT_SUBDIR_NAME = "snapshots";
    private static Lock createLock_ = new ReentrantLock();
    private static Map<String, Table> instances_ = new HashMap<String, Table>();
    private String table_;
    private TableMetadata tableMetadata_;
    private Map<String, ColumnFamilyStore> columnFamilyStores_ = new HashMap<String, ColumnFamilyStore>();
    private SortedSet<String> applicationColumnFamilies_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table open(String table) throws IOException {
        Table tableInstance = instances_.get(table);
        if (tableInstance == null) {
            createLock_.lock();
            try {
                if (tableInstance == null) {
                    tableInstance = new Table(table);
                    instances_.put(table, tableInstance);
                }
            }
            finally {
                createLock_.unlock();
            }
        }
        return tableInstance;
    }

    public Set<String> getColumnFamilies() {
        return this.tableMetadata_.getColumnFamilies();
    }

    Map<String, ColumnFamilyStore> getColumnFamilyStores() {
        return this.columnFamilyStores_;
    }

    public ColumnFamilyStore getColumnFamilyStore(String cfName) {
        return this.columnFamilyStores_.get(cfName);
    }

    public String tableStats(String newLineSeparator, DecimalFormat df) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.table_ + " statistics :");
        sb.append(newLineSeparator);
        int oldLength = sb.toString().length();
        Set<String> cfNames = this.columnFamilyStores_.keySet();
        for (String cfName : cfNames) {
            ColumnFamilyStore cfStore = this.columnFamilyStores_.get(cfName);
            sb.append(cfStore.cfStats(newLineSeparator));
        }
        int newLength = sb.toString().length();
        if (newLength == oldLength) {
            return "";
        }
        return sb.toString();
    }

    public void onStart() throws IOException {
        for (String columnFamily : this.tableMetadata_.getColumnFamilies()) {
            this.columnFamilyStores_.get(columnFamily).onStart();
        }
    }

    public void forceCleanup() {
        Set<String> columnFamilies = this.tableMetadata_.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores_.get(columnFamily);
            if (cfStore == null) continue;
            cfStore.forceCleanup();
        }
    }

    public void snapshot(String clientSuppliedName) throws IOException {
        String snapshotName = Long.toString(System.currentTimeMillis());
        if (clientSuppliedName != null && !clientSuppliedName.equals("")) {
            snapshotName = snapshotName + "-" + clientSuppliedName;
        }
        for (ColumnFamilyStore cfStore : this.columnFamilyStores_.values()) {
            cfStore.snapshot(snapshotName);
        }
    }

    public void clearSnapshot() throws IOException {
        for (String dataDirPath : DatabaseDescriptor.getAllDataFileLocations()) {
            String snapshotPath = dataDirPath + File.separator + this.table_ + File.separator + SNAPSHOT_SUBDIR_NAME;
            File snapshotDir = new File(snapshotPath);
            if (!snapshotDir.exists()) continue;
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Removing snapshot directory " + snapshotPath));
            }
            if (FileUtils.deleteDir(snapshotDir)) continue;
            throw new IOException("Could not clear snapshot directory " + snapshotPath);
        }
    }

    public boolean forceCompaction(List<Range> ranges, EndPoint target, List<String> fileList) {
        boolean result = true;
        Set<String> columnFamilies = this.tableMetadata_.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore;
            if (!this.isApplicationColumnFamily(columnFamily) || (cfStore = this.columnFamilyStores_.get(columnFamily)) == null) continue;
            cfStore.forceCompaction(ranges, target, 0L, fileList);
        }
        return result;
    }

    public void forceCompaction() {
        Set<String> columnFamilies = this.tableMetadata_.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores_.get(columnFamily);
            if (cfStore == null) continue;
            MinorCompactionManager.instance().submitMajor(cfStore, 0L);
        }
    }

    public List<SSTableReader> getAllSSTablesOnDisk() {
        ArrayList<SSTableReader> list = new ArrayList<SSTableReader>();
        Set<String> columnFamilies = this.tableMetadata_.getColumnFamilies();
        for (String columnFamily : columnFamilies) {
            ColumnFamilyStore cfStore = this.columnFamilyStores_.get(columnFamily);
            if (cfStore == null) continue;
            list.addAll(cfStore.getSSTables());
        }
        return list;
    }

    private Table(String table) throws IOException {
        this.table_ = table;
        this.tableMetadata_ = TableMetadata.instance(table);
        for (String columnFamily : this.tableMetadata_.getColumnFamilies()) {
            this.columnFamilyStores_.put(columnFamily, ColumnFamilyStore.getColumnFamilyStore(table, columnFamily));
        }
    }

    boolean isApplicationColumnFamily(String columnFamily) {
        return DatabaseDescriptor.isApplicationColumnFamily(columnFamily);
    }

    int getColumnFamilyId(String columnFamily) {
        return this.tableMetadata_.getColumnFamilyId(columnFamily);
    }

    boolean isValidColumnFamily(String columnFamily) {
        return this.tableMetadata_.isValidColumnFamily(columnFamily);
    }

    @Deprecated
    public Row get(String key) throws IOException {
        Row row = new Row(this.table_, key);
        for (String columnFamily : this.getColumnFamilies()) {
            ColumnFamily cf = this.get(key, columnFamily);
            if (cf == null) continue;
            row.addColumnFamily(cf);
        }
        return row;
    }

    @Deprecated
    public ColumnFamily get(String key, String cfName) throws IOException {
        ColumnFamilyStore cfStore = this.columnFamilyStores_.get(cfName);
        assert (cfStore != null) : "Column family " + cfName + " has not been defined";
        return cfStore.getColumnFamily(new IdentityQueryFilter(key, new QueryPath(cfName)));
    }

    @Deprecated
    public Row getRow(String key, String cfName) throws IOException {
        Row row = new Row(this.table_, key);
        ColumnFamily columnFamily = this.get(key, cfName);
        if (columnFamily != null) {
            row.addColumnFamily(columnFamily);
        }
        return row;
    }

    public Row getRow(QueryFilter filter) throws IOException {
        ColumnFamilyStore cfStore = this.columnFamilyStores_.get(filter.getColumnFamilyName());
        Row row = new Row(this.table_, filter.key);
        ColumnFamily columnFamily = cfStore.getColumnFamily(filter);
        if (columnFamily != null) {
            row.addColumnFamily(columnFamily);
        }
        return row;
    }

    void apply(Row row) throws IOException {
        CommitLog.CommitLogContext cLogCtx = CommitLog.open().add(row);
        for (ColumnFamily columnFamily : row.getColumnFamilies()) {
            ColumnFamilyStore cfStore = this.columnFamilyStores_.get(columnFamily.name());
            cfStore.apply(row.key(), columnFamily, cLogCtx);
        }
    }

    void applyNow(Row row) throws IOException {
        String key = row.key();
        for (ColumnFamily columnFamily : row.getColumnFamilies()) {
            ColumnFamilyStore cfStore = this.columnFamilyStores_.get(columnFamily.name());
            cfStore.applyNow(key, columnFamily);
        }
    }

    public void flush(boolean fRecovery) throws IOException {
        for (String cfName : this.columnFamilyStores_.keySet()) {
            if (fRecovery) {
                this.columnFamilyStores_.get(cfName).flushMemtableOnRecovery();
                continue;
            }
            this.columnFamilyStores_.get(cfName).forceFlush();
        }
    }

    void load(Row row) throws IOException {
        String key = row.key();
        for (ColumnFamily columnFamily : row.getColumnFamilies()) {
            Collection<IColumn> columns = columnFamily.getSortedColumns();
            for (IColumn column : columns) {
                ColumnFamilyStore cfStore = this.columnFamilyStores_.get(new String(column.name(), "UTF-8"));
                cfStore.applyBinary(key, column.value());
            }
        }
        row.clear();
    }

    public SortedSet<String> getApplicationColumnFamilies() {
        if (this.applicationColumnFamilies_ == null) {
            this.applicationColumnFamilies_ = new TreeSet<String>();
            for (String cfName : this.getColumnFamilies()) {
                if (!DatabaseDescriptor.isApplicationColumnFamily(cfName)) continue;
                this.applicationColumnFamilies_.add(cfName);
            }
        }
        return this.applicationColumnFamilies_;
    }

    public static String getSnapshotPath(String dataDirPath, String tableName, String snapshotName) {
        return dataDirPath + File.separator + tableName + File.separator + SNAPSHOT_SUBDIR_NAME + File.separator + snapshotName;
    }

    public static class BootStrapInitiateVerbHandler
    implements IVerbHandler {
        @Override
        public void doVerb(Message message) {
            byte[] body = message.getMessageBody();
            DataInputBuffer bufIn = new DataInputBuffer();
            bufIn.reset(body, body.length);
            try {
                BootstrapInitiateMessage biMsg = BootstrapInitiateMessage.serializer().deserialize(bufIn);
                StreamContextManager.StreamContext[] streamContexts = biMsg.getStreamContext();
                Map<String, String> fileNames = this.getNewNames(streamContexts);
                for (StreamContextManager.StreamContext streamContext : streamContexts) {
                    StreamContextManager.StreamStatus streamStatus = new StreamContextManager.StreamStatus(streamContext.getTargetFile(), streamContext.getExpectedBytes());
                    String file = this.getNewFileNameFromOldContextAndNames(fileNames, streamContext);
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Received Data from  : " + message.getFrom() + " " + streamContext.getTargetFile() + " " + file));
                    }
                    streamContext.setTargetFile(file);
                    this.addStreamContext(message.getFrom().getHost(), streamContext, streamStatus);
                }
                StreamContextManager.registerStreamCompletionHandler(message.getFrom().getHost(), new BootstrapCompletionHandler());
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)"Sending a bootstrap initiate done message ...");
                }
                Message doneMessage = new Message(StorageService.getLocalStorageEndPoint(), "", "BOOTSTRAP-INITIATE-DONE-VERB-HANDLER", new byte[0]);
                MessagingService.getMessagingInstance().sendOneWay(doneMessage, message.getFrom());
            }
            catch (IOException ex) {
                logger_.info((Object)LogUtil.throwableToString(ex));
            }
        }

        String getNewFileNameFromOldContextAndNames(Map<String, String> fileNames, StreamContextManager.StreamContext streamContext) {
            File sourceFile = new File(streamContext.getTargetFile());
            String[] piece = FBUtilities.strip(sourceFile.getName(), "-");
            String cfName = piece[0];
            String ssTableNum = piece[1];
            String typeOfFile = piece[2];
            String newFileNameExpanded = fileNames.get(streamContext.getTable() + "-" + cfName + "-" + ssTableNum);
            String newFileName = newFileNameExpanded.replace("Data.db", typeOfFile);
            String file = DatabaseDescriptor.getDataFileLocationForTable(streamContext.getTable()) + File.separator + newFileName;
            return file;
        }

        Map<String, String> getNewNames(StreamContextManager.StreamContext[] streamContexts) throws IOException {
            HashMap<String, String> fileNames = new HashMap<String, String>();
            HashSet<String> distinctEntries = new HashSet<String>();
            for (StreamContextManager.StreamContext streamContext : streamContexts) {
                String[] pieces = FBUtilities.strip(new File(streamContext.getTargetFile()).getName(), "-");
                distinctEntries.add(streamContext.getTable() + "-" + pieces[0] + "-" + pieces[1]);
            }
            for (String distinctEntry : distinctEntries) {
                String[] peices = FBUtilities.strip(distinctEntry, "-");
                String tableName = peices[0];
                Table table = Table.open(tableName);
                Map<String, ColumnFamilyStore> columnFamilyStores = table.getColumnFamilyStores();
                ColumnFamilyStore cfStore = columnFamilyStores.get(peices[1]);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Generating file name for " + distinctEntry + " ..."));
                }
                fileNames.put(distinctEntry, cfStore.getTempSSTableFileName());
            }
            return fileNames;
        }

        private void addStreamContext(String host, StreamContextManager.StreamContext streamContext, StreamContextManager.StreamStatus streamStatus) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Adding stream context " + streamContext + " for " + host + " ..."));
            }
            StreamContextManager.addStreamContext(host, streamContext, streamStatus);
        }
    }

    public static class BootstrapCompletionHandler
    implements IStreamComplete {
        @Override
        public void onStreamCompletion(String host, StreamContextManager.StreamContext streamContext, StreamContextManager.StreamStatus streamStatus) throws IOException {
            if (streamContext.getTargetFile().contains("-Data.db")) {
                String tableName = streamContext.getTable();
                File file = new File(streamContext.getTargetFile());
                String fileName = file.getName();
                String[] temp = fileName.split("-");
                SSTableReader sstable = null;
                try {
                    sstable = SSTableWriter.renameAndOpen(streamContext.getTargetFile());
                    Table.open(tableName).getColumnFamilyStore(temp[0]).addToList(sstable);
                    logger_.info((Object)("Bootstrap added " + sstable.getFilename()));
                }
                catch (IOException e) {
                    logger_.error((Object)("Not able to bootstrap with file " + streamContext.getTargetFile()), (Throwable)e);
                }
            }
            EndPoint to = new EndPoint(host, DatabaseDescriptor.getStoragePort());
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Sending a bootstrap terminate message with " + streamStatus + " to " + to));
            }
            StreamContextManager.StreamStatusMessage streamStatusMessage = new StreamContextManager.StreamStatusMessage(streamStatus);
            Message message = StreamContextManager.StreamStatusMessage.makeStreamStatusMessage(streamStatusMessage);
            MessagingService.getMessagingInstance().sendOneWay(message, to);
            if (StreamContextManager.isDone(to.getHost())) {
                StorageService.instance().removeBootstrapSource(to);
            }
        }
    }

    public static class TableMetadata {
        private static HashMap<String, TableMetadata> tableMetadataMap_ = new HashMap();
        private static Map<Integer, String> idCfMap_ = new HashMap<Integer, String>();
        private Map<String, String> cfTypeMap_ = new HashMap<String, String>();
        private Map<String, Integer> cfIdMap_ = new HashMap<String, Integer>();

        public static synchronized TableMetadata instance(String tableName) throws IOException {
            if (tableMetadataMap_.get(tableName) == null) {
                tableMetadataMap_.put(tableName, new TableMetadata());
            }
            return tableMetadataMap_.get(tableName);
        }

        public void add(String cf, int id) {
            this.add(cf, id, "Standard");
        }

        public void add(String cf, int id, String type) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("adding " + cf + " as " + id));
            }
            assert (!idCfMap_.containsKey(id));
            this.cfIdMap_.put(cf, id);
            idCfMap_.put(id, cf);
            this.cfTypeMap_.put(cf, type);
        }

        public boolean isEmpty() {
            return this.cfIdMap_.isEmpty();
        }

        int getColumnFamilyId(String columnFamily) {
            return this.cfIdMap_.get(columnFamily);
        }

        public static String getColumnFamilyName(int id) {
            return idCfMap_.get(id);
        }

        String getColumnFamilyType(String cfName) {
            return this.cfTypeMap_.get(cfName);
        }

        Set<String> getColumnFamilies() {
            return this.cfIdMap_.keySet();
        }

        int size() {
            return this.cfIdMap_.size();
        }

        boolean isValidColumnFamily(String cfName) {
            return this.cfIdMap_.containsKey(cfName);
        }

        public String toString() {
            return "TableMetadata(" + FBUtilities.mapToString(this.cfIdMap_) + ")";
        }

        public static int getColumnFamilyCount() {
            return idCfMap_.size();
        }

        public static String getColumnFamilyIDString() {
            return FBUtilities.mapToString(tableMetadataMap_);
        }

        static {
            try {
                DatabaseDescriptor.storeMetadata();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

