/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ICompactSerializer2;

class SuperColumnSerializer
implements ICompactSerializer2<IColumn> {
    private AbstractType comparator;

    public SuperColumnSerializer(AbstractType comparator) {
        this.comparator = comparator;
    }

    public AbstractType getComparator() {
        return this.comparator;
    }

    @Override
    public void serialize(IColumn column, DataOutput dos) throws IOException {
        SuperColumn superColumn = (SuperColumn)column;
        ColumnSerializer.writeName(column.name(), dos);
        dos.writeInt(superColumn.getLocalDeletionTime());
        dos.writeLong(superColumn.getMarkedForDeleteAt());
        Collection<IColumn> columns = column.getSubColumns();
        dos.writeInt(columns.size());
        for (IColumn subColumn : columns) {
            Column.serializer().serialize(subColumn, dos);
        }
    }

    @Override
    public IColumn deserialize(DataInput dis) throws IOException {
        byte[] name = ColumnSerializer.readName(dis);
        SuperColumn superColumn = new SuperColumn(name, this.comparator);
        superColumn.markForDeleteAt(dis.readInt(), dis.readLong());
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            Column subColumn = Column.serializer().deserialize(dis);
            superColumn.addColumn(subColumn);
        }
        return superColumn;
    }
}

