/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.service.ColumnParent;

public class SliceFromReadCommand
extends ReadCommand {
    public final byte[] start;
    public final byte[] finish;
    public final boolean reversed;
    public final int count;

    public SliceFromReadCommand(String table, String key, ColumnParent column_parent, byte[] start, byte[] finish, boolean reversed, int count) {
        this(table, key, new QueryPath(column_parent), start, finish, reversed, count);
    }

    public SliceFromReadCommand(String table, String key, QueryPath path, byte[] start, byte[] finish, boolean reversed, int count) {
        super(table, key, path, (byte)2);
        this.start = start;
        this.finish = finish;
        this.reversed = reversed;
        this.count = count;
    }

    @Override
    public ReadCommand copy() {
        SliceFromReadCommand readCommand = new SliceFromReadCommand(this.table, this.key, this.queryPath, this.start, this.finish, this.reversed, this.count);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public Row getRow(Table table) throws IOException {
        return table.getRow(new SliceQueryFilter(this.key, this.queryPath, this.start, this.finish, this.reversed, this.count));
    }

    public String toString() {
        return "SliceFromReadCommand(table='" + this.table + '\'' + ", key='" + this.key + '\'' + ", column_parent='" + this.queryPath + '\'' + ", start='" + this.getComparator().getString(this.start) + '\'' + ", finish='" + this.getComparator().getString(this.finish) + '\'' + ", reversed=" + this.reversed + ", count=" + this.count + ')';
    }
}

