/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.cassandra.db.RangeCommandSerializer;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;

public class RangeCommand {
    private static RangeCommandSerializer serializer = new RangeCommandSerializer();
    public final String table;
    public final String columnFamily;
    public final String startWith;
    public final String stopAt;
    public final int maxResults;

    public RangeCommand(String table, String columnFamily, String startWith, String stopAt, int maxResults) {
        this.table = table;
        this.columnFamily = columnFamily;
        this.startWith = startWith;
        this.stopAt = stopAt;
        this.maxResults = maxResults;
    }

    public Message getMessage() throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        serializer.serialize(this, (DataOutputStream)dob);
        return new Message(StorageService.getLocalStorageEndPoint(), "ROW-READ-STAGE", "RANGE-VERB-HANDLER", Arrays.copyOf(dob.getData(), dob.getLength()));
    }

    public static RangeCommand read(Message message) throws IOException {
        byte[] bytes = message.getMessageBody();
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(bytes, bytes.length);
        return serializer.deserialize(new DataInputStream(dib));
    }

    public String toString() {
        return "RangeCommand(table='" + this.table + '\'' + ", columnFamily=" + this.columnFamily + ", startWith='" + this.startWith + '\'' + ", stopAt='" + this.stopAt + '\'' + ", maxResults=" + this.maxResults + ')';
    }
}

