/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.BitSetSerializer;

class CommitLogHeader {
    private static CommitLogHeaderSerializer serializer = new CommitLogHeaderSerializer();
    private BitSet dirty;
    private int[] lastFlushedAt;

    static CommitLogHeaderSerializer serializer() {
        return serializer;
    }

    static int getLowestPosition(CommitLogHeader clHeader) {
        int minPosition = Integer.MAX_VALUE;
        for (int position : clHeader.lastFlushedAt) {
            if (position >= minPosition || position <= 0) continue;
            minPosition = position;
        }
        if (minPosition == Integer.MAX_VALUE) {
            minPosition = 0;
        }
        return minPosition;
    }

    CommitLogHeader(int size) {
        this.dirty = new BitSet(size);
        this.lastFlushedAt = new int[size];
    }

    CommitLogHeader(BitSet dirty, int[] lastFlushedAt) {
        this.dirty = dirty;
        this.lastFlushedAt = lastFlushedAt;
    }

    CommitLogHeader(CommitLogHeader clHeader) {
        this.dirty = (BitSet)clHeader.dirty.clone();
        this.lastFlushedAt = new int[clHeader.lastFlushedAt.length];
        System.arraycopy(clHeader.lastFlushedAt, 0, this.lastFlushedAt, 0, this.lastFlushedAt.length);
    }

    boolean isDirty(int index) {
        return this.dirty.get(index);
    }

    int getPosition(int index) {
        return this.lastFlushedAt[index];
    }

    void turnOn(int index, long position) {
        this.dirty.set(index);
        this.lastFlushedAt[index] = (int)position;
    }

    void turnOff(int index) {
        this.dirty.set(index, false);
        this.lastFlushedAt[index] = 0;
    }

    boolean isSafeToDelete() throws IOException {
        return this.dirty.isEmpty();
    }

    void clear() {
        this.dirty.clear();
        Arrays.fill(this.lastFlushedAt, 0);
    }

    byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        CommitLogHeader.serializer().serialize(this, dos);
        return bos.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < this.dirty.size(); ++i) {
            sb.append(this.dirty.get(i) ? 0 : 1);
            sb.append(":");
            sb.append(Table.TableMetadata.getColumnFamilyName(i));
            sb.append(" ");
        }
        sb.append(" | ");
        for (int position : this.lastFlushedAt) {
            sb.append(position);
            sb.append(" ");
        }
        return sb.toString();
    }

    public String dirtyString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.dirty.length(); ++i) {
            if (!this.dirty.get(i)) continue;
            sb.append(i).append(", ");
        }
        return sb.toString();
    }

    static class CommitLogHeaderSerializer
    implements ICompactSerializer<CommitLogHeader> {
        CommitLogHeaderSerializer() {
        }

        @Override
        public void serialize(CommitLogHeader clHeader, DataOutputStream dos) throws IOException {
            BitSetSerializer.serialize(clHeader.dirty, dos);
            dos.writeInt(clHeader.lastFlushedAt.length);
            for (int position : clHeader.lastFlushedAt) {
                dos.writeInt(position);
            }
        }

        @Override
        public CommitLogHeader deserialize(DataInputStream dis) throws IOException {
            BitSet bitFlags = BitSetSerializer.deserialize(dis);
            int[] position = new int[dis.readInt()];
            for (int i = 0; i < position.length; ++i) {
                position[i] = dis.readInt();
            }
            return new CommitLogHeader(bitFlags, position);
        }
    }
}

