/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.cassandra.concurrent.Context;
import org.apache.cassandra.concurrent.ThreadLocalContext;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public final class DebuggableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static Logger logger_ = Logger.getLogger(DebuggableScheduledThreadPoolExecutor.class);

    public DebuggableScheduledThreadPoolExecutor(int threads, ThreadFactory threadFactory) {
        super(threads, threadFactory);
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null) {
            Throwable cause;
            Context ctx = ThreadLocalContext.get();
            if (ctx != null) {
                Object object = ctx.get(r.getClass().getName());
                if (object != null) {
                    logger_.info((Object)("**** In afterExecute() " + t.getClass().getName() + " occured while working with " + object + " ****"));
                } else {
                    logger_.info((Object)("**** In afterExecute() " + t.getClass().getName() + " occured ****"));
                }
            }
            if ((cause = t.getCause()) != null) {
                logger_.info((Object)LogUtil.throwableToString(cause));
            }
            logger_.info((Object)LogUtil.throwableToString(t));
        }
    }
}

