/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.sdk;

import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.utils.SDKUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SDKS3ReadExample {
    public static void main(String[] args) throws Exception {
        int i;
        Logger logger = LogServiceFactory.getLogService((String)SDKS3ReadExample.class.getName());
        if (args == null || args.length < 3) {
            logger.error((Object)"Usage: java CarbonS3Example: <access-key> <secret-key><s3-endpoint> [table-path-on-s3]");
            System.exit(0);
        }
        String path = "s3a://sdk/WriterOutput/carbondata5";
        if (args.length > 3) {
            path = args[3];
        }
        Configuration conf = new Configuration();
        conf.set("fs.s3a.access.key", args[0]);
        conf.set("fs.s3a.secret.key", args[1]);
        conf.set("fs.s3a.endpoint", args[2]);
        ArrayList fileLists = SDKUtil.listFiles((String)path, (String)".carbondata", (Configuration)conf);
        EqualToExpression equalToExpression = new EqualToExpression((Expression)new ColumnExpression("name", DataTypes.STRING), (Expression)new LiteralExpression((Object)"robot1", DataTypes.STRING));
        CarbonReader reader = CarbonReader.builder().projection(new String[]{"name", "age"}).filter((Expression)equalToExpression).withHadoopConf("fs.s3a.access.key", args[0]).withHadoopConf("fs.s3a.secret.key", args[1]).withHadoopConf("fs.s3a.endpoint", args[2]).withFileLists((List)fileLists).build();
        System.out.println("\nData:");
        for (i = 0; i < 20 && reader.hasNext(); ++i) {
            Object[] row = (Object[])reader.readNextRow();
            System.out.println(row[0] + " " + row[1]);
        }
        System.out.println("\nFinished");
        reader.close();
        CarbonReader reader2 = CarbonReader.builder((String)path, (String)"_temp").projection(new String[]{"name", "age"}).withHadoopConf("fs.s3a.access.key", args[0]).withHadoopConf("fs.s3a.secret.key", args[1]).withHadoopConf("fs.s3a.endpoint", args[2]).build();
        System.out.println("\nData:");
        for (i = 0; i < 20 && reader2.hasNext(); ++i) {
            Object[] row = (Object[])reader2.readNextRow();
            System.out.println(row[0] + " " + row[1]);
        }
        System.out.println("\nFinished");
        reader2.close();
    }
}

