/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.io.Serializable;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.StandardPartitionExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class StandardPartitionExample$ {
    public static StandardPartitionExample$ MODULE$;

    static {
        new StandardPartitionExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createSparkSession("StandardPartitionExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy/MM/dd");
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        String testData = new StringBuilder(64).append(rootPath).append("/integration/spark/src/test/resources/").append("partition_data_example.csv").toString();
        spark.sql("DROP TABLE IF EXISTS origintable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE origintable\n        | (id Int,\n        | vin String,\n        | logdate Date,\n        | phonenumber Long,\n        | country String,\n        | area String,\n        | salary Int)\n        | STORED AS carbondata\n      ")).stripMargin());
        spark.sql(new StringBuilder(64).append("\n       LOAD DATA LOCAL INPATH '").append(testData).append("' into table origintable\n       ").toString());
        spark.sql("select * from origintable").show(false);
        spark.sql("DROP TABLE IF EXISTS partitiontable0");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE partitiontable0\n        | (id Int,\n        | vin String,\n        | phonenumber Long,\n        | country String,\n        | area String,\n        | salary Int)\n        | PARTITIONED BY (logdate Date)\n        | STORED AS carbondata\n        | TBLPROPERTIES('SORT_COLUMNS'='id,vin')\n      ")).stripMargin());
        spark.sql(new StringBuilder(68).append("\n       LOAD DATA LOCAL INPATH '").append(testData).append("' into table partitiontable0\n       ").toString());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT logdate,id,vin,phonenumber,country,area,salary\n         | FROM partitiontable0 where logdate = cast('2016-02-12' as date)\n      ")).stripMargin()).show(100, false);
        spark.sql("show partitions default.partitiontable0").show();
        spark.sql("insert into table partitiontable0 partition(logdate='2018-02-15') select id,vin,phonenumber,country,area,salary from origintable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT logdate,id,vin,phonenumber,country,area,salary\n         | FROM partitiontable0\n      ")).stripMargin()).show(100, false);
        spark.sql("UPDATE origintable SET (salary) = (88888)").show();
        spark.sql("insert overwrite table partitiontable0 partition(logdate='2018-02-15') select id,vin,phonenumber,country,area,salary from origintable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT logdate,id,vin,phonenumber,country,area,salary\n         | FROM partitiontable0\n      ")).stripMargin()).show(100, false);
        Random r = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_StandardPartitionExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_carbondata_examples_StandardPartitionExample$$typecreator5$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> StandardPartitionExample$.$anonfun$exampleBody$1(r, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple4.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_StandardPartitionExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ID", "country", "city", "population"}));
        df.write().format("carbondata").option("tableName", "withoutpartition").option("compress", "true").mode(SaveMode.Overwrite).save();
        spark.sql("DROP TABLE IF EXISTS withpartition");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE withpartition\n        | (ID String,\n        | city String,\n        | population Int)\n        | PARTITIONED BY (country String)\n        | STORED AS carbondata\n      ")).stripMargin());
        df.write().format("carbondata").option("tableName", "withpartition").option("compress", "true").mode(SaveMode.Overwrite).save();
        double time_without_partition = StandardPartitionExample$.time$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n           | SELECT *\n           | FROM withoutpartition WHERE country='country3'\n      ")).stripMargin()).count());
        double time_with_partition = StandardPartitionExample$.time$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n           | SELECT *\n           | FROM withpartition WHERE country='country3'\n      ")).stripMargin()).count());
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("----time of without partition----:").append(((Object)BoxesRunTime.boxToDouble((double)time_without_partition)).toString()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("----time of with partition----:").append(((Object)BoxesRunTime.boxToDouble((double)time_with_partition)).toString()).toString());
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS partitiontable0");
        spark.sql("DROP TABLE IF EXISTS withoutpartition");
        spark.sql("DROP TABLE IF EXISTS withpartition");
        spark.sql("DROP TABLE IF EXISTS origintable");
    }

    public static final /* synthetic */ Tuple4 $anonfun$exampleBody$1(Random r$1, int x) {
        return new Tuple4((Object)new StringBuilder(3).append("No.").append(r$1.nextInt(1000)).toString(), (Object)new StringBuilder(7).append("country").append(x % 8).toString(), (Object)new StringBuilder(4).append("city").append(x % 50).toString(), (Object)BoxesRunTime.boxToInteger((int)(x % 300)));
    }

    private static final double time$1(Function0 code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    private StandardPartitionExample$() {
        MODULE$ = this;
    }
}

