/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class SparkSessionExample$ {
    public static SparkSessionExample$ MODULE$;
    private final String rootPath;

    static {
        new SparkSessionExample$();
    }

    public String rootPath() {
        return this.rootPath;
    }

    public void main(String[] args) {
        SparkSession sparkSession = ExampleUtils$.MODULE$.createSparkSession("SparkSessionExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        String path = new StringBuilder(43).append(this.rootPath()).append("/examples/spark/src/main/resources/data.csv").toString();
        sparkSession.sql("DROP TABLE IF EXISTS csv_table");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE csv_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField STRING,\n         | decimalField DECIMAL(18,2),\n         | dateField STRING,\n         | charField CHAR(5))\n         | ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n       ")).stripMargin());
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n         | LOAD DATA LOCAL INPATH '").append(path).append("'\n         | INTO TABLE csv_table\n       ").toString())).stripMargin());
        sparkSession.sql("SELECT * FROM csv_table").show();
        this.sparkTableExample(sparkSession);
        this.hiveTableExample(sparkSession);
        sparkSession.sql("DROP TABLE IF EXISTS csv_table");
        sparkSession.stop();
    }

    public void sparkTableExample(SparkSession sparkSession) {
        sparkSession.sql("DROP TABLE IF EXISTS sparksession_table");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sparksession_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5)\n         | )\n         | USING carbondata\n       ")).stripMargin());
        this.validateTable(sparkSession, "sparksession_table");
        sparkSession.sql("DROP TABLE IF EXISTS sparksession_table");
    }

    public void hiveTableExample(SparkSession sparkSession) {
        sparkSession.sql("DROP TABLE IF EXISTS sparksession_hive_table");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sparksession_hive_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5)\n         | )\n         | STORED AS carbondata\n       ")).stripMargin());
        this.validateTable(sparkSession, "sparksession_hive_table");
    }

    public void validateTable(SparkSession sparkSession, String tableName) {
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n         | INSERT INTO TABLE ").append(tableName).append("\n         | SELECT shortField, intField, bigintField, doubleField, stringField,\n         | from_unixtime(unix_timestamp(timestampField,'yyyy/MM/dd HH:mm:ss')) timestampField,\n         | decimalField,from_unixtime(unix_timestamp(dateField,'yyyy/MM/dd')), charField\n         | FROM csv_table\n       ").toString())).stripMargin());
        sparkSession.sql(new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(105).append("\n         | SELECT *\n         | FROM ").append(tableName).append("\n         | WHERE stringfield = 'spark' AND decimalField > 40\n      ").toString())).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n         | SELECT\n         | stringField, date_format(timestampField, \"yyyy/MM/dd HH:mm:ss\") AS\n         | timestampField\n         | FROM ").append(tableName).append(" WHERE length(stringField) = 5\n       ").toString())).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("\n         | SELECT *\n         | FROM ").append(tableName).append(" where date_format(dateField, \"yyyy-MM-dd\") = \"2015-07-23\"\n       ").toString())).stripMargin()).show();
        sparkSession.sql(new StringBuilder(31).append("SELECT count(stringField) FROM ").append(tableName).toString()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("\n         | SELECT sum(intField), stringField\n         | FROM ").append(tableName).append("\n         | GROUP BY stringField\n       ").toString())).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         | SELECT t1.*, t2.*\n         | FROM ").append(tableName).append(" t1, ").append(tableName).append(" t2\n         | WHERE t1.stringField = t2.stringField\n      ").toString())).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("\n         | WITH t1 AS (\n         | SELECT * FROM ").append(tableName).append("\n         | UNION ALL\n         | SELECT * FROM ").append(tableName).append("\n         | )\n         | SELECT t1.*, t2.*\n         | FROM t1, ").append(tableName).append(" t2\n         | WHERE t1.stringField = t2.stringField\n      ").toString())).stripMargin()).show();
    }

    private SparkSessionExample$() {
        MODULE$ = this;
        this.rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
    }
}

