/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.io.Serializable;
import java.util.Random;
import org.apache.carbondata.examples.MVExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class MVExample$ {
    public static MVExample$ MODULE$;

    static {
        new MVExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createSparkSession("MVExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.exampleBody(spark);
        this.performanceTest(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        String testData = new StringBuilder(48).append(rootPath).append("/integration/spark/src/test/resources/sample.csv").toString();
        spark.sql("DROP TABLE IF EXISTS mainTable");
        spark.sql("DROP TABLE IF EXISTS dimtable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE mainTable\n        | (id Int,\n        | name String,\n        | city String,\n        | age Int)\n        | STORED AS carbondata\n      ")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE dimtable\n        | (name String,\n        | address String)\n        | STORED AS carbondata\n      ")).stripMargin());
        spark.sql(new StringBuilder(46).append("LOAD DATA LOCAL INPATH '").append(testData).append("' into table mainTable").toString());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("insert into dimtable select name, concat(city, ' street1') as address from\n           |mainTable group by name, address")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("create materialized view simple_sub_projection as\n         | select id,name from mainTable")).stripMargin());
        spark.sql("refresh materialized view simple_sub_projection");
        spark.sql("select id from mainTable").explain(true);
        spark.sql("select sum(id) from mainTable").explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("create materialized view simple_agg as\n         | select id,sum(age) from mainTable group by id")).stripMargin());
        spark.sql("refresh materialized view simple_agg");
        spark.sql("select id,sum(age) from mainTable group by id").explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("select sub.id from (select id ,sum(age) from mainTable group by id) sub where sub\n           |.id = 4")).stripMargin()).explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("create materialized view simple_agg_with_join as\n         | select id,address, sum(age) from mainTable inner join dimtable on mainTable\n         | .name=dimtable.name group by id ,address")).stripMargin());
        spark.sql("refresh materialized view simple_agg_with_join");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("select id,address, sum(age) from mainTable inner join dimtable on mainTable\n           |.name=dimtable.name group by id ,address")).stripMargin()).explain(true);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("select id,address, sum(age) from mainTable inner join dimtable on mainTable\n                 |.name=dimtable.name where id =1 group by id ,address")).stripMargin()).explain(true);
        spark.sql("show materialized views").show(false);
        spark.sql("drop materialized view if exists simple_agg_with_join");
        spark.sql("DROP TABLE IF EXISTS mainTable");
        spark.sql("DROP TABLE IF EXISTS dimtable");
    }

    private void performanceTest(SparkSession spark) {
        spark.sql("DROP TABLE IF EXISTS employee_salary");
        spark.sql("DROP TABLE IF EXISTS employee_salary_without_mv");
        spark.sql("DROP TABLE IF EXISTS emp_address");
        this.createFactTable(spark, "employee_salary");
        this.createFactTable(spark, "employee_salary_without_mv");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE emp_address\n        | (name String,\n        | address String)\n        | STORED AS carbondata\n      ")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("insert into emp_address select name, concat(city, ' street1') as address from\n         |employee_salary group by name, address")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("create materialized view simple_agg_employee as\n         | select id,sum(salary) from employee_salary group by id")).stripMargin());
        spark.sql("refresh materialized view simple_agg_employee");
        double timeWithOutMv = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql("select id, name, sum(salary) from employee_salary_without_mv group by id,name").collect());
        double timeWithMv = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql("select id,name,sum(salary) from employee_salary group by id,name").collect());
        Predef$.MODULE$.println((Object)new StringBuilder(45).append("Time of table with MV is : ").append(timeWithMv).append(" time withoutmv : ").append(timeWithOutMv).toString());
        double timeWithOutMvFilter = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql("select id, name, sum(salary) from employee_salary_without_mv where name='name10' group by id,name").collect());
        double timeWithMvFilter = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql("select id,name,sum(salary) from employee_salary where name='name10' group by id,name").collect());
        Predef$.MODULE$.println((Object)new StringBuilder(57).append("Time of table with MV with filter is : ").append(timeWithMvFilter).append(" time withoutmv : ").append(timeWithOutMvFilter).toString());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("create materialized view simple_join_agg_employee as\n         | select id,address, sum(salary) from employee_salary f join emp_address d\n         | on f.name=d.name group by id,address")).stripMargin());
        spark.sql("refresh materialized view simple_join_agg_employee");
        double timeWithMVJoin = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql(new StringOps(Predef$.MODULE$.augmentString("select id,address, sum(salary) from employee_salary f join emp_address d\n           | on f.name=d.name group by id,address")).stripMargin()).collect());
        double timeWithOutMVJoin = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql(new StringOps(Predef$.MODULE$.augmentString("select id,address, sum(salary) from employee_salary_without_mv f\n           |join emp_address d on f.name=d.name group by id,address")).stripMargin()).collect());
        Predef$.MODULE$.println((Object)new StringBuilder(55).append("Time of table with MV with join is : ").append(timeWithMVJoin).append(" time withoutmv : ").append(timeWithOutMVJoin).toString());
        spark.sql("DROP TABLE IF EXISTS employee_salary");
        spark.sql("DROP TABLE IF EXISTS emp_address");
        spark.sql("DROP TABLE IF EXISTS employee_salary_without_mv");
    }

    private void createFactTable(SparkSession spark, String tableName) {
        Random rand = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_MVExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_carbondata_examples_MVExample$$typecreator5$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> MVExample$.$anonfun$createFactTable$1(rand, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple4.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_MVExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "city", "salary"}));
        df.write().format("carbondata").option("tableName", tableName).save();
    }

    private double time(Function0<BoxedUnit> code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    public static final /* synthetic */ Tuple4 $anonfun$createFactTable$1(Random rand$1, int x) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)(x % 1000)), (Object)new StringBuilder(4).append("name").append(x % 1000).toString(), (Object)new StringBuilder(4).append("city").append(x % 100).toString(), (Object)BoxesRunTime.boxToInteger((int)rand$1.nextInt()));
    }

    private MVExample$() {
        MODULE$ = this;
    }
}

