/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.Serializable;
import org.apache.carbondata.examples.LuceneIndexExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class LuceneIndexExample$ {
    public static LuceneIndexExample$ MODULE$;

    static {
        new LuceneIndexExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createSparkSession("LuceneIndexExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        Random r = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_LuceneIndexExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_carbondata_examples_LuceneIndexExample$$typecreator5$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> LuceneIndexExample$.$anonfun$exampleBody$1(r, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple4.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_LuceneIndexExample$$typecreator5$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "city", "age"}));
        spark.sql("DROP TABLE IF EXISTS personTable");
        df.write().format("carbondata").option("tableName", "personTable").option("compress", "true").mode(SaveMode.Overwrite).save();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE INDEX IF NOT EXISTS dm ON TABLE personTable (id, name)\n         | AS 'lucene'\n      ")).stripMargin());
        double timeWithoutLuceneIndex = LuceneIndexExample$.time$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n           | SELECT count(*)\n           | FROM personTable where id like '% test1 %'\n      ")).stripMargin()).show());
        double timeWithLuceneIndex = LuceneIndexExample$.time$1((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n           | SELECT count(*)\n           | FROM personTable where TEXT_MATCH('id:test1')\n      ")).stripMargin()).show());
        Predef$.MODULE$.println((Object)new StringBuilder(48).append("time for query on table with lucene index table:").append(((Object)BoxesRunTime.boxToDouble((double)timeWithLuceneIndex)).toString()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(51).append("time for query on table without lucene index table:").append(((Object)BoxesRunTime.boxToDouble((double)timeWithoutLuceneIndex)).toString()).toString());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT id,name\n         | FROM personTable where TEXT_MATCH('id:test1 -id:good1')\n      ")).stripMargin()).show(100);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT id,name\n         | FROM personTable where TEXT_MATCH_WITH_LIMIT('id:test1',10)\n      ")).stripMargin()).show();
        spark.sql("DROP TABLE IF EXISTS personTable");
    }

    public static final /* synthetic */ Tuple4 $anonfun$exampleBody$1(Random r$1, int x) {
        return new Tuple4((Object)new StringBuilder(15).append("which test").append(r$1.nextInt(10000)).append(" good").append(r$1.nextInt(10)).toString(), (Object)new StringBuilder(12).append("who and name").append(x % 8).toString(), (Object)new StringBuilder(4).append("city").append(x % 50).toString(), (Object)BoxesRunTime.boxToInteger((int)(x % 60)));
    }

    private static final double time$1(Function0 code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    private LuceneIndexExample$() {
        MODULE$ = this;
    }
}

