/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.carbondata.hive.test.server.HiveEmbeddedServer2;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveExample$ {
    public static HiveExample$ MODULE$;
    private final String driverName;
    private final String rootPath;
    private final String projectLoc;
    private final String metaStoreLoc;
    private final Logger LOGGER;

    static {
        new HiveExample$();
    }

    private String driverName() {
        return this.driverName;
    }

    public String rootPath() {
        return this.rootPath;
    }

    public String projectLoc() {
        return this.projectLoc;
    }

    public String metaStoreLoc() {
        return this.metaStoreLoc;
    }

    public Logger LOGGER() {
        return this.LOGGER;
    }

    public void main(String[] args) {
        SparkSession sparkSession = ExampleUtils$.MODULE$.createSparkSession("HiveExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.createCarbonTable(sparkSession);
        this.readFromHive();
        System.exit(0);
    }

    public void createCarbonTable(SparkSession sparkSession) {
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("DROP TABLE IF EXISTS HIVE_CARBON_EXAMPLE")).stripMargin());
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE HIVE_CARBON_EXAMPLE\n         | (ID int,NAME string,SALARY double)\n         | STORED AS carbondata\n       ")).stripMargin());
        String inputPath = FileFactory.getUpdatedFilePath((String)new StringBuilder(45).append(this.rootPath()).append("/examples/spark/src/main/resources/sample.csv").toString());
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n         | LOAD DATA LOCAL INPATH '").append(inputPath).append("'\n         | INTO TABLE HIVE_CARBON_EXAMPLE\n       ").toString())).stripMargin());
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n         | LOAD DATA LOCAL INPATH '").append(inputPath).append("'\n         | INTO TABLE HIVE_CARBON_EXAMPLE\n       ").toString())).stripMargin());
        sparkSession.sql("SELECT * FROM HIVE_CARBON_EXAMPLE").show();
        sparkSession.sql("DROP TABLE IF EXISTS TEST_BOUNDARY");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("CREATE TABLE TEST_BOUNDARY (c1_int int,c2_Bigint Bigint,c3_Decimal Decimal(38,30),\n           |c4_double double,c5_string string,c6_Timestamp Timestamp,c7_Datatype_Desc string)\n           |STORED AS carbondata")).stripMargin());
        inputPath = FileFactory.getUpdatedFilePath((String)new StringBuilder(49).append(this.rootPath()).append("/examples/spark/src/main/resources/Test_Data1.csv").toString());
        sparkSession.sql(new StringBuilder(208).append("LOAD DATA INPATH '").append(inputPath).append("' INTO table TEST_BOUNDARY OPTIONS('DELIMITER'=',',").append("'QUOTECHAR'='\"', 'BAD_RECORDS_ACTION'='FORCE','FILEHEADER'='c1_int,c2_Bigint,").append("c3_Decimal,c4_double,c5_string,c6_Timestamp,c7_Datatype_Desc')").toString());
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("DROP TABLE IF EXISTS complexMap")).stripMargin());
        sparkSession.sql("create table complexMap(name map<string,string>) STORED AS carbondata");
        sparkSession.sql("insert into complexMap values(map('Manish','Nalla','Shardul','Singh','Vishal','Kumar','EmptyVal','','NullVal', 'null'))");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString("DROP TABLE IF EXISTS carbonLocalDictionary")).stripMargin());
        sparkSession.sql(new StringBuilder(206).append("create table carbonLocalDictionary(id int, name string, scale decimal, country string, ").append("salary double) stored as carbondata TBLPROPERTIES ('local_dictionary_enable'='true',").append("'local_dictionary_include'='name') ").toString());
        this.checkAndDeleteDBLock();
    }

    public void checkAndDeleteDBLock() {
        block0: {
            String dbLockPath = FileFactory.getUpdatedFilePath((String)new StringBuilder(7).append(this.metaStoreLoc()).append("/db.lck").toString());
            String dbexLockPath = FileFactory.getUpdatedFilePath((String)new StringBuilder(9).append(this.metaStoreLoc()).append("/dbex.lck").toString());
            Object object = FileFactory.isFileExist((String)dbLockPath) ? BoxesRunTime.boxToBoolean((boolean)FileFactory.deleteFile((String)dbLockPath)) : BoxedUnit.UNIT;
            if (!FileFactory.isFileExist((String)dbexLockPath)) break block0;
            FileFactory.deleteFile((String)dbexLockPath);
        }
    }

    public void readFromHive() {
        BoxedUnit boxedUnit;
        try {
            boxedUnit = Class.forName(this.driverName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            boxedUnit = BoxedUnit.UNIT;
        }
        Path path = new Path(this.projectLoc());
        FileSystem fileSys = path.getFileSystem(FileFactory.getConfiguration());
        fileSys.setPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        HiveEmbeddedServer2 hiveEmbeddedServer2 = new HiveEmbeddedServer2();
        hiveEmbeddedServer2.start(this.projectLoc());
        int port = hiveEmbeddedServer2.getFreePort();
        Connection connection = DriverManager.getConnection(new StringBuilder(31).append("jdbc:hive2://localhost:").append(port).append("/default").toString(), "", "");
        Statement statement = connection.createStatement();
        this.LOGGER().info((Object)new StringBuilder(55).append("============HIVE CLI IS STARTED ON PORT ").append(port).append(" ==============").toString());
        ResultSet resultSet = statement.executeQuery("SELECT * FROM HIVE_CARBON_EXAMPLE");
        int rowsFetched = 0;
        String resultId = "";
        String resultName = "";
        String resultSalary = "";
        while (resultSet.next()) {
            if (rowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| ID|| NAME || SALARY        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultSet.getString("id");
                resultName = resultSet.getString("name");
                resultSalary = resultSet.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder(4).append("| ").append(resultId).append(" |").append(new StringBuilder(4).append("| ").append(resultName).append(" |").toString()).append(new StringBuilder(5).append("| ").append(resultSalary).append("  |").toString()).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultSet.getString("ID");
                resultName = resultSet.getString("NAME");
                resultSalary = resultSet.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder(4).append("| ").append(resultId).append(" |").append(new StringBuilder(4).append("| ").append(resultName).append(" |").toString()).append(new StringBuilder(6).append("| ").append(resultSalary).append("   |").toString()).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++rowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(42).append("******Total Number Of Rows Fetched ****** ").append(rowsFetched).toString());
        Predef$.MODULE$.assert(rowsFetched == 4);
        this.LOGGER().info((Object)"Fetching the Individual Columns ");
        int individualColRowsFetched = 0;
        ResultSet resultIndividualCol = statement.executeQuery("SELECT NAME FROM HIVE_CARBON_EXAMPLE");
        while (resultIndividualCol.next()) {
            if (individualColRowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+--------------+");
                Predef$.MODULE$.println((Object)"| NAME         |");
                Predef$.MODULE$.println((Object)"+---++---------+");
                resultName = resultIndividualCol.getString("name");
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("| ").append(resultName).append("    |").toString());
                Predef$.MODULE$.println((Object)"+---++---------+");
            } else {
                resultName = resultIndividualCol.getString("NAME");
                Predef$.MODULE$.println((Object)new StringBuilder(9).append("| ").append(resultName).append("      |").toString());
                Predef$.MODULE$.println((Object)"+---++---------+");
            }
            ++individualColRowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(77).append(" ********** Total Rows Fetched When Quering The Individual Columns **********").append(String.valueOf(BoxesRunTime.boxToInteger((int)individualColRowsFetched))).toString());
        Predef$.MODULE$.assert(individualColRowsFetched == 4);
        this.LOGGER().info((Object)"Fetching the Out Of Order Columns ");
        ResultSet resultOutOfOrderCol = statement.executeQuery("SELECT SALARY,ID,NAME FROM HIVE_CARBON_EXAMPLE");
        int outOfOrderColFetched = 0;
        while (resultOutOfOrderCol.next()) {
            if (outOfOrderColFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| Salary|| ID || NAME        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultOutOfOrderCol.getString("id");
                resultName = resultOutOfOrderCol.getString("name");
                resultSalary = resultOutOfOrderCol.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder(4).append("| ").append(resultSalary).append(" |").append(new StringBuilder(4).append("| ").append(resultId).append(" |").toString()).append(new StringBuilder(5).append("| ").append(resultName).append("  |").toString()).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultOutOfOrderCol.getString("ID");
                resultName = resultOutOfOrderCol.getString("NAME");
                resultSalary = resultOutOfOrderCol.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder(4).append("| ").append(resultSalary).append(" |").append(new StringBuilder(4).append("| ").append(resultId).append(" |").toString()).append(new StringBuilder(6).append("| ").append(resultName).append("   |").toString()).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++outOfOrderColFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(79).append(" ********** Total Rows Fetched When Quering The Out Of Order Columns **********").append(String.valueOf(BoxesRunTime.boxToInteger((int)outOfOrderColFetched))).toString());
        Predef$.MODULE$.assert(outOfOrderColFetched == 4);
        Predef$.MODULE$.println((Object)" ********** Local Dictionary details from Describe Formatted **********");
        ResultSet resultDictQuery = statement.executeQuery("describe formatted carbonLocalDictionary");
        String dataType = "";
        while (resultDictQuery.next()) {
            dataType = new StringBuilder(0).append(dataType).append(resultDictQuery.getString("data_type")).toString();
            if (resultDictQuery.getString("data_type") != null && resultDictQuery.getString("data_type").contains("local_dictionary_enable")) {
                Predef$.MODULE$.println((Object)new StringBuilder(12).append("| ").append(resultDictQuery.getString("data_type")).append(" |    ").append("| ").append(resultDictQuery.getString("comment")).append(" |").toString());
                Predef$.MODULE$.assert(resultDictQuery.getString("comment").contains("true"));
            }
            if (resultDictQuery.getString("data_type") == null || !resultDictQuery.getString("data_type").contains("local_dictionary_include")) continue;
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("| ").append(resultDictQuery.getString("data_type")).append(" |    ").append("| ").append(resultDictQuery.getString("comment")).append(" |").toString());
            Predef$.MODULE$.assert(resultDictQuery.getString("comment").contains("name"));
        }
        Predef$.MODULE$.assert(dataType.contains("local_dictionary_enable"));
        Predef$.MODULE$.assert(dataType.contains("local_dictionary_include"));
        ResultSet resultAggQuery = statement.executeQuery("SELECT min(c3_Decimal) as min, max(c3_Decimal) as max, sum(c3_Decimal) as sum FROM TEST_BOUNDARY");
        int resultAggQueryFetched = 0;
        String resultMin = "";
        String resultMax = "";
        String resultSum = "";
        while (resultAggQuery.next()) {
            if (resultAggQueryFetched == 0) {
                Predef$.MODULE$.println((Object)"+-----++-------------------++--------------------------------+");
                Predef$.MODULE$.println((Object)"| min || max               || sum                            |");
                Predef$.MODULE$.println((Object)"+-----++-------------------++--------------------------------+");
                resultMin = resultAggQuery.getString("min");
                resultMax = resultAggQuery.getString("max");
                resultSum = resultAggQuery.getString("sum");
                Predef$.MODULE$.println((Object)new StringBuilder(6).append("| ").append(resultMin).append("   |").append(new StringBuilder(18).append("| ").append(resultMax).append("               |").toString()).append(new StringBuilder(3).append("| ").append(resultSum).append("|").toString()).toString());
                Predef$.MODULE$.println((Object)"+-----++-------------------++--------------------------------+");
            }
            ++resultAggQueryFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(62).append(" ********** Total Rows Fetched When Aggregate Query **********").append(String.valueOf(BoxesRunTime.boxToInteger((int)resultAggQueryFetched))).toString());
        Predef$.MODULE$.assert(resultAggQueryFetched == 1);
        ResultSet resultComplexQuery = statement.executeQuery("SELECT name FROM complexMap");
        int resultComplex = 0;
        String name = "";
        while (resultComplexQuery.next()) {
            if (resultComplex == 0) {
                Predef$.MODULE$.println((Object)"+------------------------------------------------------------------------------------+");
                Predef$.MODULE$.println((Object)"| name                                                                               |");
                Predef$.MODULE$.println((Object)"+------------------------------------------------------------------------------------+");
                name = resultComplexQuery.getString("name");
                Predef$.MODULE$.println((Object)new StringBuilder(2).append("|").append(name).append("|").toString());
                Predef$.MODULE$.println((Object)"+------------------------------------------------------------------------------------+");
            }
            ++resultComplex;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(60).append(" ********** Total Rows Fetched When Complex Query **********").append(String.valueOf(BoxesRunTime.boxToInteger((int)resultComplex))).toString());
        Predef$.MODULE$.assert(resultComplex == 1);
        hiveEmbeddedServer2.stop();
    }

    private HiveExample$() {
        MODULE$ = this;
        this.driverName = "org.apache.hive.jdbc.HiveDriver";
        this.rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        this.projectLoc = new StringBuilder(15).append(this.rootPath()).append("/examples/spark").toString();
        System.setProperty("derby.system.home", String.valueOf(this.projectLoc()));
        this.metaStoreLoc = new StringBuilder(13).append(this.projectLoc()).append("/metastore_db").toString();
        this.LOGGER = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());
    }
}

