/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GeoTableExampleWithCarbonSession$ {
    public static GeoTableExampleWithCarbonSession$ MODULE$;

    static {
        new GeoTableExampleWithCarbonSession$();
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        System.setProperty("path.target", new StringBuilder(22).append(rootPath).append("/examples/spark/target").toString());
        PropertyConfigurator.configure((String)new StringBuilder(51).append(rootPath).append("/examples/spark/src/main/resources/log4j.properties").toString());
        CarbonProperties.getInstance().addProperty("enable.query.statistics", "false");
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("GeoTableExampleWithCarbonSession", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        spark.sparkContext().setLogLevel("error");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stored as carbondata", "using carbondata", "stored by 'carbondata'", "stored by 'org.apache.carbondata.format'"}))).foreach((Function1 & Serializable & scala.Serializable)formatSyntax -> {
            GeoTableExampleWithCarbonSession$.MODULE$.exampleBody(spark, formatSyntax);
            return BoxedUnit.UNIT;
        });
        spark.close();
    }

    public void exampleBody(SparkSession spark, String formatSyntax) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        String path = new StringBuilder(49).append(rootPath).append("/integration/spark/src/test/resources/geodata.csv").toString();
        spark.sql("DROP TABLE IF EXISTS geoTable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(749).append("\n        CREATE TABLE geoTable(\n         | timevalue BIGINT,\n         | longitude LONG,\n         | latitude LONG)\n         | ").append(formatSyntax).append("\n         |  TBLPROPERTIES ('SPATIAL_INDEX'='mygeohash',\n         | 'SPATIAL_INDEX.mygeohash.type'='geohash',\n         | 'SPATIAL_INDEX.mygeohash.sourcecolumns'='longitude, latitude',\n         | 'SPATIAL_INDEX.mygeohash.originLatitude'='39.832277',\n         | 'SPATIAL_INDEX.mygeohash.gridSize'='50',\n         | 'SPATIAL_INDEX.mygeohash.minLongitude'='115.811865',\n         | 'SPATIAL_INDEX.mygeohash.maxLongitude'='116.782233',\n         | 'SPATIAL_INDEX.mygeohash.minLatitude'='39.832277',\n         | 'SPATIAL_INDEX.mygeohash.maxLatitude'='40.225281',\n         | 'SPATIAL_INDEX.mygeohash.conversionRatio'='1000000')\n       ").toString())).stripMargin());
        spark.sql("select *from geoTable").show();
        Row[] descTable = (Row[])spark.sql("describe formatted geoTable").collect();
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])descTable)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoTableExampleWithCarbonSession$.$anonfun$exampleBody$1(x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Row row = (Row)some.value();
            Predef$.MODULE$.assert(row.get(1).toString().contains("bigint"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.assert(false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("LOAD DATA local inpath '").append(path).append("' INTO TABLE geoTable OPTIONS\n           |('DELIMITER'= ',')").toString())).stripMargin());
        spark.sql("CREATE MATERIALIZED VIEW view1 AS SELECT longitude, latitude FROM geoTable");
        List result = spark.sql("show materialized views on table geoTable").collectAsList();
        Predef$.MODULE$.assert(((Row)result.get(0)).get(1).toString().equalsIgnoreCase("view1"));
        spark.sql("select *from geoTable").show();
        spark.sql("DROP TABLE IF EXISTS geoTable");
    }

    public String exampleBody$default$2() {
        return "stored as carbondata";
    }

    public static final /* synthetic */ boolean $anonfun$exampleBody$1(Row x$1) {
        return x$1.get(0).toString().contains("mygeohash");
    }

    private GeoTableExampleWithCarbonSession$() {
        MODULE$ = this;
    }
}

