/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.Field;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.CarbonWriterBuilder;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class DirectSQLExample$ {
    public static DirectSQLExample$ MODULE$;

    static {
        new DirectSQLExample$();
    }

    public void main(String[] args) {
        SparkSession carbonSession = ExampleUtils$.MODULE$.createSparkSession("DirectSQLExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.exampleBody(carbonSession);
        carbonSession.close();
    }

    public void exampleBody(SparkSession carbonSession) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        String path = new StringBuilder(34).append(rootPath).append("/examples/spark/target/carbonFile/").toString();
        this.cleanTestData(path);
        int rows = 20;
        this.buildTestData(path, rows);
        String readPath = path;
        Predef$.MODULE$.println((Object)"Running SQL on carbon files directly");
        try {
            carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(32).append("select * FROM carbon.`").append(readPath).append("` limit 10").toString())).stripMargin()).show();
            long counts = carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(23).append("select * FROM carbon.`").append(readPath).append("`").toString())).stripMargin()).count();
            Predef$.MODULE$.assert((long)rows == counts);
        }
        finally {
            this.cleanTestData(path);
        }
    }

    public void buildTestData(String path, int num) {
        String writerPath = path.replace("\\", "/");
        Field[] fields = new Field[]{new Field("name", DataTypes.STRING), new Field("age", DataTypes.INT), new Field("height", DataTypes.DOUBLE)};
        CarbonWriterBuilder builder = CarbonWriter.builder().outputPath(writerPath).uniqueIdentifier(System.currentTimeMillis()).withBlockSize(2).withCsvInput(new Schema(fields)).writtenBy("DirectSQLExample");
        CarbonWriter writer = builder.build();
        for (int i = 0; i < num; ++i) {
            writer.write((Object)new String[]{new StringBuilder(5).append("robot").append(i).toString(), String.valueOf(i), String.valueOf((double)i / (double)2)});
        }
        writer.close();
    }

    public int buildTestData$default$2() {
        return 3;
    }

    public void cleanTestData(String path) {
        FileUtils.deleteDirectory((File)new File(path));
    }

    private DirectSQLExample$() {
        MODULE$ = this;
    }
}

