/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.DedupExample;
import org.apache.carbondata.examples.DedupExample$;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.math.Ordering;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class DedupExample$ {
    public static DedupExample$ MODULE$;
    private final int numInitialRows;
    private final int numInsertPerBatch;
    private final int numDuplicatePerBatch;
    private final int numBatch;
    private final boolean printDetail;
    private final Seq<String> names;
    private final ArrayList<Object> currentIds;
    private final String INSERT;

    static {
        new DedupExample$();
    }

    public int numInitialRows() {
        return this.numInitialRows;
    }

    public int numInsertPerBatch() {
        return this.numInsertPerBatch;
    }

    public int numDuplicatePerBatch() {
        return this.numDuplicatePerBatch;
    }

    public int numBatch() {
        return this.numBatch;
    }

    public boolean printDetail() {
        return this.printDetail;
    }

    public Seq<String> names() {
        return this.names;
    }

    private String pickName() {
        return (String)this.names().apply(Random$.MODULE$.nextInt(this.names().size()));
    }

    private ArrayList<Object> currentIds() {
        return this.currentIds;
    }

    private boolean addId(int id) {
        return this.currentIds().add(BoxesRunTime.boxToInteger((int)id));
    }

    private int maxId() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.currentIds()).asScala()).max((Ordering)Ordering.Int$.MODULE$));
    }

    private String INSERT() {
        return this.INSERT;
    }

    private void generateRowsForInsert(SparkSession sparkSession) {
        IndexedSeq insertRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.maxId() - 2), this.maxId() + this.numInsertPerBatch()).map((Function1 & Serializable & scala.Serializable)x -> DedupExample$.$anonfun$generateRowsForInsert$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_DedupExample$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.DedupExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_DedupExample$$typecreator1$1() {
            }
        }
        Dataset insertData = sparkSession.createDataFrame((Seq)insertRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_DedupExample$$typecreator1$1()));
        Dataset duplicatedData = insertData.union(insertData);
        duplicatedData.write().format("carbondata").option("tableName", "change").mode(SaveMode.Overwrite).save();
    }

    private void generateTarget(SparkSession sparkSession) {
        IndexedSeq insertRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numInitialRows()).map((Function1 & Serializable & scala.Serializable)x -> DedupExample$.$anonfun$generateTarget$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_DedupExample$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.DedupExample.Target").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_DedupExample$$typecreator1$2() {
            }
        }
        Dataset targetData = sparkSession.createDataFrame((Seq)insertRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_DedupExample$$typecreator1$2()));
        targetData.write().format("carbondata").option("tableName", "target").mode(SaveMode.Overwrite).save();
    }

    private Dataset<Row> readTargetData(SparkSession sparkSession) {
        return sparkSession.read().format("carbondata").option("tableName", "target").load();
    }

    private Dataset<Row> readChangeData(SparkSession sparkSession) {
        return sparkSession.read().format("carbondata").option("tableName", "change").load();
    }

    private void printChange(SparkSession spark, int i) {
        block0: {
            if (!this.printDetail()) break block0;
            Predef$.MODULE$.println((Object)new StringBuilder(12).append("Insert batch").append(i).toString());
            spark.sql("select * from change").show(100, false);
        }
    }

    private void printTarget(SparkSession spark, int i) {
        block0: {
            if (!this.printDetail()) break block0;
            Predef$.MODULE$.println((Object)new StringBuilder(31).append("target table after insert batch").append(i).toString());
            spark.sql("select * from target order by id").show(false);
        }
    }

    private void printTarget(SparkSession spark) {
        block0: {
            if (!this.printDetail()) break block0;
            Predef$.MODULE$.println((Object)"## target table");
            spark.sql("select * from target").show(100, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SparkSession createSession() {
        void var2_2;
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master("local[8]").enableHiveSupport().config("spark.sql.warehouse.dir", new StringBuilder(32).append(rootPath).append("/examples/spark/target/warehouse").toString())).getOrCreateCarbonSession();
        spark.sparkContext().setLogLevel("error");
        return var2_2;
    }

    public void main(String[] args) {
        CarbonProperties.setAuditEnabled((boolean)false);
        SparkSession spark = this.createSession();
        spark.sql("drop table if exists target");
        spark.sql("drop table if exists change");
        this.generateTarget(spark);
        this.printTarget(spark);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numBatch()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            MODULE$.generateRowsForInsert(spark);
            MODULE$.printChange(spark, i);
            MODULE$.dedupAndInsert(spark);
            MODULE$.printTarget(spark, i);
        });
        spark.close();
    }

    private void dedupAndInsert(SparkSession spark) {
        Dataset latestChangeForEachKey = this.readChangeData(spark).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "struct(mdt, value, change_type) as otherCols"})).groupBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.max("otherCols").as("latest"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "latest.*"}));
        Dataset<Row> target = this.readTargetData(spark);
        CarbonSession$.MODULE$.DataSetMerge(target.as("A")).merge(latestChangeForEachKey.as("B"), "A.id = B.id").whenNotMatched().insertExpr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"B.id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"B.value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source_table"), (Object)"'table1'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mdt"), (Object)"B.mdt")}))).execute();
    }

    public static final /* synthetic */ DedupExample.Change $anonfun$generateRowsForInsert$1(int x) {
        MODULE$.addId(x);
        return new DedupExample.Change(x, MODULE$.pickName(), MODULE$.INSERT(), LocalDateTime.now().toString());
    }

    public static final /* synthetic */ DedupExample.Target $anonfun$generateTarget$1(int x) {
        MODULE$.addId(x);
        return new DedupExample.Target(x, MODULE$.pickName(), "table1", LocalDateTime.now().toString());
    }

    private DedupExample$() {
        MODULE$ = this;
        this.numInitialRows = 10;
        this.numInsertPerBatch = 3;
        this.numDuplicatePerBatch = 4;
        this.numBatch = 2;
        this.printDetail = true;
        this.names = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Amy", "Bob", "Lucy", "Roy", "Tony", "Mick", "Henry", "Michael", "Carly", "Emma", "Jade", "Josh", "Sue", "Ben", "Dale", "Chris", "Grace", "Emily"}));
        this.currentIds = new ArrayList();
        this.INSERT = "I";
    }
}

