/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class CarbonSortColumnsExample$ {
    public static CarbonSortColumnsExample$ MODULE$;

    static {
        new CarbonSortColumnsExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createSparkSession("CarbonSessionExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy/MM/dd HH:mm:ss").addProperty("carbon.date.format", "yyyy/MM/dd");
        spark.sql("DROP TABLE IF EXISTS no_sort_columns_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE no_sort_columns_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5),\n         | floatField FLOAT,\n         | complexData ARRAY<STRING>\n         | )\n         | STORED AS carbondata\n         | TBLPROPERTIES('SORT_COLUMNS'='')\n       ")).stripMargin());
        spark.sql("DROP TABLE IF EXISTS sort_columns_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE sort_columns_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5),\n         | floatField FLOAT,\n         | complexData ARRAY<STRING>\n         | )\n         | STORED AS carbondata\n         | TBLPROPERTIES('SORT_COLUMNS'='intField, stringField, charField')\n       ")).stripMargin());
        String path = new StringBuilder(43).append(rootPath).append("/examples/spark/src/main/resources/data.csv").toString();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(141).append("\n         | LOAD DATA LOCAL INPATH '").append(path).append("'\n         | INTO TABLE no_sort_columns_table\n         | OPTIONS('COMPLEX_DELIMITER_LEVEL_1'='#')\n       ").toString())).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(138).append("\n         | LOAD DATA LOCAL INPATH '").append(path).append("'\n         | INTO TABLE sort_columns_table\n         | OPTIONS('COMPLEX_DELIMITER_LEVEL_1'='#')\n       ").toString())).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM no_sort_columns_table")).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("SELECT * FROM sort_columns_table")).stripMargin()).show();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS no_sort_columns_table");
        spark.sql("DROP TABLE IF EXISTS sort_columns_table");
    }

    private CarbonSortColumnsExample$() {
        MODULE$ = this;
    }
}

