/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class CarbonSessionExample$ {
    public static CarbonSessionExample$ MODULE$;

    static {
        new CarbonSessionExample$();
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        System.setProperty("path.target", new StringBuilder(22).append(rootPath).append("/examples/spark/target").toString());
        PropertyConfigurator.configure((String)new StringBuilder(51).append(rootPath).append("/examples/spark/src/main/resources/log4j.properties").toString());
        CarbonProperties.getInstance().addProperty("enable.query.statistics", "false");
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("CarbonSessionExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        spark.sparkContext().setLogLevel("error");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stored as carbondata", "using carbondata", "stored by 'carbondata'", "stored by 'org.apache.carbondata.format'"}))).foreach((Function1 & java.io.Serializable & Serializable)formatSyntax -> {
            CarbonSessionExample$.MODULE$.exampleBody(spark, formatSyntax);
            return BoxedUnit.UNIT;
        });
        spark.close();
    }

    public void exampleBody(SparkSession spark, String formatSyntax) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        spark.sql("DROP TABLE IF EXISTS source");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(371).append("\n         | CREATE TABLE source(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5),\n         | floatField FLOAT\n         | )\n         | ").append(formatSyntax).append("\n       ").toString())).stripMargin());
        String path = new StringBuilder(43).append(rootPath).append("/examples/spark/src/main/resources/data.csv").toString();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n         | LOAD DATA LOCAL INPATH '").append(path).append("'\n         | INTO TABLE source\n         | OPTIONS('HEADER'='true', 'COMPLEX_DELIMITER_LEVEL_1'='#')\n       ").toString())).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT charField, stringField, intField\n         | FROM source\n         | WHERE stringfield = 'spark' AND decimalField > 40\n      ")).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT *\n         | FROM source WHERE length(stringField) = 5\n       ")).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT *\n         | FROM source WHERE date_format(dateField, \"yyyy-MM-dd\") = \"2015-07-23\"\n       ")).stripMargin()).show();
        spark.sql("SELECT count(stringField) FROM source").show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT sum(intField), stringField\n         | FROM source\n         | GROUP BY stringField\n       ")).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT t1.*, t2.*\n         | FROM source t1, source t2\n         | WHERE t1.stringField = t2.stringField\n      ")).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | WITH t1 AS (\n         | SELECT * FROM source\n         | UNION ALL\n         | SELECT * FROM source\n         | )\n         | SELECT t1.*, t2.*\n         | FROM t1, source t2\n         | WHERE t1.stringField = t2.stringField\n      ")).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | SELECT *\n         | FROM source\n         | WHERE stringField = 'spark' and floatField > 2.8\n       ")).stripMargin()).show();
        spark.sql("DROP TABLE IF EXISTS source");
    }

    public String exampleBody$default$2() {
        return "stored as carbondata";
    }

    private CarbonSessionExample$() {
        MODULE$ = this;
    }
}

