/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.CDCExample;
import org.apache.carbondata.examples.CDCExample$;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class CDCExample$ {
    public static CDCExample$ MODULE$;
    private final String solution;
    private final boolean printDetail;
    private final int numInitialRows;
    private final int numInsertPerBatch;
    private final int numUpdatePerBatch;
    private final int numDeletePerBatch;
    private final int numBatch;
    private final Random random;
    private final IndexedSeq<String> values;
    private final ArrayList<Object> currentIds;
    private final String INSERT;
    private final String UPDATE;
    private final String DELETE;

    static {
        new CDCExample$();
    }

    private String solution() {
        return this.solution;
    }

    private boolean printDetail() {
        return this.printDetail;
    }

    private int numInitialRows() {
        return this.numInitialRows;
    }

    private int numInsertPerBatch() {
        return this.numInsertPerBatch;
    }

    private int numUpdatePerBatch() {
        return this.numUpdatePerBatch;
    }

    private int numDeletePerBatch() {
        return this.numDeletePerBatch;
    }

    private int numBatch() {
        return this.numBatch;
    }

    private Random random() {
        return this.random;
    }

    private IndexedSeq<String> values() {
        return this.values;
    }

    private String pickValue() {
        return (String)this.values().apply(this.random().nextInt(this.values().size()));
    }

    private ArrayList<Object> currentIds() {
        return this.currentIds;
    }

    private int getId(int index) {
        return BoxesRunTime.unboxToInt((Object)this.currentIds().get(index));
    }

    private int getAndRemoveId(int index) {
        return BoxesRunTime.unboxToInt((Object)this.currentIds().remove(index));
    }

    private boolean addId(int id) {
        return this.currentIds().add(BoxesRunTime.boxToInteger((int)id));
    }

    private int removeId(int index) {
        return BoxesRunTime.unboxToInt((Object)this.currentIds().remove(index));
    }

    private int numOfIds() {
        return this.currentIds().size();
    }

    private int maxId() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.currentIds()).asScala()).max((Ordering)Ordering.Int$.MODULE$));
    }

    private String INSERT() {
        return this.INSERT;
    }

    private String UPDATE() {
        return this.UPDATE;
    }

    private String DELETE() {
        return this.DELETE;
    }

    private Dataset<Row> generateRowsForInsert(SparkSession sparkSession) {
        IndexedSeq insertRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.maxId() + 1), this.maxId() + this.numInsertPerBatch()).map((Function1 & Serializable & scala.Serializable)x -> CDCExample$.$anonfun$generateRowsForInsert$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_CDCExample$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.CDCExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_CDCExample$$typecreator1$1() {
            }
        }
        return sparkSession.createDataFrame((Seq)insertRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator1$1()));
    }

    private Dataset<Row> generateRowsForDelete(SparkSession sparkSession) {
        IndexedSeq deletedRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numDeletePerBatch()).map((Function1 & Serializable & scala.Serializable)x -> CDCExample$.$anonfun$generateRowsForDelete$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_CDCExample$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.CDCExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_CDCExample$$typecreator1$2() {
            }
        }
        return sparkSession.createDataFrame((Seq)deletedRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator1$2()));
    }

    private Dataset<Row> generateRowsForUpdate(SparkSession sparkSession) {
        IndexedSeq updatedRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numUpdatePerBatch()).map((Function1 & Serializable & scala.Serializable)x -> CDCExample$.$anonfun$generateRowsForUpdate$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_CDCExample$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.CDCExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_CDCExample$$typecreator1$3() {
            }
        }
        return sparkSession.createDataFrame((Seq)updatedRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator1$3()));
    }

    private void generateTarget(SparkSession sparkSession) {
        Predef$.MODULE$.print((Object)"generating target table...");
        long time = this.timeIt((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            IndexedSeq insertRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), MODULE$.numInitialRows()).map((Function1 & Serializable & scala.Serializable)x -> CDCExample$.$anonfun$generateTarget$2(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
            IndexedSeq duplicatedRow = (IndexedSeq)insertRows.union((GenSeq)insertRows, IndexedSeq$.MODULE$.canBuildFrom());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_carbondata_examples_CDCExample$$typecreator1$4
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.carbondata.examples.CDCExample.Target").asType().toTypeConstructor();
                }

                public Org_apache_carbondata_examples_CDCExample$$typecreator1$4() {
                }
            }
            Dataset targetData = sparkSession.createDataFrame((Seq)duplicatedRow, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator1$4()));
            targetData.repartition(8).write().format("carbondata").option("tableName", "target").option("sort_scope", "global_sort").option("sort_column", "id").mode(SaveMode.Overwrite).save();
        });
        Predef$.MODULE$.println((Object)new StringBuilder(6).append("done! ").append(this.timeFormatted(time)).toString());
    }

    private void generateChange(SparkSession sparkSession) {
        Dataset<Row> update = this.generateRowsForUpdate(sparkSession);
        Dataset<Row> delete = this.generateRowsForDelete(sparkSession);
        Dataset<Row> insert = this.generateRowsForInsert(sparkSession);
        update.union(delete).union(insert).repartition(8).write().format("carbondata").option("tableName", "change").mode(SaveMode.Overwrite).save();
    }

    private Dataset<Row> readTargetData(SparkSession sparkSession) {
        return sparkSession.read().format("carbondata").option("tableName", "target").load();
    }

    private Dataset<Row> readChangeData(SparkSession sparkSession) {
        return sparkSession.read().format("carbondata").option("tableName", "change").load();
    }

    private long timeIt(Function0<BoxedUnit> func) {
        long start = System.nanoTime();
        func.apply$mcV$sp();
        return System.nanoTime() - start;
    }

    private String timeFormatted(long updateTime) {
        return new StringBuilder(2).append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)updateTime / (double)1000 / (double)1000 / (double)1000))), "%.2f")).append(" s").toString();
    }

    private void printTarget(SparkSession spark, int i) {
        block0: {
            if (!this.printDetail()) break block0;
            Predef$.MODULE$.println((Object)new StringBuilder(28).append("target table after CDC batch").append(i).toString());
            spark.sql("select * from target order by id").show(false);
        }
    }

    private void printChange(SparkSession spark, int i) {
        block0: {
            if (!this.printDetail()) break block0;
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("CDC batch").append(i).toString());
            spark.sql("select * from change").show(100, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SparkSession createSession() {
        void var2_2;
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master("local[8]").enableHiveSupport().config("spark.sql.warehouse.dir", new StringBuilder(32).append(rootPath).append("/examples/spark/target/warehouse").toString())).getOrCreateCarbonSession();
        return var2_2;
    }

    public void main(String[] args) {
        CarbonProperties.setAuditEnabled((boolean)false);
        SparkSession spark = this.createSession();
        spark.sparkContext().setLogLevel("error");
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("start CDC example using ").append(this.solution()).append(" solution").toString());
        spark.sql("drop table if exists target");
        spark.sql("drop table if exists change");
        this.generateTarget(spark);
        if (this.printDetail()) {
            Predef$.MODULE$.println((Object)"## target table");
            spark.sql("select * from target").show(100, false);
        }
        LongRef updateTime = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numBatch()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            MODULE$.generateChange(spark);
            MODULE$.printChange(spark, i);
            long time = MODULE$.timeIt((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Predef$.MODULE$.print((Object)new StringBuilder(24).append("applying change batch").append(i).append("...").toString());
                if (MODULE$.solution().equals("carbon")) {
                    MODULE$.carbonSolution(spark);
                } else {
                    MODULE$.hiveSolution(spark);
                }
            });
            updateTime$1.elem += time;
            Predef$.MODULE$.println((Object)new StringBuilder(6).append("done! ").append(MODULE$.timeFormatted(time)).toString());
            MODULE$.printTarget(spark, i);
        });
        long queryTime = this.timeIt((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> spark.sql("select * from target").collect());
        Predef$.MODULE$.println((Object)new StringBuilder(19).append("total update takes ").append(this.timeFormatted(updateTime.elem)).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("total query takes ").append(this.timeFormatted(queryTime)).toString());
        spark.close();
    }

    private void carbonSolution(SparkSession spark) {
        Dataset latestChangeForEachKey = this.readChangeData(spark).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "struct(mdt, value, change_type) as otherCols"})).groupBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.max("otherCols").as("latest"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "latest.*"}));
        Dataset<Row> target = this.readTargetData(spark);
        CarbonSession$.MODULE$.DataSetMerge(target.as("A")).merge(latestChangeForEachKey.as("B"), "A.id = B.id").whenMatched("B.change_type = 'D'").delete().whenMatched("B.change_type = 'U'").updateExpr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"B.id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"B.value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remark"), (Object)"'updated'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mdt"), (Object)"B.mdt")}))).whenNotMatched("B.change_type = 'I'").insertExpr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"B.id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"B.value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remark"), (Object)"'new'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mdt"), (Object)"B.mdt")}))).execute();
    }

    private Dataset<Row> hiveSolution(SparkSession spark) {
        Dataset latestChangeForEachKey = this.readChangeData(spark).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "struct(mdt, value, change_type) as otherCols"})).groupBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.max("otherCols").as("latest"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "latest.*"}));
        latestChangeForEachKey.createOrReplaceTempView("latest_change");
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | insert overwrite table target\n        | select * from\n        | (\n        |   select A.id, B.value, 'updated', B.mdt\n        |     from target A\n        |     right join latest_change B\n        |     on A.id = B.id\n        |     where B.change_type = 'U'\n        |   union all\n        |     select B.id, B.value, 'new', B.mdt\n        |     from latest_change B\n        |     where B.change_type = 'I'\n        |   union all\n        |     select A.id, A.value, A.remark, A.mdt\n        |     from target A\n        |     left join latest_change B\n        |     on A.id = B.id\n        |     where B.id is null\n        | ) T\n      ")).stripMargin());
    }

    public static final /* synthetic */ String $anonfun$values$1(int x) {
        return MODULE$.random().nextString(100);
    }

    public static final /* synthetic */ CDCExample.Change $anonfun$generateRowsForInsert$1(int x) {
        MODULE$.addId(x);
        return new CDCExample.Change(x, MODULE$.pickValue(), MODULE$.INSERT(), LocalDateTime.now().toString());
    }

    public static final /* synthetic */ CDCExample.Change $anonfun$generateRowsForDelete$1(int x) {
        int idIndex = MODULE$.random().nextInt(MODULE$.numOfIds());
        return new CDCExample.Change(MODULE$.getAndRemoveId(idIndex), "", MODULE$.DELETE(), LocalDateTime.now().toString());
    }

    public static final /* synthetic */ CDCExample.Change $anonfun$generateRowsForUpdate$1(int x) {
        int idIndex = MODULE$.random().nextInt(MODULE$.numOfIds());
        return new CDCExample.Change(MODULE$.getId(idIndex), MODULE$.pickValue(), MODULE$.UPDATE(), LocalDateTime.now().toString());
    }

    public static final /* synthetic */ CDCExample.Target $anonfun$generateTarget$2(int x) {
        MODULE$.addId(x);
        return new CDCExample.Target(x, MODULE$.pickValue(), "origin", LocalDateTime.now().toString());
    }

    private CDCExample$() {
        MODULE$ = this;
        this.solution = "carbon";
        this.printDetail = false;
        this.numInitialRows = 100000;
        this.numInsertPerBatch = 1000;
        this.numUpdatePerBatch = 9000;
        this.numDeletePerBatch = 1000;
        this.numBatch = 10;
        this.random = new Random();
        this.values = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1 & Serializable & scala.Serializable)x -> CDCExample$.$anonfun$values$1(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
        this.currentIds = new ArrayList(this.numInitialRows() * 2);
        this.INSERT = "I";
        this.UPDATE = "U";
        this.DELETE = "D";
    }
}

