/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import alluxio.cli.fs.FileSystemShell;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class AlluxioExample$ {
    public static AlluxioExample$ MODULE$;

    static {
        new AlluxioExample$();
    }

    public void main(String[] args) {
        SparkSession carbon = ExampleUtils$.MODULE$.createSparkSession("AlluxioExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        boolean runShell = args != null && args.length > 0 ? new StringOps(Predef$.MODULE$.augmentString(args[0])).toBoolean() : true;
        this.exampleBody(carbon, runShell);
        carbon.close();
    }

    public void exampleBody(SparkSession spark, boolean runShell) {
        Object object;
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        spark.sparkContext().hadoopConfiguration().set("fs.alluxio.impl", "alluxio.hadoop.FileSystem");
        FileFactory.getConfiguration().set("fs.alluxio.impl", "alluxio.hadoop.FileSystem");
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy/MM/dd");
        String time = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String alluxioPath = "alluxio://localhost:19998";
        ObjectRef alluxioFile = ObjectRef.create((Object)new StringBuilder(9).append(alluxioPath).append("/data.csv").toString());
        String remoteFile = new StringBuilder(19).append("/carbon_alluxio").append(time).append(".csv").toString();
        FileSystemShell mFsShell = null;
        if (runShell) {
            mFsShell = new FileSystemShell();
            alluxioFile.elem = new StringBuilder(0).append(alluxioPath).append(remoteFile).toString();
            String localFile = new StringBuilder(35).append(rootPath).append("/hadoop/src/test/resources/data.csv").toString();
            object = BoxesRunTime.boxToInteger((int)mFsShell.run(new String[]{"copyFromLocal", localFile, remoteFile}));
        } else {
            object = BoxedUnit.UNIT;
        }
        spark.sql("DROP TABLE IF EXISTS alluxio_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | CREATE TABLE IF NOT EXISTS alluxio_table(\n         |    ID Int,\n         |    date Date,\n         |    country String,\n         |    name String,\n         |    phonetype String,\n         |    serialname String,\n         |    salary Int)\n         | STORED AS carbondata\n         | TBLPROPERTIES(\n         |    'SORT_COLUMNS' = 'phonetype,name',\n         |    'TABLE_BLOCKSIZE'='32',\n         |    'AUTO_LOAD_MERGE'='true')\n       ")).stripMargin());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & java.io.Serializable & Serializable)i -> spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n           | LOAD DATA LOCAL INPATH '").append((String)alluxioFile.elem).append("'\n           | into table alluxio_table\n         ").toString())).stripMargin()));
        spark.sql("SELECT * FROM alluxio_table").show();
        spark.sql("SHOW SEGMENTS FOR TABLE alluxio_table").show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | SELECT country, count(salary) AS amount\n        | FROM alluxio_table\n        | WHERE country IN ('china','france')\n        | GROUP BY country\n      ")).stripMargin()).show();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1 & java.io.Serializable & Serializable)i -> spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(87).append("\n           | LOAD DATA LOCAL INPATH '").append((String)alluxioFile.elem).append("'\n           | into table alluxio_table\n         ").toString())).stripMargin()));
        spark.sql("SHOW SEGMENTS FOR TABLE alluxio_table").show();
        if (runShell) {
            mFsShell.run(new String[]{"rm", remoteFile});
            mFsShell.close();
        }
        spark.sql("DROP TABLE IF EXISTS alluxio_table");
    }

    public boolean exampleBody$default$2() {
        return true;
    }

    private AlluxioExample$() {
        MODULE$ = this;
    }
}

