/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.benchmark;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.carbondata.benchmark.Query;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.spark.util.DataGenerator$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SimpleQueryBenchmark$ {
    public static SimpleQueryBenchmark$ MODULE$;
    private final Query[] queries;

    static {
        new SimpleQueryBenchmark$();
    }

    public String parquetTableName() {
        return "comparetest_parquet";
    }

    public String orcTableName() {
        return "comparetest_orc";
    }

    public String carbonTableName(String version) {
        return new StringBuilder(19).append("comparetest_carbonV").append(version).toString();
    }

    public Query[] queries() {
        return this.queries;
    }

    private double loadParquetTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset dfWithPartition = input.withColumn("partitionCol", input.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)10)));
            dfWithPartition.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionCol"})).mode(SaveMode.Overwrite).parquet(table);
            spark.read().parquet(table).createOrReplaceTempView(table);
        });
    }

    private double loadOrcTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            input.write().mode(SaveMode.Overwrite).orc(table);
            spark.read().orc(table).createOrReplaceTempView(table);
        });
    }

    private double loadCarbonTable(SparkSession spark, Dataset<Row> input, String tableName) {
        CarbonProperties.getInstance().addProperty("carbon.data.file.version", "V3");
        spark.sql(new StringBuilder(21).append("drop table if exists ").append(tableName).toString());
        return this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.write().format("carbondata").option("tableName", tableName).option("table_blocksize", "32").mode(SaveMode.Overwrite).save());
    }

    private void prepareTable(SparkSession spark, String table1, String table2) {
        double d;
        Dataset df = DataGenerator$.MODULE$.generateDataFrame(spark, 100000).cache();
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("loading ").append(df.count()).append(" records, schema: ").append(df.schema()).toString());
        if (table1.endsWith("parquet")) {
            d = this.loadParquetTable(spark, (Dataset<Row>)df, table1);
        } else if (table1.endsWith("orc")) {
            d = this.loadOrcTable(spark, (Dataset<Row>)df, table1);
        } else {
            throw package$.MODULE$.error(new StringBuilder(15).append("invalid table: ").append(table1).toString());
        }
        double table1Time = d;
        double table2Time = this.loadCarbonTable(spark, (Dataset<Row>)df, table2);
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("load completed, time: ").append(table1Time).append(", ").append(table2Time).toString());
        df.unpersist();
    }

    private Tuple2<Object, Row[]>[] runQueries(SparkSession spark, String tableName) {
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("start running queries for ").append(tableName).append("...").toString());
        ObjectRef result = ObjectRef.create(null);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.queries())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Query query = (Query)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String sqlText = query.sqlText().replace("$table", tableName);
            Predef$.MODULE$.print((Object)new StringBuilder(17).append("running query ").append(index + 1).append(": ").append(sqlText).append(" ").toString());
            double rt = MODULE$.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                result$1.elem = (Row[])spark.sql(sqlText).collect();
            });
            Predef$.MODULE$.println((Object)new StringBuilder(7).append("=> ").append(rt).append(" sec").toString());
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)rt), (Object)((Row[])result$1.elem));
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    private void printErrorIfNotMatch(int index, String table1, Row[] result1, String table2, Row[] result2) {
        if (result1.length != result2.length) {
            int num = index + 1;
            Predef$.MODULE$.println((Object)new StringBuilder(20).append(table1).append(" result for query ").append(num).append(": ").toString());
            Predef$.MODULE$.println((Object)String.valueOf(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result1)).mkString(",")));
            Predef$.MODULE$.println((Object)new StringBuilder(20).append(table2).append(" result for query ").append(num).append(": ").toString());
            Predef$.MODULE$.println((Object)String.valueOf(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result2)).mkString(",")));
            throw package$.MODULE$.error(new StringBuilder(33).append("result not matching for query ").append(num).append(" (").append(this.queries()[index].desc()).append(")").toString());
        }
    }

    private void runTest(SparkSession spark, String table1, String table2) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        Tuple2<Object, Row[]>[] table1Result = this.runQueries(spark, table1);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        Tuple2<Object, Row[]>[] table2Result = this.runQueries(spark, table2);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table1Result)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SimpleQueryBenchmark$.$anonfun$runTest$1(table1, table2, table2Result, x0$1);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.queries())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            SimpleQueryBenchmark$.$anonfun$runTest$2(table1, table1Result, table2, table2Result, formatter, date, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        CarbonProperties.getInstance().addProperty("carbon.enable.vector.reader", "true").addProperty("enable.unsafe.sort", "true").addProperty("carbon.blockletgroup.size.in.mb", "32").addProperty("enable.unsafe.columnpage", "true");
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        String storeLocation = new StringBuilder(28).append(rootPath).append("/examples/spark/target/store").toString();
        Option master = Option$.MODULE$.apply((Object)System.getProperty("spark.master")).orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"MASTER")).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)"local[8]"));
        SparkSession spark = SparkSession$.MODULE$.builder().master((String)master.get()).enableHiveSupport().config("spark.driver.host", "127.0.0.1").config("spark.sql.extensions", "org.apache.spark.sql.CarbonExtensions").getOrCreate();
        spark.sparkContext().setLogLevel("warn");
        String table1 = this.parquetTableName();
        String table2 = this.carbonTableName("3");
        this.prepareTable(spark, table1, table2);
        this.runTest(spark, table1, table2);
        CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(table1)});
        spark.sql(new StringBuilder(21).append("drop table if exists ").append(table2).toString());
        spark.close();
    }

    public double time(Function0<BoxedUnit> code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    public static final /* synthetic */ void $anonfun$runTest$1(String table1$1, String table2$1, Tuple2[] table2Result$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 result = (Tuple2)tuple2._1();
        int index = tuple2._2$mcI$sp();
        MODULE$.printErrorIfNotMatch(index, table1$1, (Row[])result._2(), table2$1, (Row[])table2Result$1[index]._2());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$runTest$2(String table1$1, Tuple2[] table1Result$1, String table2$1, Tuple2[] table2Result$1, SimpleDateFormat formatter$1, Date date$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Query query = (Query)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Predef$.MODULE$.println((Object)new StringBuilder(2).append("{").append(new StringBuilder(12).append("\"query\":\"").append(index + 1).append("\", ").toString()).append(new StringBuilder(10).append("\"").append(table1$1).append(" time\":").append(table1Result$1[index]._1$mcD$sp()).append(", ").toString()).append(new StringBuilder(10).append("\"").append(table2$1).append(" time\":").append(table2Result$1[index]._1$mcD$sp()).append(", ").toString()).append(new StringBuilder(12).append("\"fetched\":").append(((Row[])table1Result$1[index]._2()).length).append(", ").toString()).append(new StringBuilder(11).append("\"type\":\"").append(query.queryType()).append("\", ").toString()).append(new StringBuilder(12).append("\"desc\":\"").append(query.desc()).append("\",  ").toString()).append(new StringBuilder(11).append("\"date\": \"").append(formatter$1.format(date$1)).append("\" ").toString()).append("}").toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SimpleQueryBenchmark$() {
        MODULE$ = this;
        this.queries = (Query[])((Object[])new Query[]{new Query("select sum(m1) from $table", "full scan", "full scan query, 1 aggregate"), new Query("select sum(m1), sum(m2) from $table", "full scan", "full scan query, 2 aggregate"), new Query("select sum(m1), sum(m2), sum(m3) from $table", "full scan", "full scan query, 3 aggregate"), new Query("select sum(m1), sum(m2), sum(m3), sum(m4) from $table", "full scan", "full scan query, 4 aggregate"), new Query("select sum(m1), sum(m2), sum(m3), sum(m4), avg(m5) from $table", "full scan", "full scan query, 5 aggregate"), new Query("select count(distinct id) from $table", "full scan", "full scan and count distinct of high card column"), new Query("select count(distinct country) from $table", "full scan", "full scan and count distinct of medium card column"), new Query("select count(distinct city) from $table", "full scan", "full scan and count distinct of low card column"), new Query("select country, sum(m1) as metric from $table group by country order by metric", "aggregate", "group by on big data, on medium card column, medium result set,"), new Query("select city, sum(m1) as metric from $table group by city order by metric", "aggregate", "group by on big data, on low card column, small result set,"), new Query("select id, sum(m1) as metric from $table group by id order by metric desc limit 100", "topN", "top N on high card column"), new Query("select country,sum(m1) as metric from $table group by country order by metric desc limit 10", "topN", "top N on medium card column"), new Query("select city,sum(m1) as metric from $table group by city order by metric desc limit 10", "topN", "top N on low card column"), new Query("select country, sum(m1) as metric from $table where city='city8' group by country order by metric", "filter scan and aggregate", "group by on large data, small result set"), new Query("select id, sum(m1) as metric from $table where planet='planet10' group by id order by metric", "filter scan and aggregate", "group by on medium data, large result set"), new Query("select city, sum(m1) as metric from $table where country='country12' group by city order by metric", "filter scan and aggregate", "group by on medium data, small result set"), new Query("select * from $table where city = 'city3' limit 10000", "filter scan", "filter on low card dimension, limit, medium result set, fetch all columns"), new Query("select * from $table where country = 'country9' ", "filter scan", "filter on low card dimension, medium result set, fetch all columns"), new Query("select * from $table where planet = 'planet101' ", "filter scan", "filter on medium card dimension, small result set, fetch all columns"), new Query("select * from $table where id = '408938' ", "filter scan", "filter on high card dimension"), new Query("select * from $table where country='country10000'  ", "filter scan", "filter on low card dimension, not exist"), new Query("select * from $table where country='country2' and city ='city8' ", "filter scan", "filter on 2 dimensions, small result set, fetch all columns"), new Query("select * from $table where city='city1' and country='country2' and planet ='planet3' ", "filter scan", "filter on 3 dimensions, small result set, fetch all columns"), new Query("select * from $table where m1 < 3", "filter scan", "filter on measure, small result set, fetch all columns"), new Query("select * from $table where id like '1%' ", "fuzzy filter scan", "like filter, big result set"), new Query("select * from $table where id like '%111'", "fuzzy filter scan", "like filter, medium result set"), new Query("select * from $table where id like 'xyz%' ", "fuzzy filter scan", "like filter, full scan but not exist")});
    }
}

