/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.benchmark;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import org.apache.carbondata.benchmark.SCDType2Benchmark;
import org.apache.carbondata.benchmark.SCDType2Benchmark$;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SCDType2Benchmark$ {
    public static SCDType2Benchmark$ MODULE$;
    private final int numOrders;
    private final int numUpdateOrdersDaily;
    private final int newNewOrdersDaily;
    private final int numDays;
    private final boolean printDetail;

    static {
        new SCDType2Benchmark$();
    }

    public int numOrders() {
        return this.numOrders;
    }

    public int numUpdateOrdersDaily() {
        return this.numUpdateOrdersDaily;
    }

    public int newNewOrdersDaily() {
        return this.newNewOrdersDaily;
    }

    public int numDays() {
        return this.numDays;
    }

    public boolean printDetail() {
        return this.printDetail;
    }

    public Dataset<Row> generateDataForDay0(SparkSession sparkSession, int numOrders, Date startDate) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.benchmark.SCDType2Benchmark.Order").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$1() {
            }
        }
        return sparkSession.implicits().rddToDatasetHolder(sparkSession.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numOrders), 4, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> SCDType2Benchmark$.$anonfun$generateDataForDay0$1(startDate, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(SCDType2Benchmark.Order.class)), sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$1()))).toDS().toDF();
    }

    public int generateDataForDay0$default$2() {
        return 1000000;
    }

    public Date generateDataForDay0$default$3() {
        return Date.valueOf("2018-05-01");
    }

    public Dataset<Row> generateDailyChange(SparkSession sparkSession, int numUpdatedOrders, Date startDate, Date updateDate, int newState, int numNewOrders) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.benchmark.SCDType2Benchmark.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$2() {
            }
        }
        Dataset ds1 = sparkSession.implicits().rddToDatasetHolder(sparkSession.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numUpdatedOrders), 4, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> SCDType2Benchmark$.$anonfun$generateDailyChange$1(updateDate, newState, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(SCDType2Benchmark.Change.class)), sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$2()))).toDS().toDF();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.benchmark.SCDType2Benchmark.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator13$1() {
            }
        }
        Dataset ds2 = sparkSession.implicits().rddToDatasetHolder(sparkSession.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numNewOrders), 4, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> SCDType2Benchmark$.$anonfun$generateDailyChange$2(updateDate, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(SCDType2Benchmark.Change.class)), sparkSession.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator13$1()))).toDS().toDF();
        return ds1.union(ds2);
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
        SparkSession spark2 = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master("local[8]").enableHiveSupport().config("spark.sql.warehouse.dir", new StringBuilder(32).append(rootPath).append("/examples/spark/target/warehouse").toString())).getOrCreateCarbonSession();
        spark2.sparkContext().setLogLevel("error");
        spark2.sql("drop table if exists dw_order_solution1");
        spark2.sql("drop table if exists dw_order_solution2");
        spark2.sql("drop table if exists change");
        Dataset<Row> baseData = this.generateDataForDay0(spark2, this.numOrders(), Date.valueOf("2018-05-01"));
        baseData.write().format("carbondata").option("tableName", "dw_order_solution1").mode(SaveMode.Overwrite).save();
        baseData.write().format("carbondata").option("tableName", "dw_order_solution2").option("sort_columns", "order_id").mode(SaveMode.Overwrite).save();
        ObjectRef startDate = ObjectRef.create((Object)Date.valueOf("2018-05-01"));
        IntRef state = IntRef.create((int)2);
        LongRef solution1UpdateTime = LongRef.create((long)0L);
        LongRef solution2UpdateTime = LongRef.create((long)0L);
        if (this.printDetail()) {
            Predef$.MODULE$.println((Object)"## day0");
            spark2.sql("select * from dw_order").show(100, false);
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numDays()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Date newDate = new Date(DateUtils.addDays((java.util.Date)((Date)startDate$2.elem), (int)1).getTime());
            Dataset<Row> changeData = MODULE$.generateDailyChange(spark2, MODULE$.numUpdateOrdersDaily(), (Date)startDate$2.elem, newDate, state$1.elem, MODULE$.newNewOrdersDaily());
            changeData.write().format("carbondata").option("tableName", "change").mode(SaveMode.Overwrite).save();
            if (MODULE$.printDetail()) {
                Predef$.MODULE$.println((Object)new StringBuilder(10).append("day").append(i).append(" Change").toString());
                spark2.sql("select * from change").show(100, false);
            }
            solution1UpdateTime$1.elem += SCDType2Benchmark$.timeIt$1((Function1 & Serializable & scala.Serializable)spark -> {
                SCDType2Benchmark$.MODULE$.solution1(spark);
                return BoxedUnit.UNIT;
            }, spark2);
            solution2UpdateTime$1.elem += SCDType2Benchmark$.timeIt$1((Function1 & Serializable & scala.Serializable)spark -> {
                SCDType2Benchmark$.MODULE$.solution2(spark);
                return BoxedUnit.UNIT;
            }, spark2);
            if (MODULE$.printDetail()) {
                Predef$.MODULE$.println((Object)new StringBuilder(10).append("day").append(i).append(" result").toString());
                spark2.sql("select * from dw_order_solution1").show(false);
                spark2.sql("select * from dw_order_solution2").show(false);
            }
            startDate$2.elem = newDate;
            ++state$1.elem;
        });
        long solution1QueryTime = SCDType2Benchmark$.timeIt$1((Function1 & Serializable & scala.Serializable)spark -> {
            SCDType2Benchmark$.$anonfun$main$4(spark);
            return BoxedUnit.UNIT;
        }, spark2);
        long solution2QueryTime = SCDType2Benchmark$.timeIt$1((Function1 & Serializable & scala.Serializable)spark -> {
            SCDType2Benchmark$.$anonfun$main$5(spark);
            return BoxedUnit.UNIT;
        }, spark2);
        Predef$.MODULE$.println((Object)new StringBuilder(34).append("overwrite solution update takes ").append(solution1UpdateTime.elem / 1000L / 1000L / 1000L).append(" s").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("update solution update takes ").append(solution2UpdateTime.elem / 1000L / 1000L / 1000L).append(" s").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("overwrite solution query takes ").append(solution1QueryTime / 1000L / 1000L / 1000L).append(" s").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("update solution query takes ").append(solution2QueryTime / 1000L / 1000L / 1000L).append(" s").toString());
        spark2.close();
    }

    private Dataset<Row> solution1(SparkSession spark) {
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | insert overwrite table dw_order_solution1\n        | select * from\n        | (\n        |   select A.order_id, A.customer_id, A.start_date,\n        |     case when A.end_date > B.update_date then B.update_date\n        |     else A.end_date\n        |     end as end_date,\n        |   A.state\n        |   from dw_order_solution1 A\n        |   left join change B\n        |   on A.order_id = B.order_id\n        |   union all\n        |     select B.order_id, B.customer_id, B.update_date, date(\"9999-01-01\"), B.state\n        |     from change B\n        | ) T\n      ")).stripMargin());
    }

    private Dataset<Row> solution2(SparkSession spark) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | update dw_order_solution2 A\n        | set (A.end_date) =\n        |   (select B.update_date\n        |   from change B\n        |   where A.order_id = B.order_id and A.end_date > B.update_date)\n      ")).stripMargin()).show();
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | insert into dw_order_solution2\n        | select B.order_id, B.customer_id, B.update_date, date('9999-12-30'), B.state\n        | from change B\n      ")).stripMargin());
    }

    public static final /* synthetic */ SCDType2Benchmark.Order $anonfun$generateDataForDay0$1(Date startDate$1, int x) {
        return new SCDType2Benchmark.Order(new StringBuilder(5).append("order").append(x).toString(), new StringBuilder(8).append("customer").append(x).toString(), startDate$1, Date.valueOf("9999-01-01"), 1);
    }

    public static final /* synthetic */ SCDType2Benchmark.Change $anonfun$generateDailyChange$1(Date updateDate$1, int newState$1, int x) {
        return new SCDType2Benchmark.Change(new StringBuilder(5).append("order").append(x).toString(), new StringBuilder(8).append("customer").append(x).toString(), updateDate$1, newState$1);
    }

    public static final /* synthetic */ SCDType2Benchmark.Change $anonfun$generateDailyChange$2(Date updateDate$1, int x) {
        return new SCDType2Benchmark.Change(new StringBuilder(8).append("newOrder").append(System.currentTimeMillis()).toString(), new StringBuilder(8).append("customer").append(x).toString(), updateDate$1, 1);
    }

    private static final long timeIt$1(Function1 func, SparkSession spark$1) {
        long start = System.nanoTime();
        func.apply((Object)spark$1);
        return System.nanoTime() - start;
    }

    public static final /* synthetic */ void $anonfun$main$4(SparkSession spark) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n         | select sum(state) as sum, customer_id\n         | from dw_order_solution1\n         | group by customer_id\n         | order by sum\n         | limit 10\n         |")).stripMargin()).collect();
    }

    public static final /* synthetic */ void $anonfun$main$5(SparkSession spark) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n           | select sum(state) as sum, customer_id\n           | from dw_order_solution2\n           | group by customer_id\n           | order by sum\n           | limit 10\n           |")).stripMargin()).collect();
    }

    private SCDType2Benchmark$() {
        MODULE$ = this;
        this.numOrders = 10000000;
        this.numUpdateOrdersDaily = 10000;
        this.newNewOrdersDaily = 10000;
        this.numDays = 3;
        this.printDetail = false;
    }
}

