/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.benchmark;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.benchmark.ConcurrentQueryBenchmark;
import org.apache.carbondata.benchmark.Query;
import org.apache.carbondata.core.constants.CarbonVersionConstants;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.spark.util.DataGenerator$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.CarbonEnv$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import scala.util.Random;

public final class ConcurrentQueryBenchmark$ {
    public static ConcurrentQueryBenchmark$ MODULE$;
    private int tmpId;
    private String tmpCity;
    private Query[] queries;
    private int totalNum;
    private int threadNum;
    private int taskNum;
    private boolean resultIsEmpty;
    private String path;
    private boolean runInLocal;
    private boolean generateFile;
    private boolean deleteFile;
    private String storeLocation;
    private final int cardinalityId;
    private final int cardinalityCity;
    private final Random r;
    private volatile byte bitmap$0;

    static {
        new ConcurrentQueryBenchmark$();
    }

    public int totalNum() {
        return this.totalNum;
    }

    public void totalNum_$eq(int x$1) {
        this.totalNum = x$1;
    }

    public int threadNum() {
        return this.threadNum;
    }

    public void threadNum_$eq(int x$1) {
        this.threadNum = x$1;
    }

    public int taskNum() {
        return this.taskNum;
    }

    public void taskNum_$eq(int x$1) {
        this.taskNum = x$1;
    }

    public boolean resultIsEmpty() {
        return this.resultIsEmpty;
    }

    public void resultIsEmpty_$eq(boolean x$1) {
        this.resultIsEmpty = x$1;
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    public boolean runInLocal() {
        return this.runInLocal;
    }

    public void runInLocal_$eq(boolean x$1) {
        this.runInLocal = x$1;
    }

    public boolean generateFile() {
        return this.generateFile;
    }

    public void generateFile_$eq(boolean x$1) {
        this.generateFile = x$1;
    }

    public boolean deleteFile() {
        return this.deleteFile;
    }

    public void deleteFile_$eq(boolean x$1) {
        this.deleteFile = x$1;
    }

    public String storeLocation() {
        return this.storeLocation;
    }

    public void storeLocation_$eq(String x$1) {
        this.storeLocation = x$1;
    }

    public int cardinalityId() {
        return this.cardinalityId;
    }

    public int cardinalityCity() {
        return this.cardinalityCity;
    }

    public String parquetTableName() {
        return new StringBuilder(23).append("Num").append(this.totalNum()).append("_").append("comparetest_parquet").toString();
    }

    public String orcTableName() {
        return new StringBuilder(19).append("Num").append(this.totalNum()).append("_").append("comparetest_orc").toString();
    }

    public String carbonTableName(String version) {
        return new StringBuilder(4).append("Num").append(this.totalNum()).append("_").append(new StringBuilder(19).append("comparetest_carbonV").append(version).toString()).toString();
    }

    public Random r() {
        return this.r;
    }

    private int tmpId$lzycompute() {
        ConcurrentQueryBenchmark$ concurrentQueryBenchmark$ = this;
        synchronized (concurrentQueryBenchmark$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tmpId = this.r().nextInt(this.cardinalityId()) % this.totalNum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tmpId;
    }

    public int tmpId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tmpId$lzycompute() : this.tmpId;
    }

    private String tmpCity$lzycompute() {
        ConcurrentQueryBenchmark$ concurrentQueryBenchmark$ = this;
        synchronized (concurrentQueryBenchmark$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tmpCity = new StringBuilder(4).append("city").append(this.r().nextInt(this.cardinalityCity()) % this.totalNum()).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tmpCity;
    }

    public String tmpCity() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tmpCity$lzycompute() : this.tmpCity;
    }

    private Query[] queries$lzycompute() {
        ConcurrentQueryBenchmark$ concurrentQueryBenchmark$ = this;
        synchronized (concurrentQueryBenchmark$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.queries = (Query[])((Object[])new Query[]{new Query(new StringBuilder(20).append("select * from $table").append(new StringBuilder(15).append(" where id = '").append(this.tmpId()).append("' ").toString()).toString(), "filter scan", "filter on high card dimension"), new Query(new StringBuilder(21).append("select id from $table").append(new StringBuilder(15).append(" where id = '").append(this.tmpId()).append("' ").toString()).toString(), "filter scan", "filter on high card dimension"), new Query(new StringBuilder(23).append("select city from $table").append(new StringBuilder(15).append(" where id = '").append(this.tmpId()).append("' ").toString()).toString(), "filter scan", "filter on high card dimension"), new Query(new StringBuilder(20).append("select * from $table").append(new StringBuilder(26).append(" where city = '").append(this.tmpCity()).append("' limit 100").toString()).toString(), "filter scan", "filter on low card dimension, medium result set, fetch all columns"), new Query(new StringBuilder(23).append("select city from $table").append(new StringBuilder(26).append(" where city = '").append(this.tmpCity()).append("' limit 100").toString()).toString(), "filter scan", "filter on low card dimension"), new Query(new StringBuilder(21).append("select id from $table").append(new StringBuilder(27).append(" where city = '").append(this.tmpCity()).append("'  limit 100").toString()).toString(), "filter scan", "filter on low card dimension"), new Query("select country, sum(m1) from $table group by country", "aggregate", "group by on big data, on medium card column, medium result set,"), new Query(new StringBuilder(35).append("select country, sum(m1) from $table").append(new StringBuilder(31).append(" where id = '").append(this.tmpId()).append("' group by country").toString()).toString(), "aggregate", "group by on big data, on medium card column, medium result set,"), new Query(new StringBuilder(59).append("select t1.country, sum(t1.m1) from $table t1 join $table t2").append(new StringBuilder(54).append(" on t1.id = t2.id where t1.id = '").append(this.tmpId()).append("' group by t1.country").toString()).toString(), "aggregate", "group by on big data, on medium card column, medium result set,"), new Query(new StringBuilder(250).append("select t2.country, sum(t2.m1) from $table t1 join $table t2 join $table t3 join $table t4 join $table t5 join $table t6 join $table t7 ").append("on t1.id=t2.id and t1.id=t3.id and t1.id=t4.id ").append("and t1.id=t5.id and t1.id=t6.id and ").append("t1.id=t7.id ").append(new StringBuilder(18).append(" where t2.id = '").append(this.tmpId()).append("' ").toString()).append(" group by t2.country").toString(), "aggregate", "group by on big data, on medium card column, medium result set,")});
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.queries;
    }

    public Query[] queries() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.queries$lzycompute() : this.queries;
    }

    private double generateParquetTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset dfWithPartition = input.withColumn("partitionCol", input.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)10)));
            dfWithPartition.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionCol"})).mode(SaveMode.Overwrite).parquet(table);
        });
    }

    private double generateOrcTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.write().mode(SaveMode.Overwrite).orc(table));
    }

    private double generateCarbonTable(SparkSession spark, Dataset<Row> input, String tableName) {
        CarbonProperties.getInstance().addProperty("carbon.data.file.version", "3");
        spark.sql(new StringBuilder(21).append("drop table if exists ").append(tableName).toString());
        return this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> input.write().format("carbondata").option("tableName", tableName).option("tempCSV", "false").option("table_blocksize", "32").mode(SaveMode.Overwrite).save());
    }

    public void prepareTable(SparkSession spark, String table1, String table2) {
        block0: {
            Dataset df = this.generateFile() ? DataGenerator$.MODULE$.generateDataFrame(spark, this.totalNum()).cache() : null;
            double table1Time = this.time((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (table1.endsWith("parquet")) {
                    Object object = MODULE$.generateFile() ? BoxesRunTime.boxToDouble((double)MODULE$.generateParquetTable(spark, (Dataset<Row>)df, new StringBuilder(1).append(MODULE$.storeLocation()).append("/").append(table1).toString())) : BoxedUnit.UNIT;
                    spark.read().parquet(new StringBuilder(1).append(MODULE$.storeLocation()).append("/").append(table1).toString()).createOrReplaceTempView(table1);
                } else if (table1.endsWith("orc")) {
                    if (MODULE$.generateFile()) {
                        MODULE$.generateOrcTable(spark, (Dataset<Row>)df, table1);
                        spark.read().orc(table1).createOrReplaceTempView(table1);
                    }
                } else {
                    throw package$.MODULE$.error(new StringBuilder(15).append("invalid table: ").append(table1).toString());
                }
            });
            Predef$.MODULE$.println((Object)new StringBuilder(22).append(table1).append(" completed, time: ").append(table1Time).append(" sec").toString());
            double table2Time = this.generateFile() ? this.generateCarbonTable(spark, (Dataset<Row>)df, table2) : 0.0;
            Predef$.MODULE$.println((Object)new StringBuilder(22).append(table2).append(" completed, time: ").append(table2Time).append(" sec").toString());
            if (df == null) break block0;
            df.unpersist();
        }
    }

    private void runQueries(SparkSession spark, String tableName) {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("Start running queries for ").append(tableName).append("...").toString());
        Predef$.MODULE$.println((Object)"Min: min time\tMax: max time\t90%: 90% time\t99%: 99% time\tAvg: average time\tCount: number of result\tQuery X: running different query sql\tResult: show it when ResultIsEmpty is false\tTotal execute time: total runtime");
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.queries())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConcurrentQueryBenchmark$.$anonfun$runQueries$1(tableName, spark, x0$1);
            return BoxedUnit.UNIT;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
    }

    public void writeResults(SparkSession spark, List<Future<ConcurrentQueryBenchmark.Results>> results, String sql, long start, String filePath) {
        Tuple3[] timeArray = new Tuple3[results.size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), results.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            timeArray$1[i] = new Tuple3((Object)BoxesRunTime.boxToDouble((double)((double)(((ConcurrentQueryBenchmark.Results)((Future)results.get(i)).get()).startTime() - start) / 1000000.0)), (Object)BoxesRunTime.boxToDouble((double)((double)(((ConcurrentQueryBenchmark.Results)((Future)results.get(i)).get()).endTime() - start) / 1000000.0)), (Object)BoxesRunTime.boxToDouble((double)((double)(((ConcurrentQueryBenchmark.Results)((Future)results.get(i)).get()).endTime() - ((ConcurrentQueryBenchmark.Results)((Future)results.get(i)).get()).startTime()) / 1000000.0)));
        });
        Tuple3[] timeArraySorted = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeArray)).sortBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)ConcurrentQueryBenchmark$.$anonfun$writeResults$2(x)), (Ordering)Ordering.Double$.MODULE$);
        String[] timeArrayString = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])timeArraySorted)).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(4).append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(e._1()), "%.3f")).append(",\t").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(e._2()), "%.3f")).append(",\t").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(e._3()), "%.3f")).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] saveArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{sql, "startTime, endTime, runtime, measure time by the microsecond", String.valueOf(BoxesRunTime.boxToInteger((int)timeArrayString.length))})).union((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])timeArrayString), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        RDD rdd = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])saveArray), 1, ClassTag$.MODULE$.apply(String.class));
        rdd.saveAsTextFile(filePath);
    }

    public String writeResults$default$3() {
        return "";
    }

    public void printResults(List<Future<ConcurrentQueryBenchmark.Results>> results, String sql, long tasksStartTime) {
        double[] timeArray = new double[results.size()];
        Row[] sqlResult = results.get(0).get().sqlResult();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), results.size()).foreach((Function1 & Serializable & scala.Serializable)i -> ConcurrentQueryBenchmark$.$anonfun$printResults$1(results, BoxesRunTime.unboxToInt((Object)i)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), results.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            timeArray$2[i] = ((ConcurrentQueryBenchmark.Results)((Future)results.get(i)).get()).time();
        });
        double[] sortTimeArray = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(timeArray)).sorted((Ordering)Ordering.Double$.MODULE$);
        int time90 = (int)((double)sortTimeArray.length * 0.9) - 1;
        int time99 = (int)((double)sortTimeArray.length * 0.99) - 1;
        Predef$.MODULE$.print((Object)new StringBuilder(59).append("Min: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sortTimeArray)).head()), "%.3f")).append(" s,").append("\tMax: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sortTimeArray)).last()), "%.3f")).append(" s,").append("\t90%: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)sortTimeArray[time90])), "%.3f")).append(" s,").append("\t99%: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)sortTimeArray[time99])), "%.3f")).append(" s,").append("\tAvg: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(timeArray)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)timeArray.length))), "%.3f")).append(" s,").append("\t\tCount: ").append(results.get(0).get().count()).append("\t\t\t\t").append(sql).append("\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sqlResult)).mkString(",")).append("\t").toString());
    }

    public String printResults$default$2() {
        return "";
    }

    public void runTest(SparkSession spark, String table1, String table2) {
        this.runQueries(spark, table1);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        this.runQueries(spark, table2);
    }

    public double time(Function0<BoxedUnit> code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    public void initParameters(String[] arr) {
        block24: {
            if (arr.length > 0) {
                this.totalNum_$eq(new StringOps(Predef$.MODULE$.augmentString(arr[0])).toInt());
            }
            if (arr.length > 1) {
                this.threadNum_$eq(new StringOps(Predef$.MODULE$.augmentString(arr[1])).toInt());
            }
            if (arr.length > 2) {
                this.taskNum_$eq(new StringOps(Predef$.MODULE$.augmentString(arr[2])).toInt());
            }
            if (arr.length > 3) {
                boolean bl;
                if (arr[3].equalsIgnoreCase("true")) {
                    bl = true;
                } else if (arr[3].equalsIgnoreCase("false")) {
                    bl = false;
                } else {
                    throw new Exception("error parameter, should be true or false");
                }
                this.resultIsEmpty_$eq(bl);
            }
            if (arr.length > 4) {
                this.path_$eq(arr[4]);
            }
            if (arr.length > 5) {
                boolean bl;
                if (arr[5].equalsIgnoreCase("true")) {
                    String rootPath = new File(new StringBuilder(11).append(this.getClass().getResource("/").getPath()).append("../../../..").toString()).getCanonicalPath();
                    this.storeLocation_$eq(new StringBuilder(28).append(rootPath).append("/examples/spark/target/store").toString());
                    bl = true;
                } else if (arr[5].equalsIgnoreCase("false")) {
                    bl = false;
                } else {
                    throw new Exception("error parameter, should be true or false");
                }
                this.runInLocal_$eq(bl);
            }
            if (arr.length > 6) {
                boolean bl;
                if (arr[6].equalsIgnoreCase("true")) {
                    bl = true;
                } else if (arr[6].equalsIgnoreCase("false")) {
                    bl = false;
                } else {
                    throw new Exception("error parameter, should be true or false");
                }
                this.generateFile_$eq(bl);
            }
            if (arr.length > 7) {
                boolean bl;
                if (arr[7].equalsIgnoreCase("true")) {
                    bl = true;
                } else if (arr[7].equalsIgnoreCase("false")) {
                    bl = false;
                } else {
                    throw new Exception("error parameter, should be true or false");
                }
                this.deleteFile_$eq(bl);
            }
            if (arr.length <= 8) break block24;
            this.storeLocation_$eq(arr[8]);
        }
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        CarbonProperties.getInstance().addProperty("carbon.enable.vector.reader", "true").addProperty("enable.unsafe.sort", "true").addProperty("carbon.blockletgroup.size.in.mb", "32").addProperty("enable.unsafe.columnpage", "false").addProperty("enable.unsafe.in.query.processing", "false");
        this.initParameters(args);
        String table1 = this.parquetTableName();
        String table2 = this.carbonTableName("3");
        String parameters = new StringBuilder(117).append("totalNum: ").append(this.totalNum()).append("\tthreadNum: ").append(this.threadNum()).append("\ttaskNum: ").append(this.taskNum()).append("\tresultIsEmpty: ").append(this.resultIsEmpty()).append("\tfile path: ").append(this.path()).append("\trunInLocal: ").append(this.runInLocal()).append("\tgenerateFile: ").append(this.generateFile()).append("\tdeleteFile: ").append(this.deleteFile()).append("\tstoreLocation: ").append(this.storeLocation()).toString();
        SparkSession spark = this.runInLocal() ? SparkSession$.MODULE$.builder().appName(parameters).master("local[8]").enableHiveSupport().config("spark.sql.extensions", "org.apache.spark.sql.CarbonExtensions").getOrCreate() : SparkSession$.MODULE$.builder().appName(parameters).enableHiveSupport().config("spark.sql.extensions", "org.apache.spark.sql.CarbonExtensions").getOrCreate();
        CarbonEnv$.MODULE$.getInstance(spark);
        spark.sparkContext().setLogLevel("ERROR");
        Predef$.MODULE$.println((Object)"\nEnvironment information:");
        String[] env = (String[])((Object[])new String[]{"spark.master", "spark.driver.cores", "spark.driver.memory", "spark.executor.cores", "spark.executor.memory", "spark.executor.instances"});
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])env)).foreach((Function1 & Serializable & scala.Serializable)each -> {
            Predef$.MODULE$.println((Object)new StringBuilder(3).append(each).append(":\t").append(spark.conf().get(each, "default value")).append("\t").toString());
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("SPARK_VERSION:").append(spark.version()).append("\t").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("CARBONDATA_VERSION:").append(CarbonVersionConstants.CARBONDATA_VERSION).append("\t").toString());
        Predef$.MODULE$.println((Object)"\nParameters information:");
        Predef$.MODULE$.println((Object)parameters);
        this.prepareTable(spark, table1, table2);
        this.runTest(spark, table1, table2);
        if (this.deleteFile()) {
            CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(table1)});
            boxedUnit = spark.sql(new StringBuilder(11).append("drop table ").append(table2).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        spark.close();
    }

    public static final /* synthetic */ void $anonfun$runQueries$1(String tableName$2, SparkSession spark$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Query query = (Query)tuple2._1();
        int index = tuple2._2$mcI$sp();
        String sqlText = query.sqlText().replace("$table", tableName$2);
        ExecutorService executorService = Executors.newFixedThreadPool(MODULE$.threadNum());
        ArrayList tasks = new ArrayList();
        long tasksStartTime = System.nanoTime();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), MODULE$.taskNum()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)num -> tasks.add(new ConcurrentQueryBenchmark.QueryTask(spark$2, sqlText)));
        List<Future<ConcurrentQueryBenchmark.Results>> results = executorService.invokeAll(tasks);
        executorService.shutdown();
        executorService.awaitTermination(600L, TimeUnit.SECONDS);
        long tasksEndTime = System.nanoTime();
        String sql = new StringBuilder(9).append("Query ").append(index + 1).append(": ").append(sqlText).append(" ").toString();
        MODULE$.printResults(results, sql, tasksStartTime);
        double taskTime = (double)(tasksEndTime - tasksStartTime) / (double)1000000000;
        Predef$.MODULE$.println((Object)new StringBuilder(22).append("Total execute time: ").append(Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)taskTime)), "%.3f")).append(" s").toString());
        String timeString = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        MODULE$.writeResults(spark$2, results, sql, tasksStartTime, new StringBuilder(0).append(MODULE$.path()).append(new StringBuilder(8).append("/").append(tableName$2).append("_query").append(index + 1).append("_").append(timeString).toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$writeResults$2(Tuple3 x) {
        return BoxesRunTime.unboxToDouble((Object)x._1());
    }

    public static final /* synthetic */ ConcurrentQueryBenchmark.Results $anonfun$printResults$1(List results$2, int i) {
        return (ConcurrentQueryBenchmark.Results)((Future)results$2.get(i)).get();
    }

    private ConcurrentQueryBenchmark$() {
        MODULE$ = this;
        this.totalNum = 10000000;
        this.threadNum = 16;
        this.taskNum = 100;
        this.resultIsEmpty = true;
        this.path = "/tmp/carbondata";
        this.runInLocal = true;
        this.generateFile = true;
        this.deleteFile = true;
        this.storeLocation = "/tmp";
        this.cardinalityId = 100000000;
        this.cardinalityCity = 6;
        this.r = new Random();
    }
}

