/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;

public final class DataMergeIntoExample$ {
    public static final DataMergeIntoExample$ MODULE$;

    static {
        new DataMergeIntoExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createSparkSession("DataManagementExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        this.deleteExampleBody(spark);
        this.deleteWithExpressionExample(spark);
        this.updateExampleBody(spark);
        this.updateWithExpressionExample(spark);
        this.updateSpecificColWithExpressionExample(spark);
        this.insertExampleBody(spark);
        this.insertWithExpressionExample(spark);
        this.insertSpecificColWithExpressionExample(spark);
        spark.close();
    }

    public void initTable(SparkSession spark) {
        spark.sql("DROP TABLE IF EXISTS A");
        spark.sql("DROP TABLE IF EXISTS B");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE IF NOT EXISTS A(\n         |   id Int,\n         |   price Int,\n         |   state String\n         | )\n         | STORED AS carbondata\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE IF NOT EXISTS B(\n         |   id Int,\n         |   price Int,\n         |   state String\n         | )\n         | STORED AS carbondata\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO A VALUES (1,100,\"MA\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO A VALUES (2,200,\"NY\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO A VALUES (3,300,\"NH\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO A VALUES (4,400,\"FL\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO B VALUES (1,1,\"MA (updated)\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO B VALUES (2,3,\"NY (updated)\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO B VALUES (3,3,\"CA (updated)\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO B VALUES (5,5,\"TX (updated)\")"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO B VALUES (7,7,\"LO (updated)\")"})).s((Seq)Nil$.MODULE$));
    }

    public void dropTables(SparkSession spark) {
        spark.sql("DROP TABLE IF EXISTS A");
        spark.sql("DROP TABLE IF EXISTS B");
    }

    public void deleteExampleBody(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN MATCHED THEN DELETE";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void deleteWithExpressionExample(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN MATCHED AND B.ID=2 THEN DELETE";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void updateExampleBody(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN MATCHED THEN UPDATE SET *";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void updateWithExpressionExample(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN MATCHED AND A.ID=2 THEN UPDATE SET *";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void updateSpecificColWithExpressionExample(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN MATCHED AND A.ID=2 THEN UPDATE SET STATE=B.STATE";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void updateSpecificMultiColWithExpressionExample(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN MATCHED AND A.ID=2 THEN UPDATE SET A.STATE=B.STATE, A.PRICE=B.PRICE";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void insertExampleBody(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN NOT MATCHED THEN INSERT *";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void insertWithExpressionExample(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN NOT MATCHED AND B.ID=7 THEN INSERT *";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    public void insertSpecificColWithExpressionExample(SparkSession spark) {
        this.dropTables(spark);
        this.initTable(spark);
        String sqlText = "MERGE INTO A USING B ON A.ID=B.ID WHEN NOT MATCHED AND B.ID=7 THEN INSERT (A.ID,A.PRICE, A.state) VALUES (B.ID,B.PRICE, 'test-string')";
        spark.sql(sqlText);
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM A"})).s((Seq)Nil$.MODULE$)).show();
        this.dropTables(spark);
    }

    private DataMergeIntoExample$() {
        MODULE$ = this;
    }
}

