/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.CDCExample;
import org.apache.carbondata.examples.CDCExample$;
import org.apache.carbondata.examples.CDCExample$$anonfun$1$;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class CDCExample$ {
    public static final CDCExample$ MODULE$;
    private final String org$apache$carbondata$examples$CDCExample$$solution;
    private final boolean printDetail;
    private final int org$apache$carbondata$examples$CDCExample$$numInitialRows;
    private final int numInsertPerBatch;
    private final int numUpdatePerBatch;
    private final int numDeletePerBatch;
    private final int numBatch;
    private final Random org$apache$carbondata$examples$CDCExample$$random;
    private final IndexedSeq<String> values;
    private final ArrayList<Object> currentIds;
    private final String org$apache$carbondata$examples$CDCExample$$INSERT;
    private final String org$apache$carbondata$examples$CDCExample$$UPDATE;
    private final String org$apache$carbondata$examples$CDCExample$$DELETE;

    static {
        new CDCExample$();
    }

    public String org$apache$carbondata$examples$CDCExample$$solution() {
        return this.org$apache$carbondata$examples$CDCExample$$solution;
    }

    private boolean printDetail() {
        return this.printDetail;
    }

    public int org$apache$carbondata$examples$CDCExample$$numInitialRows() {
        return this.org$apache$carbondata$examples$CDCExample$$numInitialRows;
    }

    private int numInsertPerBatch() {
        return this.numInsertPerBatch;
    }

    private int numUpdatePerBatch() {
        return this.numUpdatePerBatch;
    }

    private int numDeletePerBatch() {
        return this.numDeletePerBatch;
    }

    private int numBatch() {
        return this.numBatch;
    }

    public Random org$apache$carbondata$examples$CDCExample$$random() {
        return this.org$apache$carbondata$examples$CDCExample$$random;
    }

    private IndexedSeq<String> values() {
        return this.values;
    }

    public String org$apache$carbondata$examples$CDCExample$$pickValue() {
        return (String)this.values().apply(this.org$apache$carbondata$examples$CDCExample$$random().nextInt(this.values().size()));
    }

    private ArrayList<Object> currentIds() {
        return this.currentIds;
    }

    public int org$apache$carbondata$examples$CDCExample$$getId(int index) {
        return BoxesRunTime.unboxToInt((Object)this.currentIds().get(index));
    }

    public int org$apache$carbondata$examples$CDCExample$$getAndRemoveId(int index) {
        return BoxesRunTime.unboxToInt((Object)this.currentIds().remove(index));
    }

    public boolean org$apache$carbondata$examples$CDCExample$$addId(int id) {
        return this.currentIds().add(BoxesRunTime.boxToInteger((int)id));
    }

    private int removeId(int index) {
        return BoxesRunTime.unboxToInt((Object)this.currentIds().remove(index));
    }

    public int org$apache$carbondata$examples$CDCExample$$numOfIds() {
        return this.currentIds().size();
    }

    private int maxId() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.currentIds()).asScala()).max((Ordering)Ordering.Int$.MODULE$));
    }

    public String org$apache$carbondata$examples$CDCExample$$INSERT() {
        return this.org$apache$carbondata$examples$CDCExample$$INSERT;
    }

    public String org$apache$carbondata$examples$CDCExample$$UPDATE() {
        return this.org$apache$carbondata$examples$CDCExample$$UPDATE;
    }

    public String org$apache$carbondata$examples$CDCExample$$DELETE() {
        return this.org$apache$carbondata$examples$CDCExample$$DELETE;
    }

    private Dataset<Row> generateRowsForInsert(SparkSession sparkSession) {
        IndexedSeq insertRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.maxId() + 1), this.maxId() + this.numInsertPerBatch()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CDCExample.Change apply(int x) {
                CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$addId(x);
                return new CDCExample.Change(x, CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$pickValue(), CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$INSERT(), LocalDateTime.now().toString());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_CDCExample$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.CDCExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_CDCExample$$typecreator1$1() {
            }
        }
        return sparkSession.createDataFrame((Seq)insertRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator1$1()));
    }

    private Dataset<Row> generateRowsForDelete(SparkSession sparkSession) {
        IndexedSeq deletedRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numDeletePerBatch()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CDCExample.Change apply(int x) {
                int idIndex = CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$random().nextInt(CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$numOfIds());
                return new CDCExample.Change(CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$getAndRemoveId(idIndex), "", CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$DELETE(), LocalDateTime.now().toString());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_CDCExample$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.CDCExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_CDCExample$$typecreator2$1() {
            }
        }
        return sparkSession.createDataFrame((Seq)deletedRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator2$1()));
    }

    private Dataset<Row> generateRowsForUpdate(SparkSession sparkSession) {
        IndexedSeq updatedRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numUpdatePerBatch()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CDCExample.Change apply(int x) {
                int idIndex = CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$random().nextInt(CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$numOfIds());
                return new CDCExample.Change(CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$getId(idIndex), CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$pickValue(), CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$UPDATE(), LocalDateTime.now().toString());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_CDCExample$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.examples.CDCExample.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_examples_CDCExample$$typecreator3$1() {
            }
        }
        return sparkSession.createDataFrame((Seq)updatedRows, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$typecreator3$1()));
    }

    private void generateTarget(SparkSession sparkSession) {
        Predef$.MODULE$.print((Object)"generating target table...");
        long time = this.org$apache$carbondata$examples$CDCExample$$timeIt((Function0<BoxedUnit>)new Serializable(sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedSeq insertRows = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$numInitialRows()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CDCExample.Target apply(int x) {
                        CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$addId(x);
                        return new CDCExample.Target(x, CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$pickValue(), "origin", LocalDateTime.now().toString());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq duplicatedRow = (IndexedSeq)insertRows.union((GenSeq)insertRows, IndexedSeq$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CDCExample$.MODULE$.getClass().getClassLoader());
                public final class Org_apache_carbondata_examples_CDCExample$$anonfun$1$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.carbondata.examples.CDCExample.Target").asType().toTypeConstructor();
                    }

                    public Org_apache_carbondata_examples_CDCExample$$anonfun$1$$typecreator4$1(anonfun.1 $outer) {
                    }
                }
                Dataset targetData = this.sparkSession$1.createDataFrame((Seq)duplicatedRow, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_CDCExample$$anonfun$1$$typecreator4$1(this)));
                targetData.repartition(8).write().format("carbondata").option("tableName", "target").option("sort_scope", "global_sort").option("sort_column", "id").mode(SaveMode.Overwrite).save();
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done! ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$carbondata$examples$CDCExample$$timeFormatted(time)})));
    }

    public void org$apache$carbondata$examples$CDCExample$$generateChange(SparkSession sparkSession) {
        Dataset<Row> update = this.generateRowsForUpdate(sparkSession);
        Dataset<Row> delete = this.generateRowsForDelete(sparkSession);
        Dataset<Row> insert = this.generateRowsForInsert(sparkSession);
        update.union(delete).union(insert).repartition(8).write().format("carbondata").option("tableName", "change").mode(SaveMode.Overwrite).save();
    }

    private Dataset<Row> readTargetData(SparkSession sparkSession) {
        return sparkSession.read().format("carbondata").option("tableName", "target").load();
    }

    private Dataset<Row> readChangeData(SparkSession sparkSession) {
        return sparkSession.read().format("carbondata").option("tableName", "change").load();
    }

    public long org$apache$carbondata$examples$CDCExample$$timeIt(Function0<BoxedUnit> func) {
        long start = System.nanoTime();
        func.apply$mcV$sp();
        return System.nanoTime() - start;
    }

    public String org$apache$carbondata$examples$CDCExample$$timeFormatted(long updateTime) {
        return new StringBuilder().append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)((double)updateTime / (double)1000 / (double)1000 / (double)1000))), "%.2f")).append((Object)" s").toString();
    }

    public void org$apache$carbondata$examples$CDCExample$$printTarget(SparkSession spark, int i) {
        if (this.printDetail()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target table after CDC batch", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            spark.sql("select * from target order by id").show(false);
        }
    }

    public void org$apache$carbondata$examples$CDCExample$$printChange(SparkSession spark, int i) {
        if (this.printDetail()) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CDC batch", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
            spark.sql("select * from change").show(100, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private SparkSession createSession() {
        void var2_2;
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master("local[8]").enableHiveSupport().config("spark.sql.warehouse.dir", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark/target/warehouse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})))).getOrCreateCarbonSession();
        return var2_2;
    }

    public void main(String[] args) {
        CarbonProperties.setAuditEnabled((boolean)false);
        SparkSession spark = this.createSession();
        spark.sparkContext().setLogLevel("error");
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start CDC example using ", " solution"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$carbondata$examples$CDCExample$$solution()})));
        spark.sql("drop table if exists target");
        spark.sql("drop table if exists change");
        this.generateTarget(spark);
        if (this.printDetail()) {
            Predef$.MODULE$.println((Object)"## target table");
            spark.sql("select * from target").show(100, false);
        }
        LongRef updateTime = LongRef.create((long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numBatch()).foreach$mVc$sp((Function1)new Serializable(spark, updateTime){
            public static final long serialVersionUID = 0L;
            public final SparkSession spark$1;
            private final LongRef updateTime$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$generateChange(this.spark$1);
                CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$printChange(this.spark$1, i);
                long time = CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$timeIt((Function0<BoxedUnit>)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;
                    private final int i$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"applying change batch", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1)})));
                        if (CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$solution().equals("carbon")) {
                            CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$carbonSolution(this.$outer.spark$1);
                        } else {
                            CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$hiveSolution(this.$outer.spark$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
                this.updateTime$1.elem += time;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done! ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$timeFormatted(time)})));
                CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$printTarget(this.spark$1, i);
            }
            {
                this.spark$1 = spark$1;
                this.updateTime$1 = updateTime$1;
            }
        });
        long queryTime = this.org$apache$carbondata$examples$CDCExample$$timeIt((Function0<BoxedUnit>)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql("select * from target").collect();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total update takes ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$carbondata$examples$CDCExample$$timeFormatted(updateTime.elem)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total query takes ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$carbondata$examples$CDCExample$$timeFormatted(queryTime)})));
        spark.close();
    }

    public void org$apache$carbondata$examples$CDCExample$$carbonSolution(SparkSession spark) {
        Dataset latestChangeForEachKey = this.readChangeData(spark).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "struct(mdt, value, change_type) as otherCols"})).groupBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.max("otherCols").as("latest"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "latest.*"}));
        Dataset<Row> target = this.readTargetData(spark);
        CarbonSession$.MODULE$.DataSetMerge(target.as("A")).merge(latestChangeForEachKey.as("B"), "A.id = B.id").whenMatched("B.change_type = 'D'").delete().whenMatched("B.change_type = 'U'").updateExpr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"B.id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"B.value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remark"), (Object)"'updated'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mdt"), (Object)"B.mdt")}))).whenNotMatched("B.change_type = 'I'").insertExpr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)"B.id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)"B.value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remark"), (Object)"'new'"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mdt"), (Object)"B.mdt")}))).execute();
    }

    public Dataset<Row> org$apache$carbondata$examples$CDCExample$$hiveSolution(SparkSession spark) {
        Dataset latestChangeForEachKey = this.readChangeData(spark).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "struct(mdt, value, change_type) as otherCols"})).groupBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.max("otherCols").as("latest"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "latest.*"}));
        latestChangeForEachKey.createOrReplaceTempView("latest_change");
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | insert overwrite table target\n        | select * from\n        | (\n        |   select A.id, B.value, 'updated', B.mdt\n        |     from target A\n        |     right join latest_change B\n        |     on A.id = B.id\n        |     where B.change_type = 'U'\n        |   union all\n        |     select B.id, B.value, 'new', B.mdt\n        |     from latest_change B\n        |     where B.change_type = 'I'\n        |   union all\n        |     select A.id, A.value, A.remark, A.mdt\n        |     from target A\n        |     left join latest_change B\n        |     on A.id = B.id\n        |     where B.id is null\n        | ) T\n      ")).stripMargin());
    }

    private CDCExample$() {
        MODULE$ = this;
        this.org$apache$carbondata$examples$CDCExample$$solution = "carbon";
        this.printDetail = false;
        this.org$apache$carbondata$examples$CDCExample$$numInitialRows = 100000;
        this.numInsertPerBatch = 1000;
        this.numUpdatePerBatch = 9000;
        this.numDeletePerBatch = 1000;
        this.numBatch = 10;
        this.org$apache$carbondata$examples$CDCExample$$random = new Random();
        this.values = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x) {
                return CDCExample$.MODULE$.org$apache$carbondata$examples$CDCExample$$random().nextString(100);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.currentIds = new ArrayList(this.org$apache$carbondata$examples$CDCExample$$numInitialRows() * 2);
        this.org$apache$carbondata$examples$CDCExample$$INSERT = "I";
        this.org$apache$carbondata$examples$CDCExample$$UPDATE = "U";
        this.org$apache$carbondata$examples$CDCExample$$DELETE = "D";
    }
}

