/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class SparkSessionExample$ {
    public static final SparkSessionExample$ MODULE$;
    private final String rootPath;

    static {
        new SparkSessionExample$();
    }

    public String rootPath() {
        return this.rootPath;
    }

    public void main(String[] args) {
        SparkSession sparkSession = ExampleUtils$.MODULE$.createSparkSession("SparkSessionExample", ExampleUtils$.MODULE$.createSparkSession$default$2());
        String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark/src/main/resources/data.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rootPath()}));
        sparkSession.sql("DROP TABLE IF EXISTS csv_table");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE csv_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField STRING,\n         | decimalField DECIMAL(18,2),\n         | dateField STRING,\n         | charField CHAR(5))\n         | ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE csv_table\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).stripMargin());
        sparkSession.sql("SELECT * FROM csv_table").show();
        this.sparkTableExample(sparkSession);
        this.hiveTableExample(sparkSession);
        sparkSession.sql("DROP TABLE IF EXISTS csv_table");
        sparkSession.stop();
    }

    public void sparkTableExample(SparkSession sparkSession) {
        sparkSession.sql("DROP TABLE IF EXISTS sparksession_table");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE sparksession_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5)\n         | )\n         | USING carbondata\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.validateTable(sparkSession, "sparksession_table");
        sparkSession.sql("DROP TABLE IF EXISTS sparksession_table");
    }

    public void hiveTableExample(SparkSession sparkSession) {
        sparkSession.sql("DROP TABLE IF EXISTS sparksession_hive_table");
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE sparksession_hive_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5)\n         | )\n         | STORED AS carbondata\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        this.validateTable(sparkSession, "sparksession_hive_table");
    }

    public void validateTable(SparkSession sparkSession, String tableName) {
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | INSERT INTO TABLE ", "\n         | SELECT shortField, intField, bigintField, doubleField, stringField,\n         | from_unixtime(unix_timestamp(timestampField,'yyyy/MM/dd HH:mm:ss')) timestampField,\n         | decimalField,from_unixtime(unix_timestamp(dateField,'yyyy/MM/dd')), charField\n         | FROM csv_table\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin());
        sparkSession.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM ", "\n         | WHERE stringfield = 'spark' AND decimalField > 40\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT\n         | stringField, date_format(timestampField, \"yyyy/MM/dd HH:mm:ss\") AS\n         | timestampField\n         | FROM ", " WHERE length(stringField) = 5\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM ", " where date_format(dateField, \"yyyy-MM-dd\") = \"2015-07-23\"\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin()).show();
        sparkSession.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT count(stringField) FROM ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName}))).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT sum(intField), stringField\n         | FROM ", "\n         | GROUP BY stringField\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})))).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT t1.*, t2.*\n         | FROM ", " t1, ", " t2\n         | WHERE t1.stringField = t2.stringField\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tableName})))).stripMargin()).show();
        sparkSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | WITH t1 AS (\n         | SELECT * FROM ", "\n         | UNION ALL\n         | SELECT * FROM ", "\n         | )\n         | SELECT t1.*, t2.*\n         | FROM t1, ", " t2\n         | WHERE t1.stringField = t2.stringField\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, tableName, tableName})))).stripMargin()).show();
    }

    private SparkSessionExample$() {
        MODULE$ = this;
        this.rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
    }
}

