/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.util.List;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.log4j.PropertyConfigurator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class GeoTableExampleWithCarbonSession$ {
    public static final GeoTableExampleWithCarbonSession$ MODULE$;

    static {
        new GeoTableExampleWithCarbonSession$();
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        System.setProperty("path.target", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark/target"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})));
        PropertyConfigurator.configure((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark/src/main/resources/log4j.properties"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})));
        CarbonProperties.getInstance().addProperty("enable.query.statistics", "false");
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("GeoTableExampleWithCarbonSession", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        spark.sparkContext().setLogLevel("error");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stored as carbondata", "using carbondata", "stored by 'carbondata'", "stored by 'org.apache.carbondata.format'"}))).foreach((Function1)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply(String formatSyntax) {
                GeoTableExampleWithCarbonSession$.MODULE$.exampleBody(this.spark$1, formatSyntax);
            }
            {
                this.spark$1 = spark$1;
            }
        });
        spark.close();
    }

    public void exampleBody(SparkSession spark, String formatSyntax) {
        Option option;
        block4: {
            String path;
            block3: {
                block2: {
                    String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
                    path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/spark/src/test/resources/geodata.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
                    spark.sql("DROP TABLE IF EXISTS geoTable");
                    spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        CREATE TABLE geoTable(\n         | timevalue BIGINT,\n         | longitude LONG,\n         | latitude LONG)\n         | ", "\n         |  TBLPROPERTIES ('SPATIAL_INDEX'='mygeohash',\n         | 'SPATIAL_INDEX.mygeohash.type'='geohash',\n         | 'SPATIAL_INDEX.mygeohash.sourcecolumns'='longitude, latitude',\n         | 'SPATIAL_INDEX.mygeohash.originLatitude'='39.832277',\n         | 'SPATIAL_INDEX.mygeohash.gridSize'='50',\n         | 'SPATIAL_INDEX.mygeohash.minLongitude'='115.811865',\n         | 'SPATIAL_INDEX.mygeohash.maxLongitude'='116.782233',\n         | 'SPATIAL_INDEX.mygeohash.minLatitude'='39.832277',\n         | 'SPATIAL_INDEX.mygeohash.maxLatitude'='40.225281',\n         | 'SPATIAL_INDEX.mygeohash.conversionRatio'='1000000')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{formatSyntax})))).stripMargin());
                    spark.sql("select *from geoTable").show();
                    Row[] descTable = (Row[])spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"describe formatted geoTable"})).s((Seq)Nil$.MODULE$)).collect();
                    option = Predef$.MODULE$.refArrayOps((Object[])descTable).find((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Row x$1) {
                            return x$1.get(0).toString().contains("mygeohash");
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Row row = (Row)some.x();
                    Predef$.MODULE$.assert(row.get(1).toString().contains("bigint"));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Predef$.MODULE$.assert(false);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA local inpath '", "' INTO TABLE geoTable OPTIONS\n           |('DELIMITER'= ',')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).stripMargin());
            spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE MATERIALIZED VIEW view1 AS SELECT longitude, latitude FROM geoTable"})).s((Seq)Nil$.MODULE$));
            List result = spark.sql("show materialized views on table geoTable").collectAsList();
            Predef$.MODULE$.assert(((Row)result.get(0)).get(1).toString().equalsIgnoreCase("view1"));
            spark.sql("select *from geoTable").show();
            spark.sql("DROP TABLE IF EXISTS geoTable");
            return;
        }
        throw new MatchError((Object)option);
    }

    public String exampleBody$default$2() {
        return "stored as carbondata";
    }

    private GeoTableExampleWithCarbonSession$() {
        MODULE$ = this;
    }
}

