/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples.sdk;

import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.datatype.Field;
import org.apache.carbondata.core.scan.expression.ColumnExpression;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.scan.expression.LiteralExpression;
import org.apache.carbondata.core.scan.expression.conditional.EqualToExpression;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.sdk.file.CarbonReader;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SDKS3Example {
    public static void main(String[] args) throws Exception {
        int i;
        Logger logger = LogServiceFactory.getLogService((String)SDKS3Example.class.getName());
        if (args == null || args.length < 3) {
            logger.error((Object)"Usage: java CarbonS3Example: <access-key> <secret-key><s3-endpoint> [table-path-on-s3] [rows] [Number of writes]");
            System.exit(0);
        }
        String backupProperty = CarbonProperties.getInstance().getProperty("carbon.load.directWriteToStorePath.enabled", "false");
        CarbonProperties.getInstance().addProperty("carbon.load.directWriteToStorePath.enabled", "true");
        String path = "s3a://sdk/WriterOutput";
        if (args.length > 3) {
            path = args[3];
        }
        int rows = 3;
        if (args.length > 4) {
            rows = Integer.parseInt(args[4]);
        }
        int num = 3;
        if (args.length > 5) {
            num = Integer.parseInt(args[5]);
        }
        Configuration conf = new Configuration(true);
        conf.set("fs.s3a.access.key", args[0]);
        conf.set("fs.s3a.secret.key", args[1]);
        conf.set("fs.s3a.endpoint", args[2]);
        Field[] fields = new Field[]{new Field("name", DataTypes.STRING), new Field("age", DataTypes.INT)};
        for (int j = 0; j < num; ++j) {
            CarbonWriter writer = CarbonWriter.builder().outputPath(path).withHadoopConf(conf).withCsvInput(new Schema(fields)).writtenBy("SDKS3Example").build();
            for (i = 0; i < rows; ++i) {
                writer.write((Object)new String[]{"robot" + i % 10, String.valueOf(i)});
            }
            writer.close();
        }
        EqualToExpression equalToExpression = new EqualToExpression((Expression)new ColumnExpression("name", DataTypes.STRING), (Expression)new LiteralExpression((Object)"robot1", DataTypes.STRING));
        CarbonReader reader = CarbonReader.builder((String)path, (String)"_temp").projection(new String[]{"name", "age"}).filter((Expression)equalToExpression).withHadoopConf(conf).build();
        System.out.println("\nData:");
        for (i = 0; i < 20 && reader.hasNext(); ++i) {
            Object[] row = (Object[])reader.readNextRow();
            System.out.println(row[0] + " " + row[1]);
        }
        System.out.println("\nFinished");
        reader.close();
        CarbonReader reader2 = CarbonReader.builder((String)path, (String)"_temp").projection(new String[]{"name", "age"}).withHadoopConf("fs.s3a.access.key", args[0]).withHadoopConf("fs.s3a.secret.key", args[1]).withHadoopConf("fs.s3a.endpoint", args[2]).build();
        System.out.println("\nData:");
        for (i = 0; i < 20 && reader2.hasNext(); ++i) {
            Object[] row = (Object[])reader2.readNextRow();
            System.out.println(row[0] + " " + row[1]);
        }
        System.out.println("\nFinished");
        reader2.close();
        CarbonProperties.getInstance().addProperty("carbon.load.directWriteToStorePath.enabled", backupProperty);
    }
}

