/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.benchmark;

import java.io.File;
import java.sql.Date;
import org.apache.carbondata.benchmark.SCDType2Benchmark;
import org.apache.carbondata.benchmark.SCDType2Benchmark$;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SCDType2Benchmark$ {
    public static final SCDType2Benchmark$ MODULE$;
    private final int numOrders;
    private final int numUpdateOrdersDaily;
    private final int newNewOrdersDaily;
    private final int numDays;
    private final boolean printDetail;

    static {
        new SCDType2Benchmark$();
    }

    public int numOrders() {
        return this.numOrders;
    }

    public int numUpdateOrdersDaily() {
        return this.numUpdateOrdersDaily;
    }

    public int newNewOrdersDaily() {
        return this.newNewOrdersDaily;
    }

    public int numDays() {
        return this.numDays;
    }

    public boolean printDetail() {
        return this.printDetail;
    }

    public Dataset<Row> generateDataForDay0(SparkSession sparkSession, int numOrders, Date startDate) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.benchmark.SCDType2Benchmark.Order").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$1() {
            }
        }
        return sparkSession.implicits().rddToDatasetHolder(sparkSession.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numOrders), 4, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(startDate){
            public static final long serialVersionUID = 0L;
            private final Date startDate$1;

            public final SCDType2Benchmark.Order apply(int x) {
                return new SCDType2Benchmark.Order(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"order", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"customer", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})), this.startDate$1, Date.valueOf("9999-01-01"), 1);
            }
            {
                this.startDate$1 = startDate$1;
            }
        }, ClassTag$.MODULE$.apply(SCDType2Benchmark.Order.class)), sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator5$1()))).toDS().toDF();
    }

    public int generateDataForDay0$default$2() {
        return 1000000;
    }

    public Date generateDataForDay0$default$3() {
        return Date.valueOf("2018-05-01");
    }

    public Dataset<Row> generateDailyChange(SparkSession sparkSession, int numUpdatedOrders, Date startDate, Date updateDate, int newState, int numNewOrders) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.benchmark.SCDType2Benchmark.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator13$1() {
            }
        }
        Dataset ds1 = sparkSession.implicits().rddToDatasetHolder(sparkSession.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numUpdatedOrders), 4, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(updateDate, newState){
            public static final long serialVersionUID = 0L;
            private final Date updateDate$1;
            private final int newState$1;

            public final SCDType2Benchmark.Change apply(int x) {
                return new SCDType2Benchmark.Change(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"order", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"customer", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})), this.updateDate$1, this.newState$1);
            }
            {
                this.updateDate$1 = updateDate$1;
                this.newState$1 = newState$1;
            }
        }, ClassTag$.MODULE$.apply(SCDType2Benchmark.Change.class)), sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator13$1()))).toDS().toDF();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.carbondata.benchmark.SCDType2Benchmark.Change").asType().toTypeConstructor();
            }

            public Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator21$1() {
            }
        }
        Dataset ds2 = sparkSession.implicits().rddToDatasetHolder(sparkSession.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numNewOrders), 4, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(updateDate){
            public static final long serialVersionUID = 0L;
            private final Date updateDate$1;

            public final SCDType2Benchmark.Change apply(int x) {
                return new SCDType2Benchmark.Change(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"newOrder", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"customer", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)x)})), this.updateDate$1, 1);
            }
            {
                this.updateDate$1 = updateDate$1;
            }
        }, ClassTag$.MODULE$.apply(SCDType2Benchmark.Change.class)), sparkSession.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_carbondata_benchmark_SCDType2Benchmark$$typecreator21$1()))).toDS().toDF();
        return ds1.union(ds2);
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master("local[8]").enableHiveSupport().config("spark.sql.warehouse.dir", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark/target/warehouse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})))).getOrCreateCarbonSession();
        spark.sparkContext().setLogLevel("error");
        spark.sql("drop table if exists dw_order_solution1");
        spark.sql("drop table if exists dw_order_solution2");
        spark.sql("drop table if exists change");
        Dataset<Row> baseData = this.generateDataForDay0(spark, this.numOrders(), Date.valueOf("2018-05-01"));
        baseData.write().format("carbondata").option("tableName", "dw_order_solution1").mode(SaveMode.Overwrite).save();
        baseData.write().format("carbondata").option("tableName", "dw_order_solution2").option("sort_columns", "order_id").mode(SaveMode.Overwrite).save();
        ObjectRef startDate = ObjectRef.create((Object)Date.valueOf("2018-05-01"));
        IntRef state = IntRef.create((int)2);
        LongRef solution1UpdateTime = LongRef.create((long)0L);
        LongRef solution2UpdateTime = LongRef.create((long)0L);
        if (this.printDetail()) {
            Predef$.MODULE$.println((Object)"## day0");
            spark.sql("select * from dw_order").show(100, false);
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numDays()).foreach$mVc$sp((Function1)new Serializable(spark, startDate, state, solution1UpdateTime, solution2UpdateTime){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final ObjectRef startDate$2;
            private final IntRef state$1;
            private final LongRef solution1UpdateTime$1;
            private final LongRef solution2UpdateTime$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Date newDate = new Date(DateUtils.addDays((java.util.Date)((Date)this.startDate$2.elem), (int)1).getTime());
                Dataset<Row> changeData = SCDType2Benchmark$.MODULE$.generateDailyChange(this.spark$1, SCDType2Benchmark$.MODULE$.numUpdateOrdersDaily(), (Date)this.startDate$2.elem, newDate, this.state$1.elem, SCDType2Benchmark$.MODULE$.newNewOrdersDaily());
                changeData.write().format("carbondata").option("tableName", "change").mode(SaveMode.Overwrite).save();
                if (SCDType2Benchmark$.MODULE$.printDetail()) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"day", " Change"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    this.spark$1.sql("select * from change").show(100, false);
                }
                this.solution1UpdateTime$1.elem += SCDType2Benchmark$.MODULE$.org$apache$carbondata$benchmark$SCDType2Benchmark$$timeIt$1((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(SparkSession spark) {
                        SCDType2Benchmark$.MODULE$.org$apache$carbondata$benchmark$SCDType2Benchmark$$solution1(spark);
                    }
                }, this.spark$1);
                this.solution2UpdateTime$1.elem += SCDType2Benchmark$.MODULE$.org$apache$carbondata$benchmark$SCDType2Benchmark$$timeIt$1((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(SparkSession spark) {
                        SCDType2Benchmark$.MODULE$.org$apache$carbondata$benchmark$SCDType2Benchmark$$solution2(spark);
                    }
                }, this.spark$1);
                if (SCDType2Benchmark$.MODULE$.printDetail()) {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"day", " result"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                    this.spark$1.sql("select * from dw_order_solution1").show(false);
                    this.spark$1.sql("select * from dw_order_solution2").show(false);
                }
                this.startDate$2.elem = newDate;
                ++this.state$1.elem;
            }
            {
                this.spark$1 = spark$1;
                this.startDate$2 = startDate$2;
                this.state$1 = state$1;
                this.solution1UpdateTime$1 = solution1UpdateTime$1;
                this.solution2UpdateTime$1 = solution2UpdateTime$1;
            }
        });
        long solution1QueryTime = this.org$apache$carbondata$benchmark$SCDType2Benchmark$$timeIt$1((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSession spark) {
                spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | select sum(state) as sum, customer_id\n         | from dw_order_solution1\n         | group by customer_id\n         | order by sum\n         | limit 10\n         |"})).s((Seq)Nil$.MODULE$))).stripMargin()).collect();
            }
        }, spark);
        long solution2QueryTime = this.org$apache$carbondata$benchmark$SCDType2Benchmark$$timeIt$1((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkSession spark) {
                spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | select sum(state) as sum, customer_id\n           | from dw_order_solution2\n           | group by customer_id\n           | order by sum\n           | limit 10\n           |"})).s((Seq)Nil$.MODULE$))).stripMargin()).collect();
            }
        }, spark);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overwrite solution update takes ", " s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(solution1UpdateTime.elem / 1000L / 1000L / 1000L))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update solution update takes ", " s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(solution2UpdateTime.elem / 1000L / 1000L / 1000L))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overwrite solution query takes ", " s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(solution1QueryTime / 1000L / 1000L / 1000L))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"update solution query takes ", " s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(solution2QueryTime / 1000L / 1000L / 1000L))})));
        spark.close();
    }

    public Dataset<Row> org$apache$carbondata$benchmark$SCDType2Benchmark$$solution1(SparkSession spark) {
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | insert overwrite table dw_order_solution1\n        | select * from\n        | (\n        |   select A.order_id, A.customer_id, A.start_date,\n        |     case when A.end_date > B.update_date then B.update_date\n        |     else A.end_date\n        |     end as end_date,\n        |   A.state\n        |   from dw_order_solution1 A\n        |   left join change B\n        |   on A.order_id = B.order_id\n        |   union all\n        |     select B.order_id, B.customer_id, B.update_date, date(\"9999-01-01\"), B.state\n        |     from change B\n        | ) T\n      ")).stripMargin());
    }

    public Dataset<Row> org$apache$carbondata$benchmark$SCDType2Benchmark$$solution2(SparkSession spark) {
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | update dw_order_solution2 A\n        | set (A.end_date) =\n        |   (select B.update_date\n        |   from change B\n        |   where A.order_id = B.order_id and A.end_date > B.update_date)\n      ")).stripMargin()).show();
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | insert into dw_order_solution2\n        | select B.order_id, B.customer_id, B.update_date, date('9999-12-30'), B.state\n        | from change B\n      ")).stripMargin());
    }

    public final long org$apache$carbondata$benchmark$SCDType2Benchmark$$timeIt$1(Function1 func, SparkSession spark$1) {
        long start = System.nanoTime();
        func.apply((Object)spark$1);
        return System.nanoTime() - start;
    }

    private SCDType2Benchmark$() {
        MODULE$ = this;
        this.numOrders = 10000000;
        this.numUpdateOrdersDaily = 10000;
        this.newNewOrdersDaily = 10000;
        this.numDays = 3;
        this.printDetail = false;
    }
}

