/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.StandardPartitionExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class StandardPartitionExample$ {
    public static final StandardPartitionExample$ MODULE$;

    static {
        new StandardPartitionExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("StandardPartitionExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy/MM/dd");
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String testData = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/spark-common-test/src/test/resources/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition_data_example.csv"})).s((Seq)Nil$.MODULE$)).toString();
        spark.sql("DROP TABLE IF EXISTS origintable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE origintable\n        | (id Int,\n        | vin String,\n        | logdate Date,\n        | phonenumber Long,\n        | country String,\n        | area String,\n        | salary Int)\n        | STORED BY 'org.apache.carbondata.format'\n      ")).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       LOAD DATA LOCAL INPATH '", "' into table origintable\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql("select * from origintable").show(false);
        spark.sql("DROP TABLE IF EXISTS partitiontable0");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE partitiontable0\n        | (id Int,\n        | vin String,\n        | phonenumber Long,\n        | country String,\n        | area String,\n        | salary Int)\n        | PARTITIONED BY (logdate Date)\n        | STORED BY 'org.apache.carbondata.format'\n        | TBLPROPERTIES('SORT_COLUMNS'='id,vin')\n      ")).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       LOAD DATA LOCAL INPATH '", "' into table partitiontable0\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT logdate,id,vin,phonenumber,country,area,salary\n         | FROM partitiontable0 where logdate = cast('2016-02-12' as date)\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show(100, false);
        spark.sql("show partitions default.partitiontable0").show();
        spark.sql("insert into table partitiontable0 partition(logdate='2018-02-15') select id,vin,phonenumber,country,area,salary from origintable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT logdate,id,vin,phonenumber,country,area,salary\n         | FROM partitiontable0\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show(100, false);
        spark.sql("UPDATE origintable SET (salary) = (88888)").show();
        spark.sql("insert overwrite table partitiontable0 partition(logdate='2018-02-15') select id,vin,phonenumber,country,area,salary from origintable");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT logdate,id,vin,phonenumber,country,area,salary\n         | FROM partitiontable0\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show(100, false);
        Random r = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_StandardPartitionExample$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_carbondata_examples_StandardPartitionExample$$typecreator3$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 1000000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final Tuple4<String, String, String, Object> apply(int x) {
                return new Tuple4((Object)new StringBuilder().append((Object)"No.").append((Object)BoxesRunTime.boxToInteger((int)this.r$1.nextInt(1000))).toString(), (Object)new StringBuilder().append((Object)"country").append((Object)BoxesRunTime.boxToInteger((int)(x % 8))).toString(), (Object)new StringBuilder().append((Object)"city").append((Object)BoxesRunTime.boxToInteger((int)(x % 50))).toString(), (Object)BoxesRunTime.boxToInteger((int)(x % 300)));
            }
            {
                this.r$1 = r$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_StandardPartitionExample$$typecreator3$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ID", "country", "city", "population"}));
        df.write().format("carbondata").option("tableName", "withoutpartition").option("compress", "true").mode(SaveMode.Overwrite).save();
        spark.sql("DROP TABLE IF EXISTS withpartition");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        | CREATE TABLE withpartition\n        | (ID String,\n        | city String,\n        | population Int)\n        | PARTITIONED BY (country String)\n        | STORED BY 'org.apache.carbondata.format'\n      ")).stripMargin());
        df.write().format("carbondata").option("tableName", "withpartition").option("compress", "true").mode(SaveMode.Overwrite).save();
        double time_without_partition = this.time$1((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | SELECT *\n           | FROM withoutpartition WHERE country='country3'\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).count();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        double time_with_partition = this.time$1((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | SELECT *\n           | FROM withpartition WHERE country='country3'\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).count();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"----time of without partition----:").append((Object)((Object)BoxesRunTime.boxToDouble((double)time_without_partition)).toString()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"----time of with partition----:").append((Object)((Object)BoxesRunTime.boxToDouble((double)time_with_partition)).toString()).toString());
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS partitiontable0");
        spark.sql("DROP TABLE IF EXISTS withoutpartition");
        spark.sql("DROP TABLE IF EXISTS withpartition");
        spark.sql("DROP TABLE IF EXISTS origintable");
    }

    private final double time$1(Function0 code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    private StandardPartitionExample$() {
        MODULE$ = this;
    }
}

