/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class SparkSessionExample$ {
    public static final SparkSessionExample$ MODULE$;

    static {
        new SparkSessionExample$();
    }

    public void main(String[] args) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String storeLocation = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        String warehouse = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/warehouse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        String metaStoreDB = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/metastore_db"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        Serializable clean = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String path) {
                FileUtils.deleteDirectory((File)new File(path));
            }
        };
        clean.apply((Object)storeLocation);
        clean.apply((Object)warehouse);
        clean.apply((Object)metaStoreDB);
        SparkSession sparksession = SparkSession$.MODULE$.builder().master("local").appName("SparkSessionExample").enableHiveSupport().config("spark.sql.warehouse.dir", warehouse).config("javax.jdo.option.ConnectionURL", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:derby:;databaseName=", ";create=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metaStoreDB}))).getOrCreate();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy/MM/dd HH:mm:ss").addProperty("carbon.date.format", "yyyy/MM/dd").addProperty("carbon.storelocation", storeLocation);
        sparksession.sparkContext().setLogLevel("ERROR");
        sparksession.sql("DROP TABLE IF EXISTS sparksession_table");
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE sparksession_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5)\n         | )\n         | USING carbondata\n         | OPTIONS('DICTIONARY_INCLUDE'='dateField, charField',\n         | 'dbName'='default', 'tableName'='sparksession_table')\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/src/main/resources/data.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        sparksession.sql("DROP TABLE IF EXISTS csv_table");
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE csv_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField STRING,\n         | decimalField DECIMAL(18,2),\n         | dateField STRING,\n         | charField CHAR(5))\n         | ROW FORMAT DELIMITED FIELDS TERMINATED BY ','\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE csv_table\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).stripMargin());
        sparksession.sql("SELECT * FROM csv_table").show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | INSERT INTO TABLE sparksession_table\n         | SELECT shortField, intField, bigintField, doubleField, stringField,\n         | from_unixtime(unix_timestamp(timestampField,'yyyy/MM/dd HH:mm:ss')) timestampField,\n         | decimalField,from_unixtime(unix_timestamp(dateField,'yyyy/MM/dd')), charField\n         | FROM csv_table\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        sparksession.sql("SELECT * FROM sparksession_table").show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM sparksession_table\n         | WHERE stringfield = 'spark' AND decimalField > 40\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT\n         | stringField, date_format(timestampField, \"yyyy/MM/dd HH:mm:ss\") AS\n         | timestampField\n         | FROM sparksession_table WHERE length(stringField) = 5\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT *\n         | FROM sparksession_table where date_format(dateField, \"yyyy-MM-dd\") = \"2015-07-23\"\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        sparksession.sql("SELECT count(stringField) FROM sparksession_table").show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT sum(intField), stringField\n         | FROM sparksession_table\n         | GROUP BY stringField\n       "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT t1.*, t2.*\n         | FROM sparksession_table t1, sparksession_table t2\n         | WHERE t1.stringField = t2.stringField\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        sparksession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | WITH t1 AS (\n         | SELECT * FROM sparksession_table\n         | UNION ALL\n         | SELECT * FROM sparksession_table\n         | )\n         | SELECT t1.*, t2.*\n         | FROM t1, sparksession_table t2\n         | WHERE t1.stringField = t2.stringField\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        sparksession.sql("DROP TABLE IF EXISTS sparksession_table");
        sparksession.sql("DROP TABLE IF EXISTS csv_table");
        sparksession.stop();
    }

    private SparkSessionExample$() {
        MODULE$ = this;
    }
}

