/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.sdk.file.CarbonWriter;
import org.apache.carbondata.sdk.file.CarbonWriterBuilder;
import org.apache.carbondata.sdk.file.Field;
import org.apache.carbondata.sdk.file.Schema;
import org.apache.carbondata.spark.util.CarbonSparkUtil$;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class S3UsingSdkExample$ {
    public static final S3UsingSdkExample$ MODULE$;

    static {
        new S3UsingSdkExample$();
    }

    public Object buildTestData(String[] args, String path, int num) {
        String writerPath = path.replace("\\", "/");
        Field[] fields = new Field[]{new Field("name", DataTypes.STRING), new Field("age", DataTypes.INT), new Field("height", DataTypes.DOUBLE)};
        CarbonWriterBuilder builder = CarbonWriter.builder();
        CarbonWriter writer = builder.outputPath(writerPath).uniqueIdentifier(System.currentTimeMillis()).withBlockSize(2).writtenBy("S3UsingSdkExample").withHadoopConf("fs.s3a.access.key", args[0]).withHadoopConf("fs.s3a.secret.key", args[1]).withHadoopConf("fs.s3a.endpoint", CarbonSparkUtil$.MODULE$.getS3EndPoint(args)).withCsvInput(new Schema(fields)).build();
        int row = num;
        for (int i = 0; i < row; ++i) {
            writer.write((Object)new String[]{new StringBuilder().append((Object)"robot").append((Object)BoxesRunTime.boxToInteger((int)i)).toString(), String.valueOf(i), String.valueOf((double)i / (double)2)});
        }
        writer.close();
        return BoxedUnit.UNIT;
    }

    public int buildTestData$default$3() {
        return 3;
    }

    public void main(String[] args) {
        Tuple3 tuple3;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (args.length < 2 || args.length > 6) {
            logger.error("Usage: java CarbonS3Example <access-key> <secret-key>[table-path-on-s3] [s3-endpoint] [number-of-rows] [spark-master]");
            System.exit(0);
        }
        if ((tuple3 = CarbonSparkUtil$.MODULE$.getKeyOnPrefix(args[2])) != null) {
            Tuple3 tuple32;
            String accessKey = (String)tuple3._1();
            String secretKey = (String)tuple3._2();
            String endpoint = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)accessKey, (Object)secretKey, (Object)endpoint);
            String accessKey2 = (String)tuple33._1();
            String secretKey2 = (String)tuple33._2();
            String endpoint2 = (String)tuple33._3();
            SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master(this.getSparkMaster(args)).appName("S3UsingSDKExample").config("spark.driver.host", "localhost").config(accessKey2, args[0]).config(secretKey2, args[1]).config(endpoint2, CarbonSparkUtil$.MODULE$.getS3EndPoint(args))).getOrCreateCarbonSession();
            spark.sparkContext().setLogLevel("WARN");
            String path = args.length < 3 ? "s3a://sdk/WriterOutput2 " : args[2];
            int num = args.length > 4 ? Integer.parseInt(args[4]) : 3;
            this.buildTestData(args, path, num);
            spark.sql("DROP TABLE IF EXISTS s3_sdk_table");
            spark.sql(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE EXTERNAL TABLE s3_sdk_table STORED BY 'carbondata'"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LOCATION '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}))).toString());
            spark.sql("SELECT * FROM s3_sdk_table LIMIT 10").show();
            spark.stop();
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public String getSparkMaster(String[] args) {
        return args.length == 6 ? args[5] : "local";
    }

    private S3UsingSdkExample$() {
        MODULE$ = this;
    }
}

