/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.examples.PreAggregateDataMapExample$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class PreAggregateDataMapExample$ {
    public static final PreAggregateDataMapExample$ MODULE$;

    static {
        new PreAggregateDataMapExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("PreAggregateTableExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String testData = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/spark-common-test/src/test/resources/sample.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        spark.sql("DROP TABLE IF EXISTS mainTable");
        spark.sql("DROP TABLE IF EXISTS mainTable_other");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE mainTable\n                | (id Int,\n                | name String,\n                | city String,\n                | age Int)\n                | STORED BY 'org.apache.carbondata.format'\n              ")).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE mainTable_other\n                | (id Int,\n                | name String,\n                | city String,\n                | age Int)\n                | STORED BY 'org.apache.carbondata.format'\n              ")).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       LOAD DATA LOCAL INPATH '", "' into table mainTable\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       LOAD DATA LOCAL INPATH '", "' into table mainTable_other\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap preagg_sum on table mainTable using 'preaggregate' as\n         | select id,sum(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap preagg_avg on table mainTable using 'preaggregate' as\n         | select id,avg(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap preagg_count_age on table mainTable using 'preaggregate' as\n         | select id,count(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap preagg_min on table mainTable using 'preaggregate' as\n         | select id,min(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap preagg_max on table mainTable using 'preaggregate' as\n         | select id,max(age) from mainTable group by id"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql("show datamap on table mainTable").show(false);
        spark.sql("drop datamap preagg_count_age on table mainTable").show();
        spark.sql("show datamap on table mainTable").show(false);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | create datamap preagg_case on table mainTable using 'preaggregate' as\n         | select name,sum(case when age=35 then id else 0 end) from mainTable group by name\n         | "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create datamap preagg_count on table maintable using 'preaggregate' as\n         | select name, count(*) from maintable group by name"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql("show datamap on table maintable").show(false);
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | SELECT id,max(age)\n         | FROM mainTable group by id\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | select name, count(*) from\n         | mainTable group by name\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | select name as NewName,\n         | sum(case when age=35 then id else 0 end) as sum\n         | from mainTable group by name order by name\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | select t1.name,t1.city from mainTable_other t1 join\n         | (select name as newnewname,sum(age) as sum\n         | from mainTable group by name) t2 on t1.name=t2.newnewname\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        Random r = new Random();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_carbondata_examples_PreAggregateDataMapExample$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("scala.Int").asType().toTypeConstructor()})));
            }

            public Org_apache_carbondata_examples_PreAggregateDataMapExample$$typecreator3$1() {
            }
        }
        Dataset df = spark.implicits().rddToDatasetHolder(spark.sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100000), spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(r){
            public static final long serialVersionUID = 0L;
            private final Random r$1;

            public final Tuple4<String, String, String, Object> apply(int x) {
                return new Tuple4((Object)new StringBuilder().append((Object)"No.").append((Object)BoxesRunTime.boxToInteger((int)this.r$1.nextInt(100000))).toString(), (Object)new StringBuilder().append((Object)"name").append((Object)BoxesRunTime.boxToInteger((int)(x % 8))).toString(), (Object)new StringBuilder().append((Object)"city").append((Object)BoxesRunTime.boxToInteger((int)(x % 50))).toString(), (Object)BoxesRunTime.boxToInteger((int)(x % 60)));
            }
            {
                this.r$1 = r$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_carbondata_examples_PreAggregateDataMapExample$$typecreator3$1()))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ID", "name", "city", "age"}));
        spark.sql("DROP TABLE IF EXISTS personTable");
        spark.sql("DROP TABLE IF EXISTS personTableWithoutAgg");
        df.write().format("carbondata").option("tableName", "personTable").option("compress", "true").mode(SaveMode.Overwrite).save();
        df.write().format("carbondata").option("tableName", "personTableWithoutAgg").option("compress", "true").mode(SaveMode.Overwrite).save();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n       CREATE datamap preagg_avg on table personTable using 'preaggregate' as\n       | select id,avg(age) from personTable group by id\n              ")).stripMargin());
        double time_without_aggTable = this.time$1((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | SELECT id, avg(age)\n           | FROM personTableWithoutAgg group by id\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).count();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        double time_with_aggTable = this.time$1((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | SELECT id, avg(age)\n           | FROM personTable group by id\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).count();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"time for query on table with pre-aggregate table:").append((Object)((Object)BoxesRunTime.boxToDouble((double)time_with_aggTable)).toString()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"time for query on table without pre-aggregate table:").append((Object)((Object)BoxesRunTime.boxToDouble((double)time_without_aggTable)).toString()).toString());
        double time_without_aggTable_sum = this.time$1((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | SELECT id, sum(age)\n           | FROM personTableWithoutAgg group by id\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).count();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        double time_with_aggTable_sum = this.time$1((Function0)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | SELECT id, sum(age)\n           | FROM personTable group by id\n      "})).s((Seq)Nil$.MODULE$))).stripMargin()).count();
            }
            {
                this.spark$1 = spark$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"time for query with function sum on table with pre-aggregate table:").append((Object)((Object)BoxesRunTime.boxToDouble((double)time_with_aggTable_sum)).toString()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"time for query with function sum on table without pre-aggregate table:").append((Object)((Object)BoxesRunTime.boxToDouble((double)time_without_aggTable_sum)).toString()).toString());
        spark.sql("DROP TABLE IF EXISTS mainTable");
        spark.sql("DROP TABLE IF EXISTS mainTable_other");
        spark.sql("DROP TABLE IF EXISTS personTable");
        spark.sql("DROP TABLE IF EXISTS personTableWithoutAgg");
    }

    private final double time$1(Function0 code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    private PreAggregateDataMapExample$() {
        MODULE$ = this;
    }
}

