/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.carbondata.hive.server.HiveEmbeddedServer2;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HiveExample$ {
    public static final HiveExample$ MODULE$;
    private final String driverName;

    static {
        new HiveExample$();
    }

    private String driverName() {
        return this.driverName;
    }

    public void main(String[] args) {
        SparkSession carbonSession = ExampleUtils$.MODULE$.createCarbonSession("HiveExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(carbonSession, new StringBuilder().append((Object)CarbonProperties.getStorePath()).append((Object)"/").append((Object)"default").toString());
        carbonSession.stop();
        System.exit(0);
    }

    public void exampleBody(SparkSession carbonSession, String store) {
        BoxedUnit boxedUnit;
        Logger logger = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString("DROP TABLE IF EXISTS HIVE_CARBON_EXAMPLE")).stripMargin());
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE HIVE_CARBON_EXAMPLE\n         | (ID int,NAME string,SALARY double)\n         | STORED BY 'carbondata'\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        carbonSession.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "/examples/spark2/src/main/resources/sample.csv'\n         | INTO TABLE HIVE_CARBON_EXAMPLE\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})))).stripMargin());
        carbonSession.sql("SELECT * FROM HIVE_CARBON_EXAMPLE").show();
        try {
            boxedUnit = Class.forName(this.driverName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            boxedUnit = BoxedUnit.UNIT;
        }
        HiveEmbeddedServer2 hiveEmbeddedServer2 = new HiveEmbeddedServer2();
        hiveEmbeddedServer2.start();
        int port = hiveEmbeddedServer2.getFreePort();
        Connection connection = DriverManager.getConnection(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:hive2://localhost:", "/default"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})), "", "");
        Statement statement = connection.createStatement();
        logger.info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"============HIVE CLI IS STARTED ON PORT ", " =============="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        statement.execute(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE IF NOT EXISTS HIVE_CARBON_EXAMPLE\n         | (ID int, NAME string,SALARY double)\n         | ROW FORMAT SERDE 'org.apache.carbondata.hive.CarbonHiveSerDe'\n         | WITH SERDEPROPERTIES ('mapreduce.input.carboninputformat.databaseName'='default',\n         | 'mapreduce.input.carboninputformat.tableName'='HIVE_CARBON_EXAMPLE')\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        statement.execute(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | ALTER TABLE HIVE_CARBON_EXAMPLE\n         | SET FILEFORMAT\n         | INPUTFORMAT \\\"org.apache.carbondata.hive.MapredCarbonInputFormat\\\"\n         | OUTPUTFORMAT \\\"org.apache.carbondata.hive.MapredCarbonOutputFormat\\\"\n         | SERDE \\\"org.apache.carbondata.hive.CarbonHiveSerDe\\\"\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        statement.execute(new StringBuilder().append((Object)"ALTER TABLE HIVE_CARBON_EXAMPLE SET LOCATION ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'file:///", "/hive_carbon_example' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{store}))).toString());
        ResultSet resultSet = statement.executeQuery("SELECT * FROM HIVE_CARBON_EXAMPLE");
        int rowsFetched = 0;
        String resultId = "";
        String resultName = "";
        String resultSalary = "";
        while (resultSet.next()) {
            if (rowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| ID|| NAME || SALARY        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultSet.getString("id");
                resultName = resultSet.getString("name");
                resultSalary = resultSet.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultSet.getString("ID");
                resultName = resultSet.getString("NAME");
                resultSalary = resultSet.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++rowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"******Total Number Of Rows Fetched ****** ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rowsFetched)})));
        Predef$.MODULE$.assert(rowsFetched == 2);
        logger.info((Object)"Fetching the Individual Columns ");
        int individualColRowsFetched = 0;
        ResultSet resultIndividualCol = statement.executeQuery("SELECT NAME FROM HIVE_CARBON_EXAMPLE");
        while (resultIndividualCol.next()) {
            if (individualColRowsFetched == 0) {
                Predef$.MODULE$.println((Object)"+--------------+");
                Predef$.MODULE$.println((Object)"| NAME         |");
                Predef$.MODULE$.println((Object)"+---++---------+");
                resultName = resultIndividualCol.getString("name");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "    |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName})));
                Predef$.MODULE$.println((Object)"+---++---------+");
            } else {
                resultName = resultIndividualCol.getString("NAME");
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "      |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName})));
                Predef$.MODULE$.println((Object)"+---++---------+");
            }
            ++individualColRowsFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" ********** Total Rows Fetched When Quering The Individual Columns **********").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)individualColRowsFetched)}))).toString());
        Predef$.MODULE$.assert(individualColRowsFetched == 2);
        logger.info((Object)"Fetching the Out Of Order Columns ");
        ResultSet resultOutOfOrderCol = statement.executeQuery("SELECT SALARY,ID,NAME FROM HIVE_CARBON_EXAMPLE");
        int outOfOrderColFetched = 0;
        while (resultOutOfOrderCol.next()) {
            if (outOfOrderColFetched == 0) {
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                Predef$.MODULE$.println((Object)"| Salary|| ID || NAME        |");
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
                resultId = resultOutOfOrderCol.getString("id");
                resultName = resultOutOfOrderCol.getString("name");
                resultSalary = resultOutOfOrderCol.getString("salary");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "  |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            } else {
                resultId = resultOutOfOrderCol.getString("ID");
                resultName = resultOutOfOrderCol.getString("NAME");
                resultSalary = resultOutOfOrderCol.getString("SALARY");
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultSalary}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", " |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"| ", "   |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultName}))).toString());
                Predef$.MODULE$.println((Object)"+---++-------++--------------+");
            }
            ++outOfOrderColFetched;
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)" ********** Total Rows Fetched When Quering The Out Of Order Columns **********").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)outOfOrderColFetched)}))).toString());
        Predef$.MODULE$.assert(outOfOrderColFetched == 2);
        hiveEmbeddedServer2.stop();
    }

    private HiveExample$() {
        MODULE$ = this;
        this.driverName = "org.apache.hive.jdbc.HiveDriver";
    }
}

