/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class CarbonSortColumnsExample$ {
    public static final CarbonSortColumnsExample$ MODULE$;

    static {
        new CarbonSortColumnsExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("CarbonSessionExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy/MM/dd HH:mm:ss").addProperty("carbon.date.format", "yyyy/MM/dd");
        spark.sql("DROP TABLE IF EXISTS no_sort_columns_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE no_sort_columns_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5),\n         | floatField FLOAT,\n         | complexData ARRAY<STRING>\n         | )\n         | STORED BY 'carbondata'\n         | TBLPROPERTIES('SORT_COLUMNS'='')\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql("DROP TABLE IF EXISTS sort_columns_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE sort_columns_table(\n         | shortField SHORT,\n         | intField INT,\n         | bigintField LONG,\n         | doubleField DOUBLE,\n         | stringField STRING,\n         | timestampField TIMESTAMP,\n         | decimalField DECIMAL(18,2),\n         | dateField DATE,\n         | charField CHAR(5),\n         | floatField FLOAT,\n         | complexData ARRAY<STRING>\n         | )\n         | STORED BY 'carbondata'\n         | TBLPROPERTIES('SORT_COLUMNS'='intField, stringField, charField')\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        String path = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/src/main/resources/data.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE no_sort_columns_table\n         | OPTIONS('COMPLEX_DELIMITER_LEVEL_1'='#')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | LOAD DATA LOCAL INPATH '", "'\n         | INTO TABLE sort_columns_table\n         | OPTIONS('COMPLEX_DELIMITER_LEVEL_1'='#')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM no_sort_columns_table"})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM sort_columns_table"})).s((Seq)Nil$.MODULE$))).stripMargin()).show();
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS no_sort_columns_table");
        spark.sql("DROP TABLE IF EXISTS sort_columns_table");
    }

    private CarbonSortColumnsExample$() {
        MODULE$ = this;
    }
}

