/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import java.io.File;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.carbondata.spark.exception.ProcessMetaDataException;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class CarbonPartitionExample$ {
    public static final CarbonPartitionExample$ MODULE$;

    static {
        new CarbonPartitionExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("CarbonPartitionExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        BoxedUnit boxedUnit;
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String testData = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/integration/spark-common-test/src/test/resources/partition_data.csv"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        CarbonProperties.getInstance().addProperty("carbon.timestamp.format", "yyyy/MM/dd");
        Logger LOGGER = LogServiceFactory.getLogService((String)this.getClass().getCanonicalName());
        spark.sql("DROP TABLE IF EXISTS t0");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE IF NOT EXISTS t0\n                | (\n                | id Int,\n                | vin String,\n                | phonenumber Long,\n                | country String,\n                | area String,\n                | salary Int\n                | )\n                | PARTITIONED BY (logdate Timestamp)\n                | STORED BY 'carbondata'\n                | TBLPROPERTIES('PARTITION_TYPE'='RANGE',\n                | 'RANGE_INFO'='2014/01/01, 2015/01/01, 2016/01/01')\n              ")).stripMargin());
        spark.sql("DROP TABLE IF EXISTS t1");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE IF NOT EXISTS t1\n                | (\n                | id Int,\n                | vin String,\n                | logdate Timestamp,\n                | phonenumber Long,\n                | country String,\n                | area String\n                | )\n                | STORED BY 'carbondata'\n              ")).stripMargin());
        spark.sql("DROP TABLE IF EXISTS t2");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE IF NOT EXISTS t2\n                | (\n                | id Int,\n                | vin String,\n                | logdate Timestamp,\n                | phonenumber Long,\n                | country String,\n                | salary Int\n                | )\n                | PARTITIONED BY (area String)\n                | STORED BY 'carbondata'\n                | TBLPROPERTIES('PARTITION_TYPE'='LIST',\n                | 'LIST_INFO'='Asia, America, Europe', 'DICTIONARY_EXCLUDE' ='area')\n              ")).stripMargin());
        spark.sql("DROP TABLE IF EXISTS t3");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE IF NOT EXISTS t3\n                | (\n                | id Int,\n                | logdate Timestamp,\n                | phonenumber Long,\n                | country String,\n                | area String,\n                | salary Int\n                | )\n                | PARTITIONED BY (vin String)\n                | STORED BY 'carbondata'\n                | TBLPROPERTIES('PARTITION_TYPE'='HASH','NUM_PARTITIONS'='5')\n              ")).stripMargin());
        spark.sql("DROP TABLE IF EXISTS t5");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | CREATE TABLE IF NOT EXISTS t5\n                | (\n                | id Int,\n                | vin String,\n                | logdate Timestamp,\n                | phonenumber Long,\n                | area String,\n                | salary Int\n                |)\n                | PARTITIONED BY (country String)\n                | STORED BY 'carbondata'\n                | TBLPROPERTIES('PARTITION_TYPE'='LIST',\n                | 'LIST_INFO'='(China, US),UK ,Japan,(Canada,Russia, Good, NotGood), Korea ')\n              ")).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       LOAD DATA LOCAL INPATH '", "' into table t0 options('BAD_RECORDS_ACTION'='FORCE')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       LOAD DATA LOCAL INPATH '", "' into table t5 options('BAD_RECORDS_ACTION'='FORCE')\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData})));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Alter table t5 add partition ('OutSpace')"})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         Alter table t5 split partition(4) into ('Canada', 'Russia', '(Good, NotGood)')\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql("select * from t5 where country = 'Good' ").show(100, false);
        spark.sql("select * from t0 order by salary ").show(100, false);
        spark.sql("select * from t5 order by salary ").show(100, false);
        spark.sql("DROP TABLE IF EXISTS t7");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n                | create table t7(id int, name string) partitioned by (city string)\n                | row format delimited fields terminated by ','\n              ")).stripMargin());
        spark.sql("alter table t7 add partition (city = 'Hangzhou')");
        try {
            boxedUnit = spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS partitionDB.t9"})).s((Seq)Nil$.MODULE$));
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            LOGGER.error((Object)noSuchDatabaseException.getMessage());
            boxedUnit = BoxedUnit.UNIT;
        }
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE IF EXISTS partitionDB"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE DATABASE partitionDB"})).s((Seq)Nil$.MODULE$));
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 | CREATE TABLE IF NOT EXISTS partitionDB.t9(\n                 | id Int,\n                 | logdate Timestamp,\n                 | phonenumber Int,\n                 | country String,\n                 | area String\n                 | )\n                 | PARTITIONED BY (vin String)\n                 | STORED BY 'carbondata'\n                 | TBLPROPERTIES('PARTITION_TYPE'='HASH','NUM_PARTITIONS'='5')\n                "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql("SHOW TABLES").show();
        try {
            spark.sql("SHOW PARTITIONS t1").show(100, false);
        }
        catch (ProcessMetaDataException processMetaDataException) {
            LOGGER.error((Object)processMetaDataException.getMessage());
        }
        spark.sql("SHOW PARTITIONS t0").show(100, false);
        spark.sql("SHOW PARTITIONS t3").show(100, false);
        spark.sql("SHOW PARTITIONS t5").show(100, false);
        spark.sql("SHOW PARTITIONS t7").show(100, false);
        spark.sql("SHOW PARTITIONS partitionDB.t9").show(100, false);
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS t0");
        spark.sql("DROP TABLE IF EXISTS t1");
        spark.sql("DROP TABLE IF EXISTS t2");
        spark.sql("DROP TABLE IF EXISTS t3");
        spark.sql("DROP TABLE IF EXISTS t5");
        spark.sql("DROP TABLE IF EXISTS t7");
        spark.sql("DROP TABLE IF EXISTS partitionDB.t9");
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE IF EXISTS partitionDB"})).s((Seq)Nil$.MODULE$));
    }

    private CarbonPartitionExample$() {
        MODULE$ = this;
    }
}

