/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.examples;

import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.examples.util.AllDictionaryUtil$;
import org.apache.carbondata.examples.util.ExampleUtils$;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class AllDictionaryExample$ {
    public static final AllDictionaryExample$ MODULE$;

    static {
        new AllDictionaryExample$();
    }

    public void main(String[] args) {
        SparkSession spark = ExampleUtils$.MODULE$.createCarbonSession("AllDictionaryExample", ExampleUtils$.MODULE$.createCarbonSession$default$2(), ExampleUtils$.MODULE$.createCarbonSession$default$3());
        this.exampleBody(spark);
        spark.close();
    }

    public void exampleBody(SparkSession spark) {
        String testData = new StringBuilder().append((Object)ExampleUtils$.MODULE$.currentPath()).append((Object)"/src/main/resources/dataSample.csv").toString();
        String csvHeader = "ID,date,country,name,phonetype,serialname,salary";
        String dictCol = "|date|country|name|phonetype|serialname|";
        String allDictFile = new StringBuilder().append((Object)ExampleUtils$.MODULE$.currentPath()).append((Object)"/target/data.dictionary").toString();
        AllDictionaryUtil$.MODULE$.extractDictionary(spark.sparkContext(), testData, allDictFile, csvHeader, dictCol);
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy/MM/dd");
        spark.sql("DROP TABLE IF EXISTS dictionary_table");
        spark.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | CREATE TABLE IF NOT EXISTS dictionary_table(\n         | ID Int,\n         | date Date,\n         | country String,\n         | name String,\n         | phonetype String,\n         | serialname String,\n         | salary Int,\n         | floatField float\n         | ) STORED BY 'carbondata'\n       "})).s((Seq)Nil$.MODULE$))).stripMargin());
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           LOAD DATA LOCAL INPATH '", "' into table dictionary_table\n           options('ALL_DICTIONARY_PATH'='", "', 'SINGLE_PASS'='true')\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testData, allDictFile})));
        spark.sql("\n           SELECT * FROM dictionary_table\n           ").show();
        spark.sql("\n           SELECT * FROM dictionary_table where floatField=3.5\n           ").show();
        CarbonProperties.getInstance().addProperty("carbon.date.format", "yyyy-MM-dd");
        spark.sql("DROP TABLE IF EXISTS dictionary_table");
        AllDictionaryUtil$.MODULE$.cleanDictionary(allDictFile);
    }

    private AllDictionaryExample$() {
        MODULE$ = this;
    }
}

