/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.benchmark;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.carbondata.benchmark.Query;
import org.apache.carbondata.benchmark.SimpleQueryBenchmark$;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.spark.util.DataGenerator$;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.sys.package$;

public final class SimpleQueryBenchmark$ {
    public static final SimpleQueryBenchmark$ MODULE$;
    private final Query[] queries;

    static {
        new SimpleQueryBenchmark$();
    }

    public String parquetTableName() {
        return "comparetest_parquet";
    }

    public String orcTableName() {
        return "comparetest_orc";
    }

    public String carbonTableName(String version) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"comparetest_carbonV", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version}));
    }

    public Query[] queries() {
        return this.queries;
    }

    private double loadParquetTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)new Serializable(spark, input, table){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final Dataset input$1;
            private final String table$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset dfWithPartition = this.input$1.withColumn("partitionCol", this.input$1.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)10)));
                dfWithPartition.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionCol"})).mode(SaveMode.Overwrite).parquet(this.table$1);
                this.spark$1.read().parquet(this.table$1).createOrReplaceTempView(this.table$1);
            }
            {
                this.spark$1 = spark$1;
                this.input$1 = input$1;
                this.table$1 = table$1;
            }
        });
    }

    private double loadOrcTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)new Serializable(spark, input, table){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$2;
            private final Dataset input$2;
            private final String table$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.input$2.write().mode(SaveMode.Overwrite).orc(this.table$2);
                this.spark$2.read().orc(this.table$2).createOrReplaceTempView(this.table$2);
            }
            {
                this.spark$2 = spark$2;
                this.input$2 = input$2;
                this.table$2 = table$2;
            }
        });
    }

    private double loadCarbonTable(SparkSession spark, Dataset<Row> input, String tableName) {
        CarbonProperties.getInstance().addProperty("carbon.data.file.version", "V3");
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        return this.time((Function0<BoxedUnit>)new Serializable(input, tableName){
            public static final long serialVersionUID = 0L;
            private final Dataset input$3;
            private final String tableName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.input$3.write().format("carbondata").option("tableName", this.tableName$1).option("single_pass", "true").option("table_blocksize", "32").mode(SaveMode.Overwrite).save();
            }
            {
                this.input$3 = input$3;
                this.tableName$1 = tableName$1;
            }
        });
    }

    private void prepareTable(SparkSession spark, String table1, String table2) {
        block4: {
            double d;
            Dataset df;
            block3: {
                block2: {
                    df = DataGenerator$.MODULE$.generateDataFrame(spark, 100000).cache();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"loading ", " records, schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)df.count()), df.schema()})));
                    if (!table1.endsWith("parquet")) break block2;
                    d = this.loadParquetTable(spark, (Dataset<Row>)df, table1);
                    break block3;
                }
                if (!table1.endsWith("orc")) break block4;
                d = this.loadOrcTable(spark, (Dataset<Row>)df, table1);
            }
            double table1Time = d;
            double table2Time = this.loadCarbonTable(spark, (Dataset<Row>)df, table2);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"load completed, time: ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)table1Time), BoxesRunTime.boxToDouble((double)table2Time)})));
            df.unpersist();
            return;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"invalid table: ").append((Object)table1).toString());
    }

    private Tuple2<Object, Row[]>[] runQueries(SparkSession spark, String tableName) {
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start running queries for ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        ObjectRef result = ObjectRef.create(null);
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.queries()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(spark, tableName, result){
            public static final long serialVersionUID = 0L;
            public final SparkSession spark$3;
            private final String tableName$2;
            public final ObjectRef result$1;

            public final Tuple2<Object, Row[]> apply(Tuple2<Query, Object> x0$1) {
                Tuple2<Query, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Query query = (Query)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String sqlText = query.sqlText().replace("$table", this.tableName$2);
                    Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"running query ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1)), sqlText})));
                    double rt = SimpleQueryBenchmark$.MODULE$.time((Function0<BoxedUnit>)new Serializable(this, sqlText){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.runQueries.1 $outer;
                        private final String sqlText$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.result$1.elem = (Row[])this.$outer.spark$3.sql(this.sqlText$1).collect();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sqlText$1 = sqlText$1;
                        }
                    });
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"=> ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rt)})));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)rt), (Object)((Row[])this.result$1.elem));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.spark$3 = spark$3;
                this.tableName$2 = tableName$2;
                this.result$1 = result$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public void org$apache$carbondata$benchmark$SimpleQueryBenchmark$$printErrorIfNotMatch(int index, String table1, Row[] result1, String table2, Row[] result2) {
        if (result1.length != result2.length) {
            int num = index + 1;
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " result for query ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table1, BoxesRunTime.boxToInteger((int)num)})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])result1).mkString(",")})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " result for query ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2, BoxesRunTime.boxToInteger((int)num)})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])result2).mkString(",")})));
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result not matching for query ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)num), this.queries()[index].desc()})));
        }
    }

    private void runTest(SparkSession spark, String table1, String table2) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        Tuple2<Object, Row[]>[] table1Result = this.runQueries(spark, table1);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        Tuple2<Object, Row[]>[] table2Result = this.runQueries(spark, table2);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])table1Result).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(table1, table2, table2Result){
            public static final long serialVersionUID = 0L;
            private final String table1$1;
            private final String table2$1;
            private final Tuple2[] table2Result$1;

            public final void apply(Tuple2<Tuple2<Object, Row[]>, Object> x0$2) {
                Tuple2<Tuple2<Object, Row[]>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 result = (Tuple2)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    SimpleQueryBenchmark$.MODULE$.org$apache$carbondata$benchmark$SimpleQueryBenchmark$$printErrorIfNotMatch(index, this.table1$1, (Row[])result._2(), this.table2$1, (Row[])this.table2Result$1[index]._2());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.table1$1 = table1$1;
                this.table2$1 = table2$1;
                this.table2Result$1 = table2Result$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.queries()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(table1, table2, formatter, date, table1Result, table2Result){
            public static final long serialVersionUID = 0L;
            private final String table1$1;
            private final String table2$1;
            private final SimpleDateFormat formatter$1;
            private final Date date$1;
            private final Tuple2[] table1Result$1;
            private final Tuple2[] table2Result$1;

            public final void apply(Tuple2<Query, Object> x0$3) {
                Tuple2<Query, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Query query = (Query)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"{").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"query\":\"", "\", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", " time\":", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table1$1, BoxesRunTime.boxToDouble((double)this.table1Result$1[index]._1$mcD$sp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", " time\":", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table2$1, BoxesRunTime.boxToDouble((double)this.table2Result$1[index]._1$mcD$sp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"fetched\":", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Row[])this.table1Result$1[index]._2()).length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"type\":\"", "\", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.queryType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"desc\":\"", "\",  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.desc()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"date\": \"", "\" "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatter$1.format(this.date$1)}))).append((Object)"}").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.table1$1 = table1$1;
                this.table2$1 = table2$1;
                this.formatter$1 = formatter$1;
                this.date$1 = date$1;
                this.table1Result$1 = table1Result$1;
                this.table2Result$1 = table2Result$1;
            }
        });
    }

    public void main(String[] args) {
        CarbonProperties.getInstance().addProperty("carbon.enable.vector.reader", "true").addProperty("enable.unsafe.sort", "true").addProperty("carbon.blockletgroup.size.in.mb", "32").addProperty("enable.unsafe.columnpage", "true");
        String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
        String storeLocation = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath}));
        Option master = Option$.MODULE$.apply((Object)System.getProperty("spark.master")).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.env().get((Object)"MASTER");
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)"local[8]");
            }
        });
        SparkSession spark = CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().master((String)master.get()).enableHiveSupport().config("spark.driver.host", "127.0.0.1")).getOrCreateCarbonSession(storeLocation);
        spark.sparkContext().setLogLevel("warn");
        String table1 = this.parquetTableName();
        String table2 = this.carbonTableName("3");
        this.prepareTable(spark, table1, table2);
        this.runTest(spark, table1, table2);
        CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(table1)});
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2})));
        spark.close();
    }

    public double time(Function0<BoxedUnit> code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    private SimpleQueryBenchmark$() {
        MODULE$ = this;
        this.queries = (Query[])((Object[])new Query[]{new Query("select sum(m1) from $table", "full scan", "full scan query, 1 aggregate"), new Query("select sum(m1), sum(m2) from $table", "full scan", "full scan query, 2 aggregate"), new Query("select sum(m1), sum(m2), sum(m3) from $table", "full scan", "full scan query, 3 aggregate"), new Query("select sum(m1), sum(m2), sum(m3), sum(m4) from $table", "full scan", "full scan query, 4 aggregate"), new Query("select sum(m1), sum(m2), sum(m3), sum(m4), avg(m5) from $table", "full scan", "full scan query, 5 aggregate"), new Query("select count(distinct id) from $table", "full scan", "full scan and count distinct of high card column"), new Query("select count(distinct country) from $table", "full scan", "full scan and count distinct of medium card column"), new Query("select count(distinct city) from $table", "full scan", "full scan and count distinct of low card column"), new Query("select country, sum(m1) as metric from $table group by country order by metric", "aggregate", "group by on big data, on medium card column, medium result set,"), new Query("select city, sum(m1) as metric from $table group by city order by metric", "aggregate", "group by on big data, on low card column, small result set,"), new Query("select id, sum(m1) as metric from $table group by id order by metric desc limit 100", "topN", "top N on high card column"), new Query("select country,sum(m1) as metric from $table group by country order by metric desc limit 10", "topN", "top N on medium card column"), new Query("select city,sum(m1) as metric from $table group by city order by metric desc limit 10", "topN", "top N on low card column"), new Query("select country, sum(m1) as metric from $table where city='city8' group by country order by metric", "filter scan and aggregate", "group by on large data, small result set"), new Query("select id, sum(m1) as metric from $table where planet='planet10' group by id order by metric", "filter scan and aggregate", "group by on medium data, large result set"), new Query("select city, sum(m1) as metric from $table where country='country12' group by city order by metric", "filter scan and aggregate", "group by on medium data, small result set"), new Query("select * from $table where city = 'city3' limit 10000", "filter scan", "filter on low card dimension, limit, medium result set, fetch all columns"), new Query("select * from $table where country = 'country9' ", "filter scan", "filter on low card dimension, medium result set, fetch all columns"), new Query("select * from $table where planet = 'planet101' ", "filter scan", "filter on medium card dimension, small result set, fetch all columns"), new Query("select * from $table where id = '408938' ", "filter scan", "filter on high card dimension"), new Query("select * from $table where country='country10000'  ", "filter scan", "filter on low card dimension, not exist"), new Query("select * from $table where country='country2' and city ='city8' ", "filter scan", "filter on 2 dimensions, small result set, fetch all columns"), new Query("select * from $table where city='city1' and country='country2' and planet ='planet3' ", "filter scan", "filter on 3 dimensions, small result set, fetch all columns"), new Query("select * from $table where m1 < 3", "filter scan", "filter on measure, small result set, fetch all columns"), new Query("select * from $table where id like '1%' ", "fuzzy filter scan", "like filter, big result set"), new Query("select * from $table where id like '%111'", "fuzzy filter scan", "like filter, medium result set"), new Query("select * from $table where id like 'xyz%' ", "fuzzy filter scan", "like filter, full scan but not exist")});
    }
}

