/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.benchmark;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.benchmark.ConcurrentQueryBenchmark;
import org.apache.carbondata.benchmark.ConcurrentQueryBenchmark$;
import org.apache.carbondata.benchmark.Query;
import org.apache.carbondata.core.constants.CarbonVersionConstants;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.spark.util.DataGenerator$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.CarbonSession$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Random;

public final class ConcurrentQueryBenchmark$ {
    public static final ConcurrentQueryBenchmark$ MODULE$;
    private int totalNum;
    private int threadNum;
    private int taskNum;
    private boolean resultIsEmpty;
    private String path;
    private boolean runInLocal;
    private boolean generateFile;
    private boolean deleteFile;
    private String storeLocation;
    private final int cardinalityId;
    private final int cardinalityCity;
    private final Random r;
    private int tmpId;
    private String tmpCity;
    private Query[] queries;
    private volatile byte bitmap$0;

    static {
        new ConcurrentQueryBenchmark$();
    }

    private int tmpId$lzycompute() {
        ConcurrentQueryBenchmark$ concurrentQueryBenchmark$ = this;
        synchronized (concurrentQueryBenchmark$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tmpId = this.r().nextInt(this.cardinalityId()) % this.totalNum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.tmpId;
        }
    }

    private String tmpCity$lzycompute() {
        ConcurrentQueryBenchmark$ concurrentQueryBenchmark$ = this;
        synchronized (concurrentQueryBenchmark$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tmpCity = new StringBuilder().append((Object)"city").append((Object)BoxesRunTime.boxToInteger((int)(this.r().nextInt(this.cardinalityCity()) % this.totalNum()))).toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.tmpCity;
        }
    }

    private Query[] queries$lzycompute() {
        ConcurrentQueryBenchmark$ concurrentQueryBenchmark$ = this;
        synchronized (concurrentQueryBenchmark$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.queries = (Query[])((Object[])new Query[]{new Query(new StringBuilder().append((Object)"select * from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where id = '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tmpId())}))).toString(), "filter scan", "filter on high card dimension"), new Query(new StringBuilder().append((Object)"select id from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where id = '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tmpId())}))).toString(), "filter scan", "filter on high card dimension"), new Query(new StringBuilder().append((Object)"select city from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where id = '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tmpId())}))).toString(), "filter scan", "filter on high card dimension"), new Query(new StringBuilder().append((Object)"select * from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where city = '", "' limit 100"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpCity()}))).toString(), "filter scan", "filter on low card dimension, medium result set, fetch all columns"), new Query(new StringBuilder().append((Object)"select city from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where city = '", "' limit 100"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpCity()}))).toString(), "filter scan", "filter on low card dimension"), new Query(new StringBuilder().append((Object)"select id from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where city = '", "'  limit 100"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tmpCity()}))).toString(), "filter scan", "filter on low card dimension"), new Query("select country, sum(m1) from $table group by country", "aggregate", "group by on big data, on medium card column, medium result set,"), new Query(new StringBuilder().append((Object)"select country, sum(m1) from $table").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where id = '", "' group by country"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tmpId())}))).toString(), "aggregate", "group by on big data, on medium card column, medium result set,"), new Query(new StringBuilder().append((Object)"select t1.country, sum(t1.m1) from $table t1 join $table t2").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" on t1.id = t2.id where t1.id = '", "' group by t1.country"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tmpId())}))).toString(), "aggregate", "group by on big data, on medium card column, medium result set,"), new Query(new StringBuilder().append((Object)"select t2.country, sum(t2.m1) from $table t1 join $table t2 join $table t3 join $table t4 join $table t5 join $table t6 join $table t7 ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"on t1.id=t2.id and t1.id=t3.id and t1.id=t4.id "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and t1.id=t5.id and t1.id=t6.id and "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1.id=t7.id "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" where t2.id = '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.tmpId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" group by t2.country"})).s((Seq)Nil$.MODULE$)).toString(), "aggregate", "group by on big data, on medium card column, medium result set,")});
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.queries;
        }
    }

    public int totalNum() {
        return this.totalNum;
    }

    public void totalNum_$eq(int x$1) {
        this.totalNum = x$1;
    }

    public int threadNum() {
        return this.threadNum;
    }

    public void threadNum_$eq(int x$1) {
        this.threadNum = x$1;
    }

    public int taskNum() {
        return this.taskNum;
    }

    public void taskNum_$eq(int x$1) {
        this.taskNum = x$1;
    }

    public boolean resultIsEmpty() {
        return this.resultIsEmpty;
    }

    public void resultIsEmpty_$eq(boolean x$1) {
        this.resultIsEmpty = x$1;
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    public boolean runInLocal() {
        return this.runInLocal;
    }

    public void runInLocal_$eq(boolean x$1) {
        this.runInLocal = x$1;
    }

    public boolean generateFile() {
        return this.generateFile;
    }

    public void generateFile_$eq(boolean x$1) {
        this.generateFile = x$1;
    }

    public boolean deleteFile() {
        return this.deleteFile;
    }

    public void deleteFile_$eq(boolean x$1) {
        this.deleteFile = x$1;
    }

    public String storeLocation() {
        return this.storeLocation;
    }

    public void storeLocation_$eq(String x$1) {
        this.storeLocation = x$1;
    }

    public int cardinalityId() {
        return this.cardinalityId;
    }

    public int cardinalityCity() {
        return this.cardinalityCity;
    }

    public String parquetTableName() {
        return new StringBuilder().append((Object)"Num").append((Object)BoxesRunTime.boxToInteger((int)this.totalNum())).append((Object)"_").append((Object)"comparetest_parquet").toString();
    }

    public String orcTableName() {
        return new StringBuilder().append((Object)"Num").append((Object)BoxesRunTime.boxToInteger((int)this.totalNum())).append((Object)"_").append((Object)"comparetest_orc").toString();
    }

    public String carbonTableName(String version) {
        return new StringBuilder().append((Object)"Num").append((Object)BoxesRunTime.boxToInteger((int)this.totalNum())).append((Object)"_").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"comparetest_carbonV", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version}))).toString();
    }

    public Random r() {
        return this.r;
    }

    public int tmpId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.tmpId$lzycompute() : this.tmpId;
    }

    public String tmpCity() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tmpCity$lzycompute() : this.tmpCity;
    }

    public Query[] queries() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.queries$lzycompute() : this.queries;
    }

    public double org$apache$carbondata$benchmark$ConcurrentQueryBenchmark$$generateParquetTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)new Serializable(input, table){
            public static final long serialVersionUID = 0L;
            private final Dataset input$1;
            private final String table$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset dfWithPartition = this.input$1.withColumn("partitionCol", this.input$1.col("id").$percent((Object)BoxesRunTime.boxToInteger((int)10)));
                dfWithPartition.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionCol"})).mode(SaveMode.Overwrite).parquet(this.table$1);
            }
            {
                this.input$1 = input$1;
                this.table$1 = table$1;
            }
        });
    }

    public double org$apache$carbondata$benchmark$ConcurrentQueryBenchmark$$generateOrcTable(SparkSession spark, Dataset<Row> input, String table) {
        return this.time((Function0<BoxedUnit>)new Serializable(input, table){
            public static final long serialVersionUID = 0L;
            private final Dataset input$2;
            private final String table$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.input$2.write().mode(SaveMode.Overwrite).orc(this.table$2);
            }
            {
                this.input$2 = input$2;
                this.table$2 = table$2;
            }
        });
    }

    private double generateCarbonTable(SparkSession spark, Dataset<Row> input, String tableName) {
        CarbonProperties.getInstance().addProperty("carbon.data.file.version", "3");
        spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table if exists ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        return this.time((Function0<BoxedUnit>)new Serializable(input, tableName){
            public static final long serialVersionUID = 0L;
            private final Dataset input$3;
            private final String tableName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.input$3.write().format("carbondata").option("tableName", this.tableName$1).option("tempCSV", "false").option("single_pass", "true").option("dictionary_exclude", "id").option("table_blocksize", "32").mode(SaveMode.Overwrite).save();
            }
            {
                this.input$3 = input$3;
                this.tableName$1 = tableName$1;
            }
        });
    }

    public void prepareTable(SparkSession spark, String table1, String table2) {
        Dataset df = this.generateFile() ? DataGenerator$.MODULE$.generateDataFrame(spark, this.totalNum()).cache() : null;
        double table1Time = this.time((Function0<BoxedUnit>)new Serializable(spark, table1, df){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final String table1$1;
            private final Dataset df$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                block6: {
                    block5: {
                        block4: {
                            if (!this.table1$1.endsWith("parquet")) break block4;
                            Object object = ConcurrentQueryBenchmark$.MODULE$.generateFile() ? BoxesRunTime.boxToDouble((double)ConcurrentQueryBenchmark$.MODULE$.org$apache$carbondata$benchmark$ConcurrentQueryBenchmark$$generateParquetTable(this.spark$1, (Dataset<Row>)this.df$1, new StringBuilder().append((Object)ConcurrentQueryBenchmark$.MODULE$.storeLocation()).append((Object)"/").append((Object)this.table1$1).toString())) : BoxedUnit.UNIT;
                            this.spark$1.read().parquet(new StringBuilder().append((Object)ConcurrentQueryBenchmark$.MODULE$.storeLocation()).append((Object)"/").append((Object)this.table1$1).toString()).createOrReplaceTempView(this.table1$1);
                            break block5;
                        }
                        if (!this.table1$1.endsWith("orc")) break block6;
                        if (ConcurrentQueryBenchmark$.MODULE$.generateFile()) {
                            ConcurrentQueryBenchmark$.MODULE$.org$apache$carbondata$benchmark$ConcurrentQueryBenchmark$$generateOrcTable(this.spark$1, (Dataset<Row>)this.df$1, this.table1$1);
                            this.spark$1.read().orc(this.table1$1).createOrReplaceTempView(this.table1$1);
                        }
                    }
                    return;
                }
                throw package$.MODULE$.error(new StringBuilder().append((Object)"invalid table: ").append((Object)this.table1$1).toString());
            }
            {
                this.spark$1 = spark$1;
                this.table1$1 = table1$1;
                this.df$1 = df$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " completed, time: ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table1, BoxesRunTime.boxToDouble((double)table1Time)})));
        double table2Time = this.generateFile() ? this.generateCarbonTable(spark, (Dataset<Row>)df, table2) : 0.0;
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " completed, time: ", " sec"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2, BoxesRunTime.boxToDouble((double)table2Time)})));
        if (df != null) {
            df.unpersist();
        }
    }

    private void runQueries(SparkSession spark, String tableName) {
        Predef$.MODULE$.println();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start running queries for ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})));
        Predef$.MODULE$.println((Object)"Min: min time\tMax: max time\t90%: 90% time\t99%: 99% time\tAvg: average time\tCount: number of result\tQuery X: running different query sql\tResult: show it when ResultIsEmpty is false\tTotal execute time: total runtime");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.queries()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(spark, tableName){
            public static final long serialVersionUID = 0L;
            public final SparkSession spark$2;
            private final String tableName$2;

            public final void apply(Tuple2<Query, Object> x0$1) {
                Tuple2<Query, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Query query = (Query)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String sqlText = query.sqlText().replace("$table", this.tableName$2);
                    ExecutorService executorService = Executors.newFixedThreadPool(ConcurrentQueryBenchmark$.MODULE$.threadNum());
                    ArrayList<E> tasks = new ArrayList<E>();
                    long tasksStartTime = System.nanoTime();
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), ConcurrentQueryBenchmark$.MODULE$.taskNum()).foreach((Function1)new Serializable(this, sqlText, tasks){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.runQueries.1 $outer;
                        private final String sqlText$1;
                        private final ArrayList tasks$1;

                        public final boolean apply(int num) {
                            return this.apply$mcZI$sp(num);
                        }

                        public boolean apply$mcZI$sp(int num) {
                            return this.tasks$1.add(new ConcurrentQueryBenchmark.QueryTask(this.$outer.spark$2, this.sqlText$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.sqlText$1 = sqlText$1;
                            this.tasks$1 = tasks$1;
                        }
                    });
                    List<Future<ConcurrentQueryBenchmark.Results>> results = executorService.invokeAll(tasks);
                    executorService.shutdown();
                    executorService.awaitTermination(600L, TimeUnit.SECONDS);
                    long tasksEndTime = System.nanoTime();
                    String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(index + 1)), sqlText}));
                    ConcurrentQueryBenchmark$.MODULE$.printResults(results, sql, tasksStartTime);
                    double taskTime = (double)(tasksEndTime - tasksStartTime) / (double)1000000000;
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Total execute time: ").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)taskTime)), "%.3f")).append((Object)" s").toString());
                    String timeString = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
                    ConcurrentQueryBenchmark$.MODULE$.writeResults(this.spark$2, results, sql, tasksStartTime, new StringBuilder().append((Object)ConcurrentQueryBenchmark$.MODULE$.path()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "_query", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$2, BoxesRunTime.boxToInteger((int)(index + 1)), timeString}))).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.spark$2 = spark$2;
                this.tableName$2 = tableName$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
    }

    public void writeResults(SparkSession spark, List<Future<ConcurrentQueryBenchmark.Results>> results, String sql, long start, String filePath) {
        Tuple3[] timeArray = new Tuple3[results.size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), results.size()).foreach$mVc$sp((Function1)new Serializable(results, start, timeArray){
            public static final long serialVersionUID = 0L;
            private final List results$2;
            private final long start$1;
            private final Tuple3[] timeArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.timeArray$1[i] = new Tuple3((Object)BoxesRunTime.boxToDouble((double)((double)(((ConcurrentQueryBenchmark.Results)((Future)this.results$2.get(i)).get()).startTime() - this.start$1) / 1000000.0)), (Object)BoxesRunTime.boxToDouble((double)((double)(((ConcurrentQueryBenchmark.Results)((Future)this.results$2.get(i)).get()).endTime() - this.start$1) / 1000000.0)), (Object)BoxesRunTime.boxToDouble((double)((double)(((ConcurrentQueryBenchmark.Results)((Future)this.results$2.get(i)).get()).endTime() - ((ConcurrentQueryBenchmark.Results)((Future)this.results$2.get(i)).get()).startTime()) / 1000000.0)));
            }
            {
                this.results$2 = results$2;
                this.start$1 = start$1;
                this.timeArray$1 = timeArray$1;
            }
        });
        Tuple3[] timeArraySorted = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])timeArray).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x) {
                return BoxesRunTime.unboxToDouble((Object)x._1());
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        String[] timeArrayString = (String[])Predef$.MODULE$.refArrayOps((Object[])timeArraySorted).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<Object, Object, Object> e) {
                return new StringBuilder().append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(e._1()), "%.3f")).append((Object)",\t").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(e._2()), "%.3f")).append((Object)",\t").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(e._3()), "%.3f")).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] saveArray = (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{sql, "startTime, endTime, runtime, measure time by the microsecond", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)timeArrayString.length)}))}).union((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])timeArrayString), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        RDD rdd = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])saveArray), 1, ClassTag$.MODULE$.apply(String.class));
        rdd.saveAsTextFile(filePath);
    }

    public String writeResults$default$3() {
        return "";
    }

    public void printResults(List<Future<ConcurrentQueryBenchmark.Results>> results, String sql, long tasksStartTime) {
        double[] timeArray = new double[results.size()];
        Row[] sqlResult = results.get(0).get().sqlResult();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), results.size()).foreach((Function1)new Serializable(results){
            public static final long serialVersionUID = 0L;
            private final List results$1;

            public final ConcurrentQueryBenchmark.Results apply(int i) {
                return (ConcurrentQueryBenchmark.Results)((Future)this.results$1.get(i)).get();
            }
            {
                this.results$1 = results$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), results.size()).foreach$mVc$sp((Function1)new Serializable(results, timeArray){
            public static final long serialVersionUID = 0L;
            private final List results$1;
            private final double[] timeArray$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.timeArray$2[i] = ((ConcurrentQueryBenchmark.Results)((Future)this.results$1.get(i)).get()).time();
            }
            {
                this.results$1 = results$1;
                this.timeArray$2 = timeArray$2;
            }
        });
        double[] sortTimeArray = (double[])Predef$.MODULE$.doubleArrayOps(timeArray).sorted((Ordering)Ordering.Double$.MODULE$);
        int time90 = (int)((double)sortTimeArray.length * 0.9) - 1;
        int time99 = (int)((double)sortTimeArray.length * 0.99) - 1;
        Predef$.MODULE$.print((Object)new StringBuilder().append((Object)"Min: ").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(Predef$.MODULE$.doubleArrayOps(sortTimeArray).head()), "%.3f")).append((Object)" s,").append((Object)"\tMax: ").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(Predef$.MODULE$.doubleArrayOps(sortTimeArray).last()), "%.3f")).append((Object)" s,").append((Object)"\t90%: ").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)sortTimeArray[time90])), "%.3f")).append((Object)" s,").append((Object)"\t99%: ").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)sortTimeArray[time99])), "%.3f")).append((Object)" s,").append((Object)"\tAvg: ").append((Object)Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(timeArray).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)timeArray.length))), "%.3f")).append((Object)" s,").append((Object)"\t\tCount: ").append((Object)BoxesRunTime.boxToInteger((int)results.get(0).get().count())).append((Object)"\t\t\t\t").append((Object)sql).append((Object)"\t").append((Object)Predef$.MODULE$.refArrayOps((Object[])sqlResult).mkString(",")).append((Object)"\t").toString());
    }

    public String printResults$default$2() {
        return "";
    }

    public void runTest(SparkSession spark, String table1, String table2) {
        this.runQueries(spark, table1);
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
        this.runQueries(spark, table2);
    }

    public double time(Function0<BoxedUnit> code) {
        long start = System.currentTimeMillis();
        code.apply$mcV$sp();
        return (double)(System.currentTimeMillis() - start) / (double)1000;
    }

    public void initParameters(String[] arr) {
        if (arr.length > 0) {
            this.totalNum_$eq(new StringOps(Predef$.MODULE$.augmentString(arr[0])).toInt());
        }
        if (arr.length > 1) {
            this.threadNum_$eq(new StringOps(Predef$.MODULE$.augmentString(arr[1])).toInt());
        }
        if (arr.length > 2) {
            this.taskNum_$eq(new StringOps(Predef$.MODULE$.augmentString(arr[2])).toInt());
        }
        if (arr.length > 3) {
            boolean bl;
            if (arr[3].equalsIgnoreCase("true")) {
                bl = true;
            } else {
                if (!arr[3].equalsIgnoreCase("false")) {
                    throw new Exception("error parameter, should be true or false");
                }
                bl = false;
            }
            this.resultIsEmpty_$eq(bl);
        }
        if (arr.length > 4) {
            this.path_$eq(arr[4]);
        }
        if (arr.length > 5) {
            boolean bl;
            if (arr[5].equalsIgnoreCase("true")) {
                String rootPath = new File(new StringBuilder().append((Object)this.getClass().getResource("/").getPath()).append((Object)"../../../..").toString()).getCanonicalPath();
                this.storeLocation_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/examples/spark2/target/store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootPath})));
                bl = true;
            } else {
                if (!arr[5].equalsIgnoreCase("false")) {
                    throw new Exception("error parameter, should be true or false");
                }
                bl = false;
            }
            this.runInLocal_$eq(bl);
        }
        if (arr.length > 6) {
            boolean bl;
            if (arr[6].equalsIgnoreCase("true")) {
                bl = true;
            } else {
                if (!arr[6].equalsIgnoreCase("false")) {
                    throw new Exception("error parameter, should be true or false");
                }
                bl = false;
            }
            this.generateFile_$eq(bl);
        }
        if (arr.length > 7) {
            boolean bl;
            if (arr[7].equalsIgnoreCase("true")) {
                bl = true;
            } else {
                if (!arr[7].equalsIgnoreCase("false")) {
                    throw new Exception("error parameter, should be true or false");
                }
                bl = false;
            }
            this.deleteFile_$eq(bl);
        }
        if (arr.length > 8) {
            this.storeLocation_$eq(arr[8]);
        }
    }

    public void main(String[] args) {
        BoxedUnit boxedUnit;
        CarbonProperties.getInstance().addProperty("carbon.enable.vector.reader", "true").addProperty("enable.unsafe.sort", "true").addProperty("carbon.blockletgroup.size.in.mb", "32").addProperty("enable.unsafe.columnpage", "false").addProperty("enable.unsafe.in.query.processing", "false");
        this.initParameters(args);
        String table1 = this.parquetTableName();
        String table2 = this.carbonTableName("3");
        String parameters = new StringBuilder().append((Object)"totalNum: ").append((Object)BoxesRunTime.boxToInteger((int)this.totalNum())).append((Object)"\tthreadNum: ").append((Object)BoxesRunTime.boxToInteger((int)this.threadNum())).append((Object)"\ttaskNum: ").append((Object)BoxesRunTime.boxToInteger((int)this.taskNum())).append((Object)"\tresultIsEmpty: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.resultIsEmpty())).append((Object)"\tfile path: ").append((Object)this.path()).append((Object)"\trunInLocal: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.runInLocal())).append((Object)"\tgenerateFile: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.generateFile())).append((Object)"\tdeleteFile: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.deleteFile())).append((Object)"\tstoreLocation: ").append((Object)this.storeLocation()).toString();
        SparkSession spark = this.runInLocal() ? CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().appName(parameters).master("local[8]").enableHiveSupport()).getOrCreateCarbonSession(this.storeLocation()) : CarbonSession$.MODULE$.CarbonBuilder(SparkSession$.MODULE$.builder().appName(parameters).enableHiveSupport()).getOrCreateCarbonSession(this.storeLocation());
        spark.sparkContext().setLogLevel("ERROR");
        Predef$.MODULE$.println((Object)"\nEnvironment information:");
        String[] env = (String[])((Object[])new String[]{"spark.master", "spark.driver.cores", "spark.driver.memory", "spark.executor.cores", "spark.executor.memory", "spark.executor.instances"});
        Predef$.MODULE$.refArrayOps((Object[])env).foreach((Function1)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$3;

            public final void apply(String each) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)each).append((Object)":\t").append((Object)this.spark$3.conf().get(each, "default value")).append((Object)"\t").toString());
            }
            {
                this.spark$3 = spark$3;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"SPARK_VERSION:").append((Object)spark.version()).append((Object)"\t").toString());
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"CARBONDATA_VERSION:").append((Object)CarbonVersionConstants.CARBONDATA_VERSION).append((Object)"\t").toString());
        Predef$.MODULE$.println((Object)"\nParameters information:");
        Predef$.MODULE$.println((Object)parameters);
        this.prepareTable(spark, table1, table2);
        this.runTest(spark, table1, table2);
        if (this.deleteFile()) {
            CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(table1)});
            boxedUnit = spark.sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2})));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        spark.close();
    }

    private ConcurrentQueryBenchmark$() {
        MODULE$ = this;
        this.totalNum = 10000000;
        this.threadNum = 16;
        this.taskNum = 100;
        this.resultIsEmpty = true;
        this.path = "/tmp/carbondata";
        this.runInLocal = true;
        this.generateFile = true;
        this.deleteFile = true;
        this.storeLocation = "/tmp";
        this.cardinalityId = 100000000;
        this.cardinalityCity = 6;
        this.r = new Random();
    }
}

