/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.springdoc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.common.Server;
import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.v3.models.Oas30Document;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.camel.CamelContext;
import org.apache.camel.openapi.BeanConfig;
import org.apache.camel.openapi.DefaultRestDefinitionsResolver;
import org.apache.camel.openapi.OpenApiHelper;
import org.apache.camel.openapi.RestDefinitionsResolver;
import org.apache.camel.openapi.RestOpenApiReader;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.springboot.springdoc.SpringdocConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SpringdocConfiguration.class})
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@ConditionalOnProperty(name={"camel.springdoc.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@AutoConfigureBefore(name={"org.springdoc.core.SpringdocConfiguration"})
public class SpringdocAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SpringdocAutoConfiguration.class);
    private final RestOpenApiReader reader = new RestOpenApiReader();
    private final RestDefinitionsResolver resolver = new DefaultRestDefinitionsResolver();
    private final OpenAPI openapi = new OpenAPI();
    @Value(value="${server.servlet.context-path:}")
    private String springContextPath;
    private static final BiConsumer<Object, Consumer<String>> consumeProperty = (a, b) -> Optional.ofNullable(a).map(String.class::cast).ifPresent((Consumer<String>)b);

    @Bean
    CamelContextConfiguration springdocOnBeforeStart(GenericApplicationContext ac, CamelContext camelContext, SpringdocConfiguration config) {
        return new CamelContextConfiguration(){

            public void beforeApplicationStart(CamelContext camelContext) {
                try {
                    Optional.ofNullable(SpringdocAutoConfiguration.this.createOpenAPI(camelContext)).ifPresent(created -> {
                        LOG.info("OpenAPI ({}) created from Camel Rest-DSL v{} - {}", new Object[]{created.getOpenapi(), created.getInfo().getVersion(), created.getInfo().getTitle()});
                        Optional.ofNullable(created.getInfo()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setInfo(arg_0));
                        Optional.ofNullable(created.getOpenapi()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setOpenapi(arg_0));
                        Optional.ofNullable(created.getComponents()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setComponents(arg_0));
                        Optional.ofNullable(created.getExtensions()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setExtensions(arg_0));
                        Optional.ofNullable(created.getSecurity()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setSecurity(arg_0));
                        Optional.ofNullable(created.getExternalDocs()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setExternalDocs(arg_0));
                        Optional.ofNullable(created.getPaths()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setPaths(arg_0));
                        Optional.ofNullable(created.getTags()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setTags(arg_0));
                        Optional.ofNullable(created.getServers()).ifPresent(arg_0 -> ((OpenAPI)SpringdocAutoConfiguration.this.openapi).setServers(arg_0));
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error generating OpenAPI from Camel Rest DSL due to: {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
                }
            }

            public void afterApplicationStart(CamelContext camelContext) {
            }
        };
    }

    @Bean
    OpenAPI camelRestDSLOpenApi() {
        return this.openapi;
    }

    private OpenAPI createOpenAPI(CamelContext camelContext) throws Exception {
        List rests = this.resolver.getRestDefinitions(camelContext, null);
        if (rests == null || rests.isEmpty()) {
            return null;
        }
        BeanConfig bc = new BeanConfig();
        Info info = new Info();
        RestConfiguration rc = camelContext.getRestConfiguration();
        Map apiProps = Optional.ofNullable(rc.getApiProperties()).orElseGet(HashMap::new);
        SpringdocAutoConfiguration.initOpenApi(bc, info, apiProps, this.getBasePath(this.springContextPath, apiProps.get("base.path"), rc.getContextPath()));
        OasDocument openApi = this.reader.read(camelContext, rests, bc, null, camelContext.getClassResolver());
        if (!rc.isApiVendorExtension()) {
            OpenApiHelper.clearVendorExtensions((OasDocument)openApi);
        }
        if (bc.getBasePath() != null && !bc.getBasePath().isEmpty() && openApi.is3xDocument()) {
            for (Server server : ((Oas30Document)openApi).getServers()) {
                if (!server.url.endsWith(bc.getBasePath())) continue;
                LOG.info("Setting Server URL in ApiDoc to base path: {}", (Object)bc.getBasePath());
                server.url = bc.getBasePath();
            }
        }
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Object dump = Library.writeNode((Node)openApi);
        byte[] jsonData = mapper.writeValueAsBytes(dump);
        JsonNode node = mapper.readTree(jsonData);
        String yaml = new YAMLMapper().writeValueAsString((Object)node);
        return Optional.ofNullable(new OpenAPIV3Parser().readContents(yaml)).map(SwaggerParseResult::getOpenAPI).map(a -> a.info(info)).orElse(null);
    }

    private String getBasePath(String springContextPath, Object basePath, String contextPath) {
        if (contextPath == null) {
            contextPath = (String)basePath;
        }
        if (contextPath != null && !contextPath.isEmpty()) {
            return springContextPath + contextPath;
        }
        LOG.warn("No REST context path set in Camel Rest-DSL!");
        return springContextPath;
    }

    private static void initOpenApi(BeanConfig bc, Info info, Map<String, Object> config, String basePath) {
        consumeProperty.accept(config.get("openapi.version"), arg_0 -> ((BeanConfig)bc).setVersion(arg_0));
        consumeProperty.accept(basePath, arg_0 -> ((BeanConfig)bc).setBasePath(arg_0));
        consumeProperty.accept(config.get("host"), arg_0 -> ((BeanConfig)bc).setHost(arg_0));
        consumeProperty.accept(config.get("api.version"), arg_0 -> ((Info)info).setVersion(arg_0));
        consumeProperty.accept(config.get("api.description"), arg_0 -> ((Info)info).setDescription(arg_0));
        consumeProperty.accept(config.get("api.termsOfService"), arg_0 -> ((Info)info).setTermsOfService(arg_0));
        consumeProperty.accept(config.get("api.license.name"), arg_0 -> ((BeanConfig)bc).setLicense(arg_0));
        consumeProperty.accept(config.get("api.license.url"), arg_0 -> ((BeanConfig)bc).setLicenseUrl(arg_0));
        consumeProperty.accept(config.get("api.title"), s -> {
            bc.setTitle(s);
            info.setTitle(s);
        });
        Optional.of(config.getOrDefault("schemes", config.getOrDefault("schemas", "http"))).map(String.class::cast).map(v -> v.split(",")).ifPresent(arg_0 -> ((BeanConfig)bc).setSchemes(arg_0));
        Optional.ofNullable(config.get("api.contact.name")).map(String.class::cast).map(name -> new Contact().name(name).email((String)config.get("api.contact.email")).url((String)config.get("api.contact.url"))).ifPresent(arg_0 -> ((Info)info).setContact(arg_0));
    }
}

