/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.aot;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class ReflectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionHelper.class);

    private ReflectionHelper() {
    }

    public static <A extends Annotation, T> void applyIfMatch(Class<?> c, Class<A> a, Function<A, T> getter, Consumer<T> onMatch) {
        boolean checkMethods;
        boolean checkParameters;
        Set<ElementType> targets = null;
        if (a.isAnnotationPresent(Target.class)) {
            targets = Collections.newSetFromMap(new EnumMap(ElementType.class));
            targets.addAll(Arrays.asList(a.getAnnotation(Target.class).value()));
        }
        if ((targets == null || targets.contains((Object)ElementType.TYPE)) && c.isAnnotationPresent(a)) {
            onMatch.accept(getter.apply(c.getAnnotation(a)));
        }
        boolean checkConstructors = targets == null || targets.contains((Object)ElementType.CONSTRUCTOR);
        boolean bl = checkParameters = targets == null || targets.contains((Object)ElementType.PARAMETER);
        if (checkConstructors || checkParameters) {
            for (Constructor<?> constructor : c.getDeclaredConstructors()) {
                if (checkConstructors && constructor.isAnnotationPresent(a)) {
                    onMatch.accept(getter.apply(constructor.getAnnotation(a)));
                }
                if (!checkParameters) continue;
                for (Parameter parameter : constructor.getParameters()) {
                    if (!parameter.isAnnotationPresent(a)) continue;
                    onMatch.accept(getter.apply(parameter.getAnnotation(a)));
                }
            }
        }
        if (targets == null || targets.contains((Object)ElementType.FIELD)) {
            ReflectionUtils.doWithFields(c, field -> onMatch.accept(getter.apply(field.getAnnotation(a))), field -> field.isAnnotationPresent(a));
        }
        boolean bl2 = checkMethods = targets == null || targets.contains((Object)ElementType.METHOD);
        if (checkMethods || checkParameters) {
            ReflectionUtils.doWithMethods(c, method -> {
                if (checkMethods && method.isAnnotationPresent(a)) {
                    onMatch.accept(getter.apply(method.getAnnotation(a)));
                }
                if (checkParameters) {
                    for (Parameter parameter : method.getParameters()) {
                        if (!parameter.isAnnotationPresent(a)) continue;
                        onMatch.accept(getter.apply(parameter.getAnnotation(a)));
                    }
                }
            });
        }
    }

    public static List<Class<?>> getClassesByAnnotations(ClassLoader classLoader, List<Class<? extends Annotation>> annotations) {
        return ReflectionHelper.getClassesByFilters(classLoader, annotations.stream().map(AnnotationTypeFilter::new).collect(Collectors.toList()));
    }

    public static List<Class<?>> getClassesByFilters(ClassLoader classLoader, List<TypeFilter> includeFilters) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return true;
            }
        };
        provider.setResourceLoader((ResourceLoader)new PathMatchingResourcePatternResolver(classLoader));
        provider.setMetadataReaderFactory((MetadataReaderFactory)new SafeMetadataReaderFactory(provider.getMetadataReaderFactory()));
        provider.addExcludeFilter((metadata, factory) -> {
            String className = metadata.getClassMetadata().getClassName();
            return className.startsWith("org.springframework.") || className.startsWith("java.") || className.startsWith("jakarta.");
        });
        for (TypeFilter filter : includeFilters) {
            provider.addIncludeFilter(filter);
        }
        return provider.findCandidateComponents("").stream().map(b -> ReflectionHelper.asClass(b, classLoader)).collect(Collectors.toList());
    }

    private static Class<?> asClass(BeanDefinition bean, ClassLoader classLoader) {
        String beanClassName = bean.getBeanClassName();
        if (beanClassName == null) {
            LOG.debug("The name of the class corresponding to the bean '{}' could not be found", (Object)bean);
        } else {
            try {
                return ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                LOG.debug("The class corresponding to the bean '{}' could not be found: {}", (Object)bean, (Object)e.getMessage());
            }
        }
        return null;
    }

    private static class SafeMetadataReaderFactory
    implements MetadataReaderFactory {
        private static final MetadataReader DEFAULT = new MetadataReader(){

            public Resource getResource() {
                return new ByteArrayResource(new byte[0]);
            }

            public ClassMetadata getClassMetadata() {
                return AnnotationMetadata.introspect(Object.class);
            }

            public AnnotationMetadata getAnnotationMetadata() {
                return AnnotationMetadata.introspect(Object.class);
            }
        };
        private final MetadataReaderFactory delegate;

        SafeMetadataReaderFactory(MetadataReaderFactory delegate) {
            this.delegate = delegate;
        }

        public MetadataReader getMetadataReader(String className) {
            try {
                return this.delegate.getMetadataReader(className);
            }
            catch (Exception | NoClassDefFoundError e) {
                LOG.debug("Could not get the metadata of the class {}", (Object)className);
                return DEFAULT;
            }
        }

        public MetadataReader getMetadataReader(Resource resource) {
            try {
                return this.delegate.getMetadataReader(resource);
            }
            catch (Exception | NoClassDefFoundError e) {
                LOG.debug("Could not get the metadata of the resource {}", (Object)resource);
                return DEFAULT;
            }
        }
    }
}

